/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.DataModelAggregationFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.IDataModelAggregationFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.DataModelAggregationLookupCall;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IDataModelAggregationField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

@ClassId(value="678308dc-6f45-4284-9295-617b28b03cea")
public abstract class AbstractDataModelAggregationField
extends AbstractSmartField<Integer>
implements IDataModelAggregationField {
    public AbstractDataModelAggregationField() {
        this(true);
    }

    public AbstractDataModelAggregationField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected String getConfiguredLabel() {
        return ScoutTexts.get((String)"ComposerFieldAggregationLabel", (String[])new String[0]);
    }

    @Override
    protected Class<? extends ILookupCall<Integer>> getConfiguredLookupCall() {
        return DataModelAggregationLookupCall.class;
    }

    @Override
    protected boolean getConfiguredTreat0AsNull() {
        return false;
    }

    @Override
    protected void execAddSearchTerms(SearchFilter search) {
    }

    public IDataModelAttribute getAttribute() {
        return ((DataModelAggregationLookupCall)this.getLookupCall()).getAttribute();
    }

    public void setAttribute(IDataModelAttribute attribute) throws ProcessingException {
        ((DataModelAggregationLookupCall)this.getLookupCall()).setAttribute(attribute);
        if (attribute != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        this.interceptAttributeChanged(attribute);
        this.refreshDisplayText();
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execAttributeChanged(IDataModelAttribute attribute) throws ProcessingException {
        Integer newAg = null;
        if (attribute != null) {
            HashSet<Integer> agSet = new HashSet<Integer>();
            for (ILookupRow<Integer> row : ((DataModelAggregationLookupCall)this.getLookupCall()).getLookupRows()) {
                agSet.add((Integer)row.getKey());
            }
            if (agSet.contains(0)) {
                newAg = 0;
            } else if (agSet.contains(1)) {
                newAg = 1;
            } else if (agSet.size() > 0) {
                newAg = (Integer)agSet.iterator().next();
            }
        }
        this.setValue(newAg);
    }

    protected final void interceptAttributeChanged(IDataModelAttribute attribute) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        DataModelAggregationFieldChains.DataModelAggregationFieldAttributeChangedChain chain = new DataModelAggregationFieldChains.DataModelAggregationFieldAttributeChangedChain(extensions);
        chain.execAttributeChanged(attribute);
    }

    @Override
    protected IDataModelAggregationFieldExtension<? extends AbstractDataModelAggregationField> createLocalExtension() {
        return new LocalDataModelAggregationFieldExtension<AbstractDataModelAggregationField>(this);
    }

    protected static class LocalDataModelAggregationFieldExtension<OWNER extends AbstractDataModelAggregationField>
    extends AbstractSmartField.LocalSmartFieldExtension<Integer, OWNER>
    implements IDataModelAggregationFieldExtension<OWNER> {
        public LocalDataModelAggregationFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execAttributeChanged(DataModelAggregationFieldChains.DataModelAggregationFieldAttributeChangedChain chain, IDataModelAttribute attribute) throws ProcessingException {
            ((AbstractDataModelAggregationField)this.getOwner()).execAttributeChanged(attribute);
        }
    }
}

