/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.listbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@ClassId(value="ebca1411-044f-425f-b63c-4920cde6bb1b")
public abstract class AbstractListBoxFilterBox
extends AbstractGroupBox {
    private final OptimisticLock m_listBoxSyncLock = new OptimisticLock();
    private PropertyChangeListener m_listBoxPropertyListener;

    public AbstractListBoxFilterBox() {
        this(true);
    }

    public AbstractListBoxFilterBox(boolean callInitializer) {
        super(callInitializer);
    }

    protected abstract IListBox getListBox();

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 1;
    }

    @Override
    protected void execInitField() throws ProcessingException {
        if (this.m_listBoxPropertyListener == null) {
            this.m_listBoxPropertyListener = new PropertyChangeListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String name = e.getPropertyName();
                    if ("filterCheckedRows".equals(name)) {
                        AbstractListBoxFilterBox.this.updateVisibilities();
                        return;
                    }
                    if ("filterActiveRows".equals(name)) {
                        AbstractListBoxFilterBox.this.updateVisibilities();
                        return;
                    }
                    if ("filterCheckedRowsValue".equals(name)) {
                        try {
                            if (!AbstractListBoxFilterBox.this.m_listBoxSyncLock.acquire()) return;
                            AbstractListBoxFilterBox.this.getCheckedStateRadioButtonGroup().setValue(AbstractListBoxFilterBox.this.getListBox().getFilterCheckedRowsValue());
                            return;
                        }
                        finally {
                            AbstractListBoxFilterBox.this.m_listBoxSyncLock.release();
                        }
                    }
                    if (!"filterActiveRowsValue".equals(name)) return;
                    try {
                        if (!AbstractListBoxFilterBox.this.m_listBoxSyncLock.acquire()) return;
                        AbstractListBoxFilterBox.this.getActiveStateRadioButtonGroup().setValue(AbstractListBoxFilterBox.this.getListBox().getFilterActiveRowsValue());
                        return;
                    }
                    finally {
                        AbstractListBoxFilterBox.this.m_listBoxSyncLock.release();
                    }
                }
            };
            this.getListBox().addPropertyChangeListener(this.m_listBoxPropertyListener);
        }
        try {
            this.m_listBoxSyncLock.acquire();
            this.updateVisibilities();
            this.getCheckedStateRadioButtonGroup().setValue(this.getListBox().getFilterCheckedRowsValue());
            this.getActiveStateRadioButtonGroup().setValue(this.getListBox().getFilterActiveRowsValue());
        }
        finally {
            this.m_listBoxSyncLock.release();
        }
    }

    protected void updateVisibilities() {
        this.setVisible(this.getListBox().isFilterCheckedRows() || this.getListBox().isFilterActiveRows());
        this.getCheckedStateRadioButtonGroup().setVisible(this.getListBox().isFilterCheckedRows());
        this.getActiveStateRadioButtonGroup().setVisible(this.getListBox().isFilterActiveRows());
    }

    @Override
    protected void execDisposeField() throws ProcessingException {
        if (this.m_listBoxPropertyListener != null) {
            this.getListBox().removePropertyChangeListener(this.m_listBoxPropertyListener);
            this.m_listBoxPropertyListener = null;
        }
    }

    public ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(ActiveStateRadioButtonGroup.class);
    }

    public CheckedStateRadioButtonGroup getCheckedStateRadioButtonGroup() {
        return this.getFieldByClass(CheckedStateRadioButtonGroup.class);
    }

    @Order(value=20.0)
    public class ActiveStateRadioButtonGroup
    extends AbstractRadioButtonGroup<TriState> {
        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() throws ProcessingException {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() throws ProcessingException {
            return false;
        }

        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected void execChangedValue() throws ProcessingException {
            try {
                if (AbstractListBoxFilterBox.this.m_listBoxSyncLock.acquire()) {
                    AbstractListBoxFilterBox.this.getListBox().setFilterActiveRowsValue((TriState)AbstractListBoxFilterBox.this.getActiveStateRadioButtonGroup().getValue());
                }
            }
            finally {
                AbstractListBoxFilterBox.this.m_listBoxSyncLock.release();
            }
        }

        @Order(value=30.0)
        public class ActiveAndInactiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ActiveAndInactiveStates", (String[])new String[0]);
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.UNDEFINED;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        public class ActiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ActiveStates", (String[])new String[0]);
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.TRUE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=20.0)
        public class InactiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"InactiveStates", (String[])new String[0]);
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.FALSE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }

    @Order(value=10.0)
    public class CheckedStateRadioButtonGroup
    extends AbstractRadioButtonGroup<Boolean> {
        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() throws ProcessingException {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() throws ProcessingException {
            return false;
        }

        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected void execChangedValue() throws ProcessingException {
            try {
                if (AbstractListBoxFilterBox.this.m_listBoxSyncLock.acquire()) {
                    Boolean b = (Boolean)AbstractListBoxFilterBox.this.getCheckedStateRadioButtonGroup().getValue();
                    AbstractListBoxFilterBox.this.getListBox().setFilterCheckedRowsValue(b != null && b != false);
                }
            }
            finally {
                AbstractListBoxFilterBox.this.m_listBoxSyncLock.release();
            }
        }

        @Order(value=20.0)
        public class AllButton
        extends AbstractRadioButton<Boolean> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"AllStates", (String[])new String[0]);
            }

            @Override
            protected Boolean getConfiguredRadioValue() {
                return false;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        public class CheckedButton
        extends AbstractRadioButton<Boolean> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"SelectedStates", (String[])new String[0]);
            }

            @Override
            protected Boolean getConfiguredRadioValue() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }
}

