/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractContentAssistFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldDataFetchResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldTable;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.service.SERVICES;

public class ContentAssistTableForm<LOOKUP_KEY>
extends AbstractContentAssistFieldProposalForm<LOOKUP_KEY> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ContentAssistTableForm.class);
    private JobEx m_dataLoadJob;
    private LOOKUP_KEY m_lastSelectedKey;

    public ContentAssistTableForm(IContentAssistField<?, LOOKUP_KEY> contentAssistField, boolean allowCustomText) throws ProcessingException {
        super(contentAssistField, allowCustomText);
    }

    @Override
    public void forceProposalSelection() throws ProcessingException {
        MainBox.ResultTableField tableField = this.getResultTableField();
        IContentAssistFieldTable table = (IContentAssistFieldTable)tableField.getTable();
        table.selectNextRow();
    }

    @Override
    protected void dataFetchedDelegateImpl(IContentAssistFieldDataFetchResult<LOOKUP_KEY> result, int maxCount) {
        ArrayList rows = null;
        boolean selectCurrentValue = false;
        ProcessingException failed = null;
        String searchText = null;
        if (result != null) {
            rows = result.getLookupRows();
            selectCurrentValue = result.isSelectCurrentValue();
            failed = result.getProcessingException();
            searchText = result.getSearchText();
        }
        if (rows == null) {
            rows = CollectionUtility.emptyArrayList();
        }
        try {
            IContentAssistFieldTable table = (IContentAssistFieldTable)this.getResultTableField().getTable();
            table.setTableChanging(true);
            table.setLookupRows(CollectionUtility.truncateList((List)rows, (int)maxCount));
            try {
                Object keyToSelect = null;
                if (selectCurrentValue) {
                    this.m_lastSelectedKey = this.getContentAssistField().getValueAsLookupKey();
                    keyToSelect = this.m_lastSelectedKey;
                } else if (rows.size() == 1 && !this.isAllowCustomText()) {
                    keyToSelect = ((ILookupRow)CollectionUtility.firstElement((List)rows)).getKey();
                }
                if (keyToSelect != null) {
                    table.select(keyToSelect);
                }
            }
            finally {
                table.setTableChanging(false);
            }
            String statusText = null;
            int severity = 1;
            if (failed != null) {
                statusText = failed.getStatus().getMessage();
                severity = 4;
            } else if (rows.size() <= 0) {
                statusText = ScoutTexts.get((String)"SmartFieldCannotComplete", (String[])new String[]{searchText == null ? "" : searchText});
                severity = 2;
            } else if (rows.size() > this.getContentAssistField().getBrowseMaxRowCount()) {
                statusText = ScoutTexts.get((String)"SmartFieldMoreThanXRows", (String[])new String[]{"" + this.getContentAssistField().getBrowseMaxRowCount()});
                severity = 1;
            }
            if (statusText != null) {
                this.getResultTableField().setTablePopulateStatus((IProcessingStatus)new ProcessingStatus(statusText, severity));
            } else {
                this.getResultTableField().setTablePopulateStatus(null);
            }
            if (this.getNewButton().isEnabled()) {
                this.getNewButton().setVisible(table.getRowCount() <= 0);
            }
            this.structureChanged(this.getResultTableField());
        }
        catch (ProcessingException e) {
            LOG.warn("update proposal list", (Throwable)e);
        }
    }

    @Override
    public void setTablePopulateStatus(IProcessingStatus status) {
        this.getResultTableField().setTablePopulateStatus(status);
    }

    @ConfigOperation
    @Order(value=120.0)
    protected ILookupRow<LOOKUP_KEY> execGetSingleMatch() {
        int matchCount = 0;
        ILookupRow foundRow = null;
        IContentAssistFieldTable table = (IContentAssistFieldTable)this.getResultTableField().getTable();
        List values = table.getLookupRows();
        for (ILookupRow row : values) {
            if (!row.isEnabled()) continue;
            foundRow = row;
            ++matchCount;
        }
        if (matchCount == 1) {
            return foundRow;
        }
        return null;
    }

    @ConfigOperation
    @Order(value=130.0)
    protected void execResultTableRowClicked(ITableRow row) throws ProcessingException {
        IContentAssistFieldTable table = (IContentAssistFieldTable)this.getResultTableField().getTable();
        ILookupRow lrow = table.getSelectedLookupRow();
        if (lrow != null && lrow.isEnabled()) {
            this.doOk();
        }
    }

    @Override
    public ILookupRow<LOOKUP_KEY> getAcceptedProposal() throws ProcessingException {
        ILookupRow<LOOKUP_KEY> row = this.getSelectedLookupRow();
        if (row != null && row.isEnabled()) {
            return row;
        }
        if (this.isAllowCustomText()) {
            return null;
        }
        return this.execGetSingleMatch();
    }

    public ILookupRow<LOOKUP_KEY> getSelectedLookupRow() {
        IContentAssistFieldTable table = (IContentAssistFieldTable)this.getResultTableField().getTable();
        ILookupRow row = null;
        if (table.isCheckable()) {
            Collection<ITableRow> checkedRows = table.getCheckedRows();
            if (CollectionUtility.hasElements(checkedRows)) {
                row = table.getCheckedLookupRow();
            }
        } else {
            row = table.getSelectedLookupRow();
        }
        return row;
    }

    @Override
    public void startForm() throws ProcessingException {
        this.startInternal(new FormHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.ResultTableField getResultTableField() {
        return this.getFieldByClass(MainBox.ResultTableField.class);
    }

    public MainBox.ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(MainBox.ActiveStateRadioButtonGroup.class);
    }

    public MainBox.NewButton getNewButton() {
        return this.getFieldByClass(MainBox.NewButton.class);
    }

    protected void execDecorateTable(IContentAssistFieldTable<LOOKUP_KEY> table) {
    }

    private class FormHandler
    extends AbstractFormHandler {
        private FormHandler() {
        }

        @Override
        protected void execLoad() throws ProcessingException {
            Object table = ContentAssistTableForm.this.getResultTableField().getTable();
            if (table.getDefaultIconId() == null) {
                table.setDefaultIconId(ContentAssistTableForm.this.getContentAssistField().getBrowseIconId());
            }
            ContentAssistTableForm.this.getActiveStateRadioButtonGroup().setVisible(ContentAssistTableForm.this.getContentAssistField().isActiveFilterEnabled());
            ContentAssistTableForm.this.getActiveStateRadioButtonGroup().setValue(ContentAssistTableForm.this.getContentAssistField().getActiveFilter());
            ContentAssistTableForm.this.getNewButton().setEnabled(ContentAssistTableForm.this.getContentAssistField().getBrowseNewText() != null);
            ContentAssistTableForm.this.getNewButton().setLabel(ContentAssistTableForm.this.getContentAssistField().getBrowseNewText());
        }

        @Override
        protected boolean execValidate() throws ProcessingException {
            return ContentAssistTableForm.this.getAcceptedProposal() != null || ContentAssistTableForm.this.isAllowCustomText();
        }

        @Override
        protected void execFinally() throws ProcessingException {
            if (ContentAssistTableForm.this.m_dataLoadJob != null) {
                ContentAssistTableForm.this.m_dataLoadJob.cancel();
            }
        }
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Order(value=30.0)
        public class ActiveStateRadioButtonGroup
        extends AbstractRadioButtonGroup<TriState> {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected void execChangedValue() throws ProcessingException {
                if (this.isVisible() && !ContentAssistTableForm.this.isFormLoading()) {
                    ContentAssistTableForm.this.getContentAssistField().setActiveFilter((TriState)this.getValue());
                    ContentAssistTableForm.this.getContentAssistField().doSearch(false, false);
                }
            }

            @Order(value=30.0)
            public class ActiveAndInactiveButton
            extends AbstractRadioButton<TriState> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveAndInactiveStates", (String[])new String[0]);
                }

                @Override
                protected TriState getConfiguredRadioValue() {
                    return TriState.UNDEFINED;
                }
            }

            @Order(value=10.0)
            public class ActiveButton
            extends AbstractRadioButton<TriState> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveStates", (String[])new String[0]);
                }

                @Override
                protected TriState getConfiguredRadioValue() {
                    return TriState.TRUE;
                }
            }

            @Order(value=20.0)
            public class InactiveButton
            extends AbstractRadioButton<TriState> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"InactiveStates", (String[])new String[0]);
                }

                @Override
                protected TriState getConfiguredRadioValue() {
                    return TriState.FALSE;
                }
            }
        }

        @Order(value=40.0)
        public class NewButton
        extends AbstractButton {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredEnabled() {
                return false;
            }

            @Override
            protected boolean getConfiguredFillHorizontal() {
                return false;
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 3;
            }

            @Override
            protected boolean getConfiguredProcessButton() {
                return false;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                ContentAssistTableForm.this.getContentAssistField().doBrowseNew(ContentAssistTableForm.this.getSearchText());
            }
        }

        @Order(value=10.0)
        public class ResultTableField
        extends AbstractTableField<IContentAssistFieldTable<LOOKUP_KEY>> {
            @Override
            protected IContentAssistFieldTable<LOOKUP_KEY> createTable() {
                Class<IContentAssistFieldTable<?>> contentAssistFieldTableClazz = ContentAssistTableForm.this.getContentAssistField().getContentAssistFieldTableClass();
                if (contentAssistFieldTableClazz != null) {
                    try {
                        return (IContentAssistFieldTable)ConfigurationUtility.newInnerInstance(ContentAssistTableForm.this.getContentAssistField(), contentAssistFieldTableClazz);
                    }
                    catch (Exception e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + contentAssistFieldTableClazz.getName() + "'.", (Throwable)e));
                    }
                }
                return null;
            }

            @Override
            protected void execInitField() throws ProcessingException {
                ((IContentAssistFieldTable)this.getTable()).addTableListener(new TableListener(){

                    @Override
                    public void tableChangedBatch(List<? extends TableEvent> batch) {
                    }

                    @Override
                    public void tableChanged(TableEvent e) {
                        if (e.getType() == 810) {
                            try {
                                ContentAssistTableForm.this.execResultTableRowClicked((ITableRow)CollectionUtility.firstElement(e.getRows()));
                            }
                            catch (ProcessingException e1) {
                                LOG.warn("could not handle smart table selection.", (Object)e);
                            }
                        }
                    }
                });
                ContentAssistTableForm.this.execDecorateTable((IContentAssistFieldTable)this.getTable());
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 1.0;
            }

            @Override
            protected boolean getConfiguredGridUseUiWidth() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }

            @Override
            protected boolean getConfiguredTableStatusVisible() {
                return true;
            }

            @Override
            protected void execUpdateTableStatus() {
            }
        }
    }
}

