/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNodeBuilder;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractContentAssistFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldDataFetchResult;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCallFetcher;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class ContentAssistTreeForm<LOOKUP_KEY>
extends AbstractContentAssistFieldProposalForm<LOOKUP_KEY> {
    public static final QualifiedName JOB_PROPERTY_LOAD_TREE = new QualifiedName(ContentAssistTreeForm.class.getName(), "loadTree");
    private P_ActiveNodesFilter m_activeNodesFilter;
    private P_MatchingNodesFilter m_matchingNodesFilter;
    private boolean m_selectCurrentValueRequested;
    private boolean m_populateInitialTreeDone;
    private JobEx m_populateInitialTreeJob;

    public ContentAssistTreeForm(IContentAssistField<?, LOOKUP_KEY> contentAssistField, boolean allowCustomText) throws ProcessingException {
        super(contentAssistField, allowCustomText);
    }

    private void startPopulateInitialTree() throws ProcessingException {
        if (this.getContentAssistField().isBrowseLoadIncremental()) {
            this.getResultTreeField().loadRootNode();
            this.commitPopulateInitialTree(this.getResultTreeField().getTree());
            this.structureChanged(this.getResultTreeField());
        } else {
            this.getStatusField().setValue(ScoutTexts.get((String)"searchingProposals", (String[])new String[0]));
            this.getStatusField().setVisible(true);
            this.m_populateInitialTreeJob = this.getContentAssistField().callBrowseLookupInBackground(this.getContentAssistField().getWildcard(), 100000, TriState.UNDEFINED, new ILookupCallFetcher<LOOKUP_KEY>(){

                public void dataFetched(List<? extends ILookupRow<LOOKUP_KEY>> rows, ProcessingException failed) {
                    if (failed == null) {
                        try {
                            ContentAssistTreeForm.this.getStatusField().setVisible(false);
                            List<ITreeNode> subTree = new P_TreeNodeBuilder().createTreeNodes(rows, 0, true);
                            ITree tree = ContentAssistTreeForm.this.getResultTreeField().getTree();
                            try {
                                tree.setTreeChanging(true);
                                ContentAssistTreeForm.this.updateSubTree(tree, tree.getRootNode(), subTree);
                                if (ContentAssistTreeForm.this.getContentAssistField().isBrowseAutoExpandAll()) {
                                    tree.expandAll(ContentAssistTreeForm.this.getResultTreeField().getTree().getRootNode());
                                }
                                ContentAssistTreeForm.this.commitPopulateInitialTree(tree);
                            }
                            finally {
                                tree.setTreeChanging(false);
                            }
                            ContentAssistTreeForm.this.structureChanged(ContentAssistTreeForm.this.getResultTreeField());
                        }
                        catch (ProcessingException pe) {
                            failed = pe;
                        }
                    }
                    if (failed != null) {
                        ContentAssistTreeForm.this.getStatusField().setValue(TEXTS.get((String)"RequestProblem"));
                        ContentAssistTreeForm.this.getStatusField().setVisible(true);
                        return;
                    }
                }
            });
        }
    }

    private void commitPopulateInitialTree(ITree tree) throws ProcessingException {
        this.updateActiveFilter();
        if (this.m_selectCurrentValueRequested && tree.getSelectedNodeCount() == 0) {
            this.selectCurrentValueInternal();
        }
        this.m_populateInitialTreeDone = true;
        this.getContentAssistField().doSearch(this.m_selectCurrentValueRequested, true);
    }

    @Override
    public void forceProposalSelection() throws ProcessingException {
        ITree tree = this.getResultTreeField().getTree();
        tree.selectNextNode();
    }

    @Override
    protected void execInitForm() throws ProcessingException {
        this.m_activeNodesFilter = new P_ActiveNodesFilter();
        this.m_matchingNodesFilter = new P_MatchingNodesFilter();
        this.getResultTreeField().getTree().setIconId(this.getContentAssistField().getBrowseIconId());
        this.getResultTreeField().getTree().addTreeListener(new TreeAdapter(){

            @Override
            public void treeChanged(TreeEvent e) {
                switch (e.getType()) {
                    case 100: 
                    case 101: {
                        ContentAssistTreeForm.this.structureChanged(ContentAssistTreeForm.this.getResultTreeField());
                    }
                }
            }
        });
    }

    @ConfigOperation
    @Order(value=100.0)
    protected Pattern execCreatePatternForTreeFilter(String filterText) {
        String s = filterText;
        if (s == null) {
            s = "";
        }
        s = s.toLowerCase();
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop != null && desktop.isAutoPrefixWildcardForTextSearch()) {
            s = String.valueOf(this.getContentAssistField().getWildcard()) + s;
        }
        s = s.replace(this.getContentAssistField().getWildcard(), "@wildcard@");
        s = StringUtility.escapeRegexMetachars((String)s);
        if (!(s = s.replace("@wildcard@", ".*")).endsWith(".*")) {
            s = String.valueOf(s) + ".*";
        }
        return Pattern.compile(s, 32);
    }

    @ConfigOperation
    @Order(value=110.0)
    protected boolean execAcceptNodeByTreeFilter(Pattern filterPattern, ITreeNode node, int level) {
        IContentAssistField<?, Object> sf = this.getContentAssistField();
        ILookupRow row = (ILookupRow)node.getCell().getValue();
        if (node.isChildrenLoaded() && row != null) {
            String q1 = node.getTree().getPathText(node, "\n");
            String q2 = node.getTree().getPathText(node, " ");
            if (q1 != null && q2 != null) {
                String[] path;
                String[] stringArray = path = (String.valueOf(q1) + "\n" + q2).split("\n");
                int n = path.length;
                int n2 = 0;
                while (n2 < n) {
                    String pathText = stringArray[n2];
                    if (pathText != null && filterPattern.matcher(pathText.toLowerCase()).matches() && sf.acceptBrowseHierarchySelection(row.getKey(), level - 1, node.isLeaf())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        return true;
    }

    @ConfigOperation
    @Order(value=120.0)
    protected ILookupRow<LOOKUP_KEY> execGetSingleMatch() {
        if (this.getContentAssistField().isBrowseLoadIncremental()) {
            try {
                List rows = this.getContentAssistField().callTextLookup(this.getSearchText(), 2);
                if (rows != null && rows.size() == 1) {
                    return rows.get(0);
                }
                return null;
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                return null;
            }
        }
        final ArrayList foundLeafs = new ArrayList();
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                ILookupRow row;
                if (node.isEnabled() && node.isLeaf() && (row = (ILookupRow)node.getCell().getValue()) != null && row.isEnabled()) {
                    foundLeafs.add(row);
                }
                return foundLeafs.size() <= 2;
            }
        };
        this.getResultTreeField().getTree().visitVisibleTree(v);
        if (foundLeafs.size() == 1) {
            return (ILookupRow)foundLeafs.get(0);
        }
        return null;
    }

    protected void execResultTreeNodeClick(ITreeNode node) throws ProcessingException {
        this.doOk();
    }

    protected void injectResultTreeMenus(OrderedCollection<IMenu> menus) {
    }

    @Override
    public void setTablePopulateStatus(IProcessingStatus status) {
    }

    @Override
    protected void dataFetchedDelegateImpl(IContentAssistFieldDataFetchResult<LOOKUP_KEY> result, int maxCount) {
        String searchText = null;
        boolean selectCurrentValue = false;
        if (result != null) {
            selectCurrentValue = result.isSelectCurrentValue();
            searchText = result.getSearchText();
        }
        if (!this.m_populateInitialTreeDone) {
            this.m_selectCurrentValueRequested = selectCurrentValue;
            return;
        }
        ITree tree = this.getResultTreeField().getTree();
        try {
            tree.setTreeChanging(true);
            this.m_matchingNodesFilter.update(searchText);
            tree.addNodeFilter(this.m_matchingNodesFilter);
        }
        finally {
            tree.setTreeChanging(false);
        }
        Object statusText = null;
        this.getStatusField().setValue(statusText);
        this.getStatusField().setVisible(statusText != null);
        if (this.getNewButton().isEnabled()) {
            this.getNewButton().setVisible(this.execGetSingleMatch() == null);
        }
        this.structureChanged(this.getResultTreeField());
    }

    private void updateActiveFilter() {
        ITree tree = this.getResultTreeField().getTree();
        try {
            tree.setTreeChanging(true);
            if (this.getContentAssistField().isActiveFilterEnabled()) {
                this.m_activeNodesFilter.update(this.getContentAssistField().getActiveFilter());
            } else {
                this.m_activeNodesFilter.update(TriState.TRUE);
            }
            tree.addNodeFilter(this.m_activeNodesFilter);
        }
        finally {
            tree.setTreeChanging(false);
        }
        this.structureChanged(this.getResultTreeField());
    }

    private void updateSubTree(ITree tree, ITreeNode parentNode, List<ITreeNode> subTree) throws ProcessingException {
        if (tree == null || parentNode == null || subTree == null) {
            return;
        }
        tree.removeAllChildNodes(parentNode);
        tree.addChildNodes(parentNode, subTree);
    }

    @Override
    public ILookupRow<LOOKUP_KEY> getAcceptedProposal() throws ProcessingException {
        ILookupRow<LOOKUP_KEY> row = this.getSelectedLookupRow();
        if (row != null && row.isEnabled()) {
            return row;
        }
        if (this.isAllowCustomText()) {
            return null;
        }
        return this.execGetSingleMatch();
    }

    public ILookupRow<LOOKUP_KEY> getSelectedLookupRow() {
        ILookupRow row = null;
        ITree tree = this.getResultTreeField().getTree();
        ITreeNode node = null;
        if (tree.isCheckable()) {
            Set<ITreeNode> checkedNodes = tree.getCheckedNodes();
            if (CollectionUtility.hasElements(checkedNodes)) {
                node = (ITreeNode)CollectionUtility.firstElement(checkedNodes);
            }
        } else {
            node = tree.getSelectedNode();
        }
        if (node != null && node.isFilterAccepted() && node.isEnabled()) {
            row = (ILookupRow)node.getCell().getValue();
        }
        return row;
    }

    @Override
    public void startForm() throws ProcessingException {
        this.startInternal(new FormHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.ResultTreeField getResultTreeField() {
        return this.getFieldByClass(MainBox.ResultTreeField.class);
    }

    public MainBox.ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(MainBox.ActiveStateRadioButtonGroup.class);
    }

    public MainBox.StatusField getStatusField() {
        return this.getFieldByClass(MainBox.StatusField.class);
    }

    public MainBox.NewButton getNewButton() {
        return this.getFieldByClass(MainBox.NewButton.class);
    }

    private boolean selectCurrentValueInternal() throws ProcessingException {
        final Object selectedKey = this.getContentAssistField().getValueAsLookupKey();
        if (selectedKey != null) {
            ITree tree = this.getResultTreeField().getTree();
            final ArrayList matchingNodes = new ArrayList();
            tree.visitTree(new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    Object val = node.getCell().getValue();
                    if (val instanceof ILookupRow && CompareUtility.equals((Object)selectedKey, (Object)((ILookupRow)val).getKey())) {
                        matchingNodes.add(node);
                    }
                    return true;
                }
            });
            if (matchingNodes.size() > 0) {
                this.selectValue(tree, (ITreeNode)matchingNodes.get(0));
                int i = 1;
                while (i < matchingNodes.size()) {
                    ITreeNode node = (ITreeNode)matchingNodes.get(i);
                    tree.setNodeExpanded(node, true);
                    tree.ensureVisible((ITreeNode)matchingNodes.get(i));
                    ++i;
                }
                return true;
            }
            ITreeNode node = this.loadNodeWithKey(selectedKey);
            if (node != null) {
                this.selectValue(tree, node);
                return true;
            }
        }
        return false;
    }

    private void selectValue(ITree tree, ITreeNode node) {
        if (tree == null || node == null) {
            return;
        }
        tree.selectNode(node);
        if (tree.isCheckable()) {
            tree.setNodeChecked(node, true);
        }
    }

    private ITreeNode loadNodeWithKey(LOOKUP_KEY key) throws ProcessingException {
        ArrayList<ILookupRow<LOOKUP_KEY>> path = new ArrayList<ILookupRow<LOOKUP_KEY>>();
        Object t = key;
        while (t != null) {
            ILookupRow<LOOKUP_KEY> row = this.getLookupRowFor(t);
            if (row != null) {
                path.add(0, row);
                t = row.getParentKey();
                continue;
            }
            t = null;
        }
        ITree tree = this.getResultTreeField().getTree();
        ITreeNode parentNode = tree.getRootNode();
        int i = 0;
        while (i < path.size() && parentNode != null) {
            parentNode.ensureChildrenLoaded();
            parentNode.setExpanded(true);
            Object childKey = ((ILookupRow)path.get(i)).getKey();
            ITreeNode nextNode = null;
            for (ITreeNode n : parentNode.getChildNodes()) {
                if (!(n.getCell().getValue() instanceof ILookupRow) || !CompareUtility.equals((Object)((ILookupRow)n.getCell().getValue()).getKey(), (Object)childKey)) continue;
                nextNode = n;
                break;
            }
            parentNode = nextNode;
            ++i;
        }
        return parentNode;
    }

    private ILookupRow<LOOKUP_KEY> getLookupRowFor(LOOKUP_KEY key) throws ProcessingException {
        IContentAssistField<?, LOOKUP_KEY> sf;
        Iterator iterator;
        if (key instanceof Number && ((Number)key).longValue() == 0L) {
            key = null;
        }
        if (key != null && (iterator = (sf = this.getContentAssistField()).callKeyLookup(key).iterator()).hasNext()) {
            ILookupRow row = iterator.next();
            return row;
        }
        return null;
    }

    private class FormHandler
    extends AbstractFormHandler {
        private FormHandler() {
        }

        @Override
        protected void execLoad() throws ProcessingException {
            ContentAssistTreeForm.this.getActiveStateRadioButtonGroup().setVisible(ContentAssistTreeForm.this.getContentAssistField().isActiveFilterEnabled());
            ContentAssistTreeForm.this.getActiveStateRadioButtonGroup().setValue(ContentAssistTreeForm.this.getContentAssistField().getActiveFilter());
            ContentAssistTreeForm.this.getNewButton().setEnabled(ContentAssistTreeForm.this.getContentAssistField().getBrowseNewText() != null);
            ContentAssistTreeForm.this.getNewButton().setLabel(ContentAssistTreeForm.this.getContentAssistField().getBrowseNewText());
            ContentAssistTreeForm.this.startPopulateInitialTree();
        }

        @Override
        protected boolean execValidate() throws ProcessingException {
            return ContentAssistTreeForm.this.getAcceptedProposal() != null;
        }

        @Override
        protected void execFinally() throws ProcessingException {
            if (ContentAssistTreeForm.this.m_populateInitialTreeJob != null) {
                ContentAssistTreeForm.this.m_populateInitialTreeJob.cancel();
            }
        }
    }

    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Override
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        @Order(value=20.0)
        public class ActiveStateRadioButtonGroup
        extends AbstractRadioButtonGroup<TriState> {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected void execChangedValue() throws ProcessingException {
                if (this.isVisible() && !ContentAssistTreeForm.this.isFormLoading()) {
                    ContentAssistTreeForm.this.getContentAssistField().setActiveFilter((TriState)this.getValue());
                    ContentAssistTreeForm.this.updateActiveFilter();
                }
            }

            @Order(value=3.0)
            public class ActiveAndInactiveButton
            extends AbstractRadioButton<TriState> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveAndInactiveStates", (String[])new String[0]);
                }

                @Override
                protected TriState getConfiguredRadioValue() {
                    return TriState.UNDEFINED;
                }
            }

            @Order(value=1.0)
            public class ActiveButton
            extends AbstractRadioButton<TriState> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveStates", (String[])new String[0]);
                }

                @Override
                protected TriState getConfiguredRadioValue() {
                    return TriState.TRUE;
                }
            }

            @Order(value=2.0)
            public class InactiveButton
            extends AbstractRadioButton<TriState> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"InactiveStates", (String[])new String[0]);
                }

                @Override
                protected TriState getConfiguredRadioValue() {
                    return TriState.FALSE;
                }
            }
        }

        @Order(value=25.0)
        public class NewButton
        extends AbstractButton {
            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredEnabled() {
                return false;
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredFillHorizontal() {
                return false;
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 3;
            }

            @Override
            protected boolean getConfiguredProcessButton() {
                return false;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                ContentAssistTreeForm.this.getContentAssistField().doBrowseNew(ContentAssistTreeForm.this.getSearchText());
            }
        }

        @Order(value=10.0)
        public class ResultTreeField
        extends AbstractTreeField {
            @Override
            protected boolean getConfiguredAutoLoad() {
                return false;
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 1.0;
            }

            @Override
            protected boolean getConfiguredGridUseUiWidth() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected void execLoadChildNodes(ITreeNode parentNode) throws ProcessingException {
                IContentAssistField<?, Object> contentAssistField = ContentAssistTreeForm.this.getContentAssistField();
                if (contentAssistField.isBrowseLoadIncremental()) {
                    Job currentJob = Job.getJobManager().currentJob();
                    boolean statusWasVisible = ContentAssistTreeForm.this.getStatusField().isVisible();
                    ContentAssistTreeForm.this.getStatusField().setValue(ScoutTexts.get((String)"searchingProposals", (String[])new String[0]));
                    ContentAssistTreeForm.this.getStatusField().setVisible(true);
                    try {
                        currentJob.setProperty(JOB_PROPERTY_LOAD_TREE, (Object)Boolean.TRUE);
                        LookupRow b = (LookupRow)(parentNode != null ? parentNode.getCell().getValue() : null);
                        List<ILookupRow<Object>> data = contentAssistField.callSubTreeLookup(b != null ? b.getKey() : null, TriState.UNDEFINED);
                        List<ITreeNode> subTree = new P_TreeNodeBuilder().createTreeNodes(data, 0, false);
                        ContentAssistTreeForm.this.updateSubTree(this.getTree(), parentNode, subTree);
                    }
                    finally {
                        currentJob.setProperty(JOB_PROPERTY_LOAD_TREE, null);
                    }
                    ContentAssistTreeForm.this.getStatusField().setVisible(statusWasVisible);
                }
            }

            @Order(value=4.0)
            public class Tree
            extends AbstractTree {
                @Override
                protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
                    ContentAssistTreeForm.this.injectResultTreeMenus(menus);
                }

                @Override
                protected boolean getConfiguredMultiSelect() {
                    return false;
                }

                @Override
                protected boolean getConfiguredMultiCheck() {
                    return false;
                }

                @Override
                protected boolean getConfiguredRootNodeVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredScrollToSelection() {
                    return true;
                }

                @Override
                protected void execNodeClick(ITreeNode node, MouseButton mouseButton) throws ProcessingException {
                    ContentAssistTreeForm.this.execResultTreeNodeClick(node);
                }
            }
        }

        @Order(value=30.0)
        public class StatusField
        extends AbstractLabelField {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 1.0;
            }
        }
    }

    private class P_ActiveNodesFilter
    implements ITreeNodeFilter {
        private TriState m_ts;

        public void update(TriState ts) {
            this.m_ts = ts;
        }

        @Override
        public boolean accept(ITreeNode node, int level) {
            if (this.m_ts.isUndefined()) {
                return true;
            }
            LookupRow row = (LookupRow)node.getCell().getValue();
            if (row != null) {
                return row.isActive() == this.m_ts.equals((Object)TriState.TRUE);
            }
            return true;
        }
    }

    private class P_MatchingNodesFilter
    implements ITreeNodeFilter {
        private Pattern m_searchPattern;

        public void update(String text) {
            this.m_searchPattern = ContentAssistTreeForm.this.execCreatePatternForTreeFilter(text);
        }

        @Override
        public boolean accept(ITreeNode node, int level) {
            return ContentAssistTreeForm.this.execAcceptNodeByTreeFilter(this.m_searchPattern, node, level);
        }
    }

    private class P_TreeNodeBuilder
    extends AbstractTreeNodeBuilder<LOOKUP_KEY> {
        private P_TreeNodeBuilder() {
        }

        @Override
        protected ITreeNode createEmptyTreeNode() throws ProcessingException {
            ITree tree = ContentAssistTreeForm.this.getResultTreeField().getTree();
            ITreeNode node = ContentAssistTreeForm.this.getResultTreeField().createTreeNode();
            if (tree.getIconId() != null) {
                Cell cell = node.getCellForUpdate();
                cell.setIconId(tree.getIconId());
            }
            return node;
        }
    }
}

