/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.jms;

import java.util.Date;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.jms.AbstractJndiService;
import org.eclipse.scout.rt.server.jms.IJmsMessageSerializer;
import org.eclipse.scout.rt.server.jms.JmsMessageSerializer;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractJmsService<T>
extends AbstractJndiService {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(AbstractJmsService.class);
    private String m_connectionFactory;
    private String m_destination;
    private Connection m_connection;

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    protected String getConfiguredConnectionFactory() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=20.0)
    protected String getConfiguredDestination() {
        return null;
    }

    public String getConnectionFactory() {
        return this.m_connectionFactory;
    }

    public void setConnectionFactory(String connectionFactory) {
        this.m_connectionFactory = connectionFactory;
    }

    public String getDestination() {
        return this.m_destination;
    }

    public void setDestination(String destination) {
        this.m_destination = destination;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setConnectionFactory(this.getConfiguredConnectionFactory());
        this.setDestination(this.getConfiguredDestination());
    }

    protected ConnectionFactory lookupConnectionFactory() throws ProcessingException {
        return this.lookup(this.getConnectionFactory(), ConnectionFactory.class);
    }

    protected Destination lookupDestination() throws ProcessingException {
        return this.lookup(this.getDestination(), Destination.class);
    }

    protected boolean isEnabled() {
        return this.getConnectionFactory() != null && this.getDestination() != null;
    }

    protected Class<T> getMessageType() {
        return TypeCastUtility.getGenericsParameterClass(((Object)((Object)this)).getClass(), AbstractJmsService.class);
    }

    protected IJmsMessageSerializer<T> createMessageSerializer() {
        return new JmsMessageSerializer<T>(this.getMessageType());
    }

    protected synchronized Connection getConnection() {
        return this.m_connection;
    }

    protected synchronized void setupConnection() throws ProcessingException {
        Connection con;
        this.closeConnection();
        ConnectionFactory connectionFactory = this.lookupConnectionFactory();
        try {
            con = connectionFactory.createConnection();
        }
        catch (JMSException e) {
            throw new ProcessingException("Failed creating JMS connection", (Throwable)e);
        }
        String clientId = null;
        try {
            clientId = this.createClientId();
            con.setClientID(clientId);
        }
        catch (Exception e) {
            LOG.info("Failed to set clientID '{0}' for consumer connection, possibly because of running in J2EE container: {1}", (Object)clientId, (Object)e.getMessage());
            LOG.trace("Full Exception:", (Throwable)e);
        }
        this.m_connection = con;
    }

    protected synchronized void closeConnection() throws ProcessingException {
        Connection connection = this.m_connection;
        if (connection != null) {
            this.m_connection = null;
            try {
                connection.close();
            }
            catch (JMSException e) {
                throw new ProcessingException("Failed closing JMS connection", (Throwable)e);
            }
        }
    }

    protected String createClientId() {
        String serverVersion = null;
        try {
            serverVersion = Platform.getProduct().getDefiningBundle().getVersion().toString();
        }
        catch (Exception e) {
            LOG.warn("Cannot determine server version", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName()).append(" ");
        if (serverVersion != null) {
            sb.append(serverVersion).append(" ");
        }
        sb.append("nodeId=").append(((IClusterSynchronizationService)SERVICES.getService(IClusterSynchronizationService.class)).getNodeId()).append(" ");
        sb.append("registered at ");
        sb.append(DateUtility.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss,SSS"));
        return sb.toString();
    }
}

