/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.jms;

import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.jms.AbstractJmsService;
import org.eclipse.scout.rt.server.jms.IJmsMessageSerializer;

public abstract class AbstractSimpleJmsService<T>
extends AbstractJmsService<T> {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSimpleJmsService.class);
    private MessageConsumerJob m_messageConsumerJob;

    protected Session createSession(Connection connection) throws JMSException {
        return connection.createSession(false, 1);
    }

    protected void send(List<T> messages) {
        block15: {
            if (messages == null || messages.isEmpty()) {
                return;
            }
            Connection connection = this.getConnection();
            if (!this.isEnabled() || connection == null) {
                LOG.warn("Tried to send messages on a not active or enabled JMS message service");
                return;
            }
            Session session = null;
            MessageProducer producer = null;
            try {
                try {
                    session = this.createSession(connection);
                    producer = session.createProducer(this.lookupDestination());
                    IJmsMessageSerializer<T> serializer = this.createMessageSerializer();
                    for (T message : messages) {
                        producer.send(serializer.createMessage(message, session));
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed sending messages", (Throwable)e);
                    if (session == null) break block15;
                    try {
                        session.close();
                    }
                    catch (JMSException e2) {
                        LOG.error("Failed closing", (Throwable)e2);
                    }
                }
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (JMSException e) {
                        LOG.error("Failed closing", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void execOnMessage(T message, Session session, IProgressMonitor monitor) {
    }

    protected synchronized boolean isMessageConsumerJobRunning() {
        return this.m_messageConsumerJob != null;
    }

    protected synchronized void startMessageConsumerJob() throws ProcessingException {
        this.stopMessageConsumerJob();
        this.m_messageConsumerJob = this.createMessageConsumerJob();
        this.m_messageConsumerJob.schedule();
    }

    protected synchronized void stopMessageConsumerJob() throws ProcessingException {
        MessageConsumerJob job = this.m_messageConsumerJob;
        if (job != null) {
            this.m_messageConsumerJob = null;
            job.cancel();
            try {
                job.join(job.getReceiveTimeout() * 3L);
            }
            catch (InterruptedException e) {
                throw new ProcessingException("Interrupted", (Throwable)e);
            }
            job.throwOnError();
        }
    }

    protected MessageConsumerJob createMessageConsumerJob() throws ProcessingException {
        return new MessageConsumerJob(this.getConnection());
    }

    protected class MessageConsumerJob
    extends JobEx {
        private final IJmsMessageSerializer<T> m_messageSerializer;
        private final Connection m_connection;
        private final Session m_session;
        private final MessageConsumer m_consumer;

        public MessageConsumerJob(Connection connection) throws ProcessingException {
            super("JMS message receiver");
            this.m_messageSerializer = AbstractSimpleJmsService.this.createMessageSerializer();
            this.m_connection = connection;
            try {
                this.m_session = AbstractSimpleJmsService.this.createSession(connection);
                this.m_consumer = this.m_session.createConsumer(AbstractSimpleJmsService.this.lookupDestination());
            }
            catch (JMSException e) {
                throw new ProcessingException("Failed initializing MessageConsumerJob", (Throwable)e);
            }
            if (this.m_messageSerializer == null || this.m_consumer == null) {
                throw new IllegalArgumentException("Connection nor consumer can be null");
            }
        }

        protected long getReceiveTimeout() {
            return 1000L;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus result;
            block18: {
                LOG.info("JMS message consumer job started.");
                result = Status.OK_STATUS;
                try {
                    try {
                        this.m_connection.start();
                        while (!monitor.isCanceled()) {
                            this.onMessage(this.m_consumer.receive(this.getReceiveTimeout()), monitor);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected exception while receiving messages from consumer.", (Throwable)e);
                        result = new Status(4, "org.eclipse.scout.rt.server.jms", e.getMessage());
                        LOG.trace("Stopping JMS message consumer job...");
                        try {
                            this.m_connection.stop();
                        }
                        catch (Exception e2) {
                            LOG.info("Unable to stop connection, possibly because of running in J2EE container: {0}", (Object)e2.getMessage());
                            LOG.trace("Full Exception:", (Throwable)e2);
                        }
                        try {
                            this.m_session.close();
                        }
                        catch (Exception e3) {
                            LOG.error("Unexpected exception", (Throwable)e3);
                            result = new Status(4, "org.eclipse.scout.rt.server.jms", e3.getMessage());
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    LOG.trace("Stopping JMS message consumer job...");
                    try {
                        this.m_connection.stop();
                    }
                    catch (Exception e) {
                        LOG.info("Unable to stop connection, possibly because of running in J2EE container: {0}", (Object)e.getMessage());
                        LOG.trace("Full Exception:", (Throwable)e);
                    }
                    try {
                        this.m_session.close();
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected exception", (Throwable)e);
                        result = new Status(4, "org.eclipse.scout.rt.server.jms", e.getMessage());
                    }
                    throw throwable;
                }
                LOG.trace("Stopping JMS message consumer job...");
                try {
                    this.m_connection.stop();
                }
                catch (Exception e) {
                    LOG.info("Unable to stop connection, possibly because of running in J2EE container: {0}", (Object)e.getMessage());
                    LOG.trace("Full Exception:", (Throwable)e);
                }
                try {
                    this.m_session.close();
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                    result = new Status(4, "org.eclipse.scout.rt.server.jms", e.getMessage());
                }
            }
            LOG.info("JMS message consumer job stopped.");
            return result;
        }

        protected void onMessage(Message jmsMessage, IProgressMonitor monitor) {
            if (jmsMessage != null) {
                try {
                    Object message = this.m_messageSerializer.extractMessage(jmsMessage);
                    if (message != null) {
                        AbstractSimpleJmsService.this.execOnMessage(message, this.m_session, monitor);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                }
            }
        }
    }
}

