/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.jms;

import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.IObjectSerializer;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.jms.IJmsMessageSerializer;

public class JmsMessageSerializer<T>
implements IJmsMessageSerializer<T> {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(JmsMessageSerializer.class);
    private static final String JMS_PROPERTY_TRACE_MESSAGE_CONTENT = "traceMessageContent";
    private final IObjectSerializer m_objectSerializer;
    private final Class<T> m_messageType;

    public JmsMessageSerializer(Class<T> messageType) {
        this(SerializationUtility.createObjectSerializer(), messageType);
    }

    protected JmsMessageSerializer(IObjectSerializer objectSerializer, Class<T> messageType) {
        this.m_objectSerializer = objectSerializer;
        this.m_messageType = messageType;
    }

    protected Class<T> getMessageType() {
        return this.m_messageType;
    }

    protected IObjectSerializer getObjectSerializer() {
        return this.m_objectSerializer;
    }

    @Override
    public Message createMessage(T message, Session session) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("creating JMS message: msgContent={0}", message);
        }
        BytesMessage jmsMessage = session.createBytesMessage();
        jmsMessage.writeBytes(this.getObjectSerializer().serialize(message));
        if (LOG.isTraceEnabled()) {
            jmsMessage.setStringProperty(JMS_PROPERTY_TRACE_MESSAGE_CONTENT, message.toString());
        }
        return jmsMessage;
    }

    @Override
    public T extractMessage(Message jmsMessage) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("extracting JMS message: jmsMessageId={0}, messageContent={1}", (Object)jmsMessage.getJMSMessageID(), (Object)jmsMessage.getStringProperty(JMS_PROPERTY_TRACE_MESSAGE_CONTENT));
        }
        if (!(jmsMessage instanceof BytesMessage)) {
            LOG.warn("Received unexpect message content. Ignored.");
            return null;
        }
        BytesMessage bm = (BytesMessage)jmsMessage;
        long bodyLength = bm.getBodyLength();
        if (bodyLength == Integer.MAX_VALUE) {
            LOG.warn("received empty BytesMessage");
        } else if (bodyLength > Integer.MAX_VALUE) {
            LOG.warn("received BytesMessage is too large (length = " + bodyLength + ")");
        } else {
            byte[] buffer = new byte[(int)bodyLength];
            bm.readBytes(buffer);
            return (T)this.getObjectSerializer().deserialize(buffer, this.getMessageType());
        }
        return null;
    }
}

