/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.jms.clustersync;

import java.util.List;
import javax.jms.Session;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.jms.AbstractSimpleJmsService;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IPublishSubscribeMessageListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IPublishSubscribeMessageService;

public class JmsPublishSubscribeMessageService
extends AbstractSimpleJmsService<IClusterNotificationMessage>
implements IPublishSubscribeMessageService {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(JmsPublishSubscribeMessageService.class);
    private volatile IPublishSubscribeMessageListener m_listener;

    public void setListener(IPublishSubscribeMessageListener listener) {
        this.m_listener = listener;
    }

    public IPublishSubscribeMessageListener getListener() {
        return this.m_listener;
    }

    public void subscribe() throws ProcessingException {
        if (!this.isEnabled()) {
            throw new ProcessingException("Cluster synchronization is not enabled: missing connectionFactory or topic configuration properties.");
        }
        this.setupConnection();
        this.startMessageConsumerJob();
        LOG.info("Cluster synchronization is enabled and JMS message listener is registered");
    }

    public void unsubsribe() throws ProcessingException {
        if (!this.isEnabled()) {
            LOG.info("Cluster synchronization is not enabled");
            return;
        }
        try {
            this.stopMessageConsumerJob();
        }
        finally {
            this.closeConnection();
        }
        LOG.info("Cluster synchronization is stopped");
    }

    public void publishNotifications(List<IClusterNotificationMessage> notificationMessages) {
        this.send(notificationMessages);
    }

    @Override
    protected void execOnMessage(IClusterNotificationMessage message, Session session, IProgressMonitor monitor) {
        IPublishSubscribeMessageListener listener = this.getListener();
        if (listener != null) {
            listener.onMessage(message);
        }
    }
}

