/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.jms.transactional;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.jms.IJmsMessageSerializer;
import org.eclipse.scout.rt.server.transaction.AbstractTransactionMember;

public class JmsTransactionMember<T>
extends AbstractTransactionMember {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JmsTransactionMember.class);
    private final Connection m_connection;
    private final Session m_session;
    private final Destination m_destination;
    private final IJmsMessageSerializer<T> m_messageSerializer;
    private MessageConsumer m_messageConsumer;
    private MessageProducer m_messageProducer;

    public JmsTransactionMember(String transactionMemberId, Connection connection, Session session, Destination destination, IJmsMessageSerializer<T> messageSerializer) {
        super(transactionMemberId);
        if (connection == null || session == null || destination == null || messageSerializer == null) {
            throw new IllegalArgumentException("None of the arguments can be null");
        }
        this.m_connection = connection;
        this.m_session = session;
        this.m_destination = destination;
        this.m_messageSerializer = messageSerializer;
    }

    protected Connection getConnection() {
        return this.m_connection;
    }

    protected Session getSession() {
        return this.m_session;
    }

    protected Destination getDestination() {
        return this.m_destination;
    }

    protected IJmsMessageSerializer<T> getMessageSerializer() {
        return this.m_messageSerializer;
    }

    protected MessageConsumer getMessageConsumer() throws JMSException {
        if (this.m_messageConsumer == null) {
            this.m_messageConsumer = this.m_session.createConsumer(this.m_destination);
        }
        return this.m_messageConsumer;
    }

    protected MessageProducer getMessageProducer() throws JMSException {
        if (this.m_messageProducer == null) {
            this.m_messageProducer = this.m_session.createProducer(this.m_destination);
        }
        return this.m_messageProducer;
    }

    public void send(T message) throws ProcessingException {
        try {
            this.getMessageProducer().send(this.getMessageSerializer().createMessage(message, this.getSession()));
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to send jms message", (Throwable)e);
        }
    }

    public T receive(long timeoutMillis) throws ProcessingException {
        try {
            Message jmsMessage = timeoutMillis > 0L ? this.getMessageConsumer().receive(timeoutMillis) : (timeoutMillis == 0L ? this.getMessageConsumer().receiveNoWait() : this.getMessageConsumer().receive());
            return this.getMessageSerializer().extractMessage(jmsMessage);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to receive jms message", (Throwable)e);
        }
    }

    public boolean needsCommit() {
        return this.m_messageProducer != null || this.m_messageConsumer != null;
    }

    public boolean commitPhase1() {
        return true;
    }

    public void commitPhase2() {
        try {
            this.getSession().commit();
        }
        catch (JMSException ex) {
            LOG.error("commit: " + this.getSession(), (Throwable)ex);
        }
    }

    public void rollback() {
        try {
            this.getSession().rollback();
        }
        catch (JMSException ex) {
            LOG.error("rollback: " + this.getSession(), (Throwable)ex);
        }
    }

    public void release() {
        try {
            this.getSession().close();
        }
        catch (JMSException ex) {
            LOG.error("release", (Throwable)ex);
        }
    }
}

