/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ITransactionRunnable;
import org.eclipse.scout.rt.server.ServerJob;

public class ServerJobFactory
implements IServerJobFactory {
    private final IServerSession m_serverSession;
    private final Subject m_subject;

    public ServerJobFactory(IServerSession serverSession, Subject subject) {
        this.m_serverSession = serverSession;
        this.m_subject = subject;
    }

    @Override
    public ServerJob create(String name, final ITransactionRunnable r) {
        return new ServerJob(name, this.m_serverSession, this.m_subject){

            @Override
            protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                return r.run(monitor);
            }
        };
    }

    @Override
    public ServerJob runNow(String name, ITransactionRunnable r) throws ProcessingException {
        ServerJob job = this.create(name, r);
        job.setSystem(true);
        job.runNow((IProgressMonitor)new NullProgressMonitor());
        job.throwOnError();
        return job;
    }
}

