/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.DefaultTransactionDelegate;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.VirtualSessionCache;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.commons.cache.IClientIdentificationService;
import org.eclipse.scout.rt.server.commons.cache.IHttpSessionCacheService;
import org.eclipse.scout.rt.server.commons.servletfilter.HttpServletEx;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.internal.ServerSessionClassFinder;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.rt.shared.servicetunnel.DefaultServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelResponse;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ServiceTunnelServlet
extends HttpServletEx {
    public static final String HTTP_DEBUG_PARAM = "org.eclipse.scout.rt.server.http.debug";
    public static final String MULTI_CLIENT_SESSION_COOKIESTORE = "org.eclipse.scout.rt.multiClientSessionCookieStoreEnabled";
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServiceTunnelServlet.class);
    private transient IServiceTunnelContentHandler m_contentHandler;
    private transient Bundle[] m_orderedBundleList;
    private final Object m_orderedBundleListLock = new Object();
    private final Object m_msgEncoderLock = new Object();
    private Class<? extends IServerSession> m_serverSessionClass;
    private Version m_requestMinVersion;
    private final boolean m_debug;
    private final boolean m_isMultiClientSessionCookieStore;
    private final VirtualSessionCache m_ajaxSessionCache = new VirtualSessionCache();
    private volatile boolean m_isAjaxSessionTimeoutInitialized = false;

    public ServiceTunnelServlet(boolean multiClientSessionCookieStore, boolean debug) {
        this.m_isMultiClientSessionCookieStore = multiClientSessionCookieStore;
        this.m_debug = debug;
    }

    public ServiceTunnelServlet() {
        this(StringUtility.parseBoolean((String)Activator.getDefault().getBundle().getBundleContext().getProperty(MULTI_CLIENT_SESSION_COOKIESTORE), (boolean)true), StringUtility.parseBoolean((String)Activator.getDefault().getBundle().getBundleContext().getProperty(HTTP_DEBUG_PARAM)));
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_requestMinVersion = this.initRequestMinVersion(config);
    }

    protected void lazyInit(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        if (this.m_serverSessionClass == null) {
            this.m_serverSessionClass = this.locateServerSessionClass(req, res);
        }
        if (this.m_serverSessionClass == null) {
            this.m_serverSessionClass = this.loadSessionClassByParam();
        }
        if (this.m_serverSessionClass == null) {
            this.m_serverSessionClass = new ServerSessionClassFinder().findClassByConvention(req.getServletPath());
        }
        if (this.m_serverSessionClass == null) {
            throw new ServletException("Expected init-param \"session\"");
        }
    }

    private Class<? extends IServerSession> loadSessionClassByParam() throws ServletException {
        String qname = this.getServletConfig().getInitParameter("session");
        if (qname != null) {
            int i = qname.lastIndexOf(46);
            try {
                this.m_serverSessionClass = Platform.getBundle((String)qname.substring(0, i)).loadClass(qname);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("Loading class " + qname, (Throwable)e);
            }
        }
        return null;
    }

    protected Class<? extends IServerSession> locateServerSessionClass(HttpServletRequest req, HttpServletResponse res) {
        try {
            return ((IServerJobService)SERVICES.getService(IServerJobService.class)).getServerSessionClass();
        }
        catch (ProcessingException e) {
            LOG.debug("No server session found");
            return null;
        }
    }

    protected Version initRequestMinVersion(ServletConfig config) {
        Version version = null;
        String v = config.getInitParameter("min-version");
        if (v != null) {
            Version tmp = Version.parseVersion((String)v);
            version = new Version(tmp.getMajor(), tmp.getMinor(), tmp.getMicro());
        } else if (Platform.getProduct() != null) {
            v = (String)Platform.getProduct().getDefiningBundle().getHeaders().get("Bundle-Version");
            Version tmp = Version.parseVersion((String)v);
            version = new Version(tmp.getMajor(), tmp.getMinor(), tmp.getMicro());
        }
        return version;
    }

    protected IServiceTunnelContentHandler createContentHandler(Class<? extends IServerSession> sessionClass) {
        DefaultServiceTunnelContentHandler e = new DefaultServiceTunnelContentHandler();
        e.initialize();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServiceTunnelContentHandler getServiceTunnelContentHandler() {
        Object object = this.m_msgEncoderLock;
        synchronized (object) {
            if (this.m_contentHandler == null) {
                this.m_contentHandler = this.createContentHandler(this.m_serverSessionClass);
            }
        }
        return this.m_contentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected Bundle[] getOrderedBundleList() {
        Object object = this.m_orderedBundleListLock;
        synchronized (object) {
            if (this.m_orderedBundleList == null) {
                String[] bundleOrderPrefixes = SerializationUtility.getBundleOrderPrefixes();
                this.m_orderedBundleList = BundleInspector.getOrderedBundleList((String[])bundleOrderPrefixes);
            }
        }
        return this.m_orderedBundleList;
    }

    protected IServerSession lookupServerSession(HttpServletRequest req, HttpServletResponse res, Subject subject, IServiceTunnelRequest serviceRequest) throws ProcessingException, ServletException {
        UserAgent userAgent = UserAgent.createByIdentifier((String)serviceRequest.getUserAgent());
        String virtualSessionId = serviceRequest.getVirtualSessionId();
        if (virtualSessionId != null && !this.m_isMultiClientSessionCookieStore) {
            return this.lookupScoutServerSessionOnVirtualSession(req, res, virtualSessionId, subject, userAgent);
        }
        return this.lookupScoutServerSessionOnHttpSession(req, res, subject, userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IServerSession lookupScoutServerSessionOnHttpSession(HttpServletRequest req, HttpServletResponse res, Subject subject, UserAgent userAgent) throws ProcessingException, ServletException {
        IHttpSessionCacheService cacheService = (IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class);
        IServerSession serverSession = (IServerSession)cacheService.getAndTouch(IServerSession.class.getName(), req, res);
        if (serverSession == null) {
            HttpSession httpSession = req.getSession();
            synchronized (httpSession) {
                serverSession = (IServerSession)cacheService.get(IServerSession.class.getName(), req, res);
                if (serverSession == null) {
                    serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(this.m_serverSessionClass, subject, userAgent);
                    serverSession.setIdInternal(((IClientIdentificationService)SERVICES.getService(IClientIdentificationService.class)).getClientId(req, res));
                    cacheService.put(IServerSession.class.getName(), (Object)serverSession, req, res);
                }
            }
        }
        return serverSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServerSession lookupScoutServerSessionOnVirtualSession(HttpServletRequest req, HttpServletResponse res, String ajaxSessionId, Subject subject, UserAgent userAgent) throws ProcessingException, ServletException {
        this.initializeAjaxSessionTimeout(req);
        IServerSession serverSession = (IServerSession)this.m_ajaxSessionCache.get(ajaxSessionId);
        if (serverSession == null) {
            VirtualSessionCache virtualSessionCache = this.m_ajaxSessionCache;
            synchronized (virtualSessionCache) {
                serverSession = (IServerSession)this.m_ajaxSessionCache.get(ajaxSessionId);
                if (serverSession == null) {
                    return this.createAndCacheNewServerSession(ajaxSessionId, subject, userAgent, req, res);
                }
            }
        }
        this.m_ajaxSessionCache.touch(ajaxSessionId);
        return serverSession;
    }

    protected void initializeAjaxSessionTimeout(HttpServletRequest req) {
        if (!this.m_isAjaxSessionTimeoutInitialized) {
            long defaultSessionTimeout = 1800L;
            long millisecondsInSeconds = 1000L;
            this.m_ajaxSessionCache.setSessionTimeoutMillis(Math.max(1800000L, 1000L * (long)req.getSession().getMaxInactiveInterval()));
            this.m_isAjaxSessionTimeoutInitialized = true;
        }
    }

    private IServerSession createAndCacheNewServerSession(String ajaxSessionId, Subject subject, UserAgent userAgent, HttpServletRequest req, HttpServletResponse res) throws ProcessingException {
        IServerSession serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(this.m_serverSessionClass, subject, userAgent);
        serverSession.setIdInternal(((IClientIdentificationService)SERVICES.getService(IClientIdentificationService.class)).getClientId(req, res));
        this.m_ajaxSessionCache.put(ajaxSessionId, serverSession);
        return serverSession;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            res.sendError(403);
            return;
        }
        Map<Class, Object> backup = ThreadContext.backup();
        try {
            try {
                this.lazyInit(req, res);
                ThreadContext.putHttpServletRequest(req);
                ThreadContext.putHttpServletResponse(res);
                UserAgent userAgent = UserAgent.createDefault();
                IServerSession serverSession = this.lookupScoutServerSessionOnHttpSession(req, res, subject, userAgent);
                AdminServiceJob job = new AdminServiceJob(serverSession, subject, req, res);
                job.runNow((IProgressMonitor)new NullProgressMonitor());
                job.throwOnError();
            }
            catch (ProcessingException e) {
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            ThreadContext.restore(backup);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block10: {
            subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                res.sendError(403);
                return;
            }
            try {
                this.lazyInit(req, res);
                backup = ThreadContext.backup();
                oldLocale = LocaleThreadLocal.get((boolean)false);
                try {
                    ThreadContext.putHttpServletRequest(req);
                    ThreadContext.putHttpServletResponse(res);
                    serviceRequest = this.deserializeInput((InputStream)req.getInputStream());
                    LocaleThreadLocal.set((Locale)serviceRequest.getLocale());
                    serverSession = this.lookupServerSession(req, res, subject, serviceRequest);
                    serviceResponseHolder = new AtomicReference<IServiceTunnelResponse>();
                    job = this.createServiceTunnelServerJob(serverSession, serviceRequest, serviceResponseHolder, subject);
                    job.setTransactionSequence(serviceRequest.getRequestSequence());
                    job.runNow((IProgressMonitor)new NullProgressMonitor());
                    job.throwOnError();
                    this.serializeOutput(res, serviceResponseHolder.get());
                    break block10;
                }
                finally {
                    ThreadContext.restore(backup);
                    LocaleThreadLocal.set((Locale)oldLocale);
                }
            }
            catch (Throwable t) {
                cause = t;
                ** while (cause != null)
            }
lbl-1000:
            // 1 sources

            {
                if (cause instanceof SocketException) {
                    return;
                }
                if (cause.getClass().getSimpleName().equalsIgnoreCase("EofException")) {
                    return;
                }
                if (cause instanceof InterruptedIOException) {
                    return;
                }
                cause = cause.getCause();
                continue;
            }
lbl38:
            // 1 sources

            ServiceTunnelServlet.LOG.error("Client=" + req.getRemoteUser() + "@" + req.getRemoteAddr() + "/" + req.getRemoteHost(), t);
            res.sendError(500);
        }
    }

    protected IServiceTunnelRequest deserializeInput(InputStream in) throws Exception {
        return this.getServiceTunnelContentHandler().readRequest(in);
    }

    protected void serializeOutput(HttpServletResponse httpResponse, IServiceTunnelResponse res) throws Exception {
        if (res.getException() != null) {
            res.getException().setStackTrace(new StackTraceElement[0]);
        }
        httpResponse.setDateHeader("Expires", -1L);
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("pragma", "no-cache");
        httpResponse.setContentType("text/xml");
        this.getServiceTunnelContentHandler().writeResponse((OutputStream)httpResponse.getOutputStream(), res);
    }

    protected ServerJob createServiceTunnelServerJob(IServerSession serverSession, IServiceTunnelRequest serviceRequest, AtomicReference<IServiceTunnelResponse> serviceResponseHolder, Subject subject) {
        return new RemoteServiceJob(serverSession, serviceRequest, serviceResponseHolder, subject);
    }

    protected IServiceTunnelResponse runServerJobTransaction(IServiceTunnelRequest req) throws Exception {
        return this.runServerJobTransactionWithDelegate(req, this.m_requestMinVersion, this.m_debug);
    }

    @Deprecated
    protected IServiceTunnelResponse runServerJobTransactionWithDelegate(IServiceTunnelRequest req, Bundle[] loaderBundles, Version requestMinVersion, boolean debug) throws Exception {
        return this.runServerJobTransactionWithDelegate(req, requestMinVersion, debug);
    }

    protected IServiceTunnelResponse runServerJobTransactionWithDelegate(IServiceTunnelRequest req, Version requestMinVersion, boolean debug) throws Exception {
        return new DefaultTransactionDelegate(requestMinVersion, debug).invoke(req);
    }

    private class AdminServiceJob
    extends ServerJob {
        protected HttpServletRequest m_request;
        protected HttpServletResponse m_response;

        public AdminServiceJob(IServerSession serverSession, Subject subject, HttpServletRequest request, HttpServletResponse response) {
            super("AdminServiceCall", serverSession, subject);
            this.m_request = request;
            this.m_response = response;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            String key = AdminSession.class.getName();
            AdminSession as = (AdminSession)((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).getAndTouch(key, this.m_request, this.m_response);
            if (as == null) {
                as = new AdminSession();
                ((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).put(key, (Object)as, this.m_request, this.m_response);
            }
            as.serviceRequest(this.m_request, this.m_response);
            return Status.OK_STATUS;
        }
    }

    private class RemoteServiceJob
    extends ServerJob {
        private final IServiceTunnelRequest m_serviceRequest;
        private final AtomicReference<IServiceTunnelResponse> m_serviceResponseHolder;

        public RemoteServiceJob(IServerSession serverSession, IServiceTunnelRequest serviceRequest, AtomicReference<IServiceTunnelResponse> serviceResponseHolder, Subject subject) {
            super("RemoteServiceCall", serverSession, subject);
            this.m_serviceRequest = serviceRequest;
            this.m_serviceResponseHolder = serviceResponseHolder;
        }

        public IServiceTunnelRequest getServiceRequest() {
            return this.m_serviceRequest;
        }

        public AtomicReference<IServiceTunnelResponse> getServiceResponseHolder() {
            return this.m_serviceResponseHolder;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            IServiceTunnelResponse serviceRes = ServiceTunnelServlet.this.runServerJobTransaction(this.getServiceRequest());
            this.getServiceResponseHolder().set(serviceRes);
            return Status.OK_STATUS;
        }
    }
}

