/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import org.eclipse.scout.commons.AbstractDynamicHashMap;
import org.eclipse.scout.rt.server.IServerSession;

class VirtualSessionCache
extends AbstractDynamicHashMap<String, IServerSession> {
    private static final long serialVersionUID = 1L;
    private long m_sessionTimeoutMillis = 300000L;
    private long m_nextMaintenance = 0L;

    VirtualSessionCache() {
    }

    public long getSessionTimeoutMillis() {
        return this.m_sessionTimeoutMillis;
    }

    public void setSessionTimeoutMillis(long sessionTimeoutMillis) {
        this.m_sessionTimeoutMillis = sessionTimeoutMillis;
    }

    protected void beforeAccessToInternalMap() {
        if (System.currentTimeMillis() > this.m_nextMaintenance) {
            this.validateInternalMap();
            this.m_nextMaintenance = System.currentTimeMillis() + this.m_sessionTimeoutMillis / 2L;
        }
    }

    protected AbstractDynamicHashMap.DynamicEntry<IServerSession> createDynamicEntry(IServerSession value) {
        return new VirtualSessionEntry(value, this.getSessionTimeoutMillis());
    }

    protected boolean isEntryValid(AbstractDynamicHashMap.DynamicEntry e) {
        VirtualSessionEntry v = (VirtualSessionEntry)e;
        return v.getTimestamp() + v.getInactivityTimeout() >= System.currentTimeMillis();
    }

    static class VirtualSessionEntry
    extends AbstractDynamicHashMap.DynamicEntry<IServerSession> {
        private long m_time;
        private long m_timeout;

        public VirtualSessionEntry(IServerSession value, long timeout) {
            super((Object)value);
            this.m_timeout = timeout;
            this.m_time = System.currentTimeMillis();
        }

        public long getTimestamp() {
            return this.m_time;
        }

        public long getInactivityTimeout() {
            return this.m_timeout;
        }

        public void touch() {
            this.m_time = System.currentTimeMillis();
        }
    }
}

