/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification.internal;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.clientnotification.ClientNotificationQueueEvent;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationQueueElement;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationQueueListener;
import org.eclipse.scout.rt.server.services.common.clientnotification.internal.ClientNotificationQueueElement;
import org.eclipse.scout.rt.server.services.common.clientnotification.internal.ConsumableClientNotificationQueueElement;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;

public class ClientNotificationQueue {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientNotificationQueue.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private final LinkedList<ConsumableClientNotificationQueueElement> m_queue;
    private final Object m_queueLock = new Object();

    public ClientNotificationQueue() {
        this.m_queue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNotification(IClientNotification notification, IClientNotificationFilter filter) {
        if (notification == null) {
            throw new IllegalArgumentException("notification must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("put " + notification + " for " + filter);
        }
        Object object = this.m_queueLock;
        synchronized (object) {
            ConsumableClientNotificationQueueElement newElem = new ConsumableClientNotificationQueueElement(notification, filter);
            this.replaceExistingElements(newElem);
            this.m_queue.add(newElem);
            this.m_queueLock.notifyAll();
        }
        this.fireEvent(notification, filter);
    }

    private void replaceExistingElements(IClientNotificationQueueElement newElem) {
        Iterator it = this.m_queue.iterator();
        while (it.hasNext()) {
            ClientNotificationQueueElement existingElem = (ClientNotificationQueueElement)it.next();
            if (existingElem.isActive() && !existingElem.isReplacableBy(newElem)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<IClientNotification> getNextNotifications(long blockingTimeout) {
        long endTime = System.currentTimeMillis() + blockingTimeout;
        HashSet<IClientNotification> list = new HashSet<IClientNotification>();
        Object object = this.m_queueLock;
        synchronized (object) {
            while (true) {
                if (!this.m_queue.isEmpty()) {
                    IServerSession serverSession = ThreadContext.getServerSession();
                    Iterator it = this.m_queue.iterator();
                    while (it.hasNext()) {
                        ConsumableClientNotificationQueueElement e = (ConsumableClientNotificationQueueElement)it.next();
                        if (!e.isActive()) {
                            it.remove();
                            continue;
                        }
                        if (!e.isConsumable(serverSession)) continue;
                        list.add(e.getNotification());
                    }
                }
                long dt = endTime - System.currentTimeMillis();
                if (list.size() > 0) return list;
                if (dt <= 0L) {
                    return list;
                }
                try {
                    this.m_queueLock.wait(dt);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public void addClientNotificationQueueListener(IClientNotificationQueueListener listener) {
        this.m_listenerList.add(IClientNotificationQueueListener.class, (EventListener)listener);
    }

    public void removeClientNotificationQueueListener(IClientNotificationQueueListener listener) {
        this.m_listenerList.remove(IClientNotificationQueueListener.class, (EventListener)listener);
    }

    private void fireEvent(IClientNotification notification, IClientNotificationFilter filter) {
        IClientNotificationQueueListener[] listeners;
        IClientNotificationQueueListener[] iClientNotificationQueueListenerArray = listeners = (IClientNotificationQueueListener[])this.m_listenerList.getListeners(IClientNotificationQueueListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IClientNotificationQueueListener l = iClientNotificationQueueListenerArray[n2];
            l.queueChanged(new ClientNotificationQueueEvent(notification, filter, 10));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackNotifications(Set<String> consumedNotificationIds) {
        Object object = this.m_queueLock;
        synchronized (object) {
            if (!this.m_queue.isEmpty()) {
                IServerSession serverSession = ThreadContext.getServerSession();
                Iterator it = this.m_queue.iterator();
                while (it.hasNext()) {
                    ConsumableClientNotificationQueueElement e = (ConsumableClientNotificationQueueElement)it.next();
                    if (!e.isConsumable(serverSession) || !consumedNotificationIds.contains(e.getNotification().getId())) continue;
                    e.setConsumedBy(serverSession);
                    if (e.getFilter().isMulticast()) continue;
                    it.remove();
                }
            }
        }
    }
}

