/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.util.Date;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;

public class ClusterNodeStatusInfo {
    private final ClusterNodeStatusBean m_info = new ClusterNodeStatusBean();
    private final Object m_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClusterNodeStatusInfo getStatus() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_info.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSentStatus(IClusterNotificationMessage sentMessage) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incSentMessageCount();
            this.updateLastChanged(sentMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReceiveStatus(IClusterNotificationMessage receivedMessage) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incReceivedMessageCount();
            this.updateLastChanged(receivedMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastChanged(String userId, String originNode) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.setLastChangedDate(new Date());
            this.m_info.setLastChangedUserId(userId);
            this.m_info.setLastChangedOriginNodeId(originNode);
        }
    }

    private void updateLastChanged(IClusterNotificationMessage message) {
        this.updateLastChanged(message.getProperties().getOriginUser(), message.getProperties().getOriginNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long getSentMessageCount() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_info.getSentMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long getReceivedMessageCount() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_info.getReceivedMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Date getLastChangedDate() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_info.getLastChangedDate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getLastChangedUserId() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_info.getLastChangedUserId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getLastChangedOriginNodeId() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_info.getLastChangedOriginNodeId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setLastChangedDate(Date lastChangedDate) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.setLastChangedDate(lastChangedDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setLastChangedUserId(String lastChangedUserId) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.setLastChangedUserId(lastChangedUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long incrementReceivedMessageCount() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incReceivedMessageCount();
            return this.m_info.getReceivedMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long incrementReceivedMessageCount(long delta) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incReceivedMessageCount(delta);
            return this.m_info.getReceivedMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long incrementSentMessageCount() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incSentMessageCount();
            return this.m_info.getSentMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long addSentMessageCount(long delta) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incSentMessageCount(delta);
            return this.m_info.getSentMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long addReceivedMessageCount(long delta) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incReveivedMessageCount(delta);
            return this.m_info.getReceivedMessageCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setLastChangedOriginNodeId(String originNode) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.setLastChangedOriginNodeId(originNode);
        }
    }

    private static class ClusterNodeStatusBean
    implements IClusterNodeStatusInfo,
    Cloneable {
        private long m_sentMessageCount;
        private long m_receivedMessageCount;
        private Date m_lastChangedDate;
        private String m_lastChangedUserId;
        private String m_lastChangedOriginNodeId;

        private ClusterNodeStatusBean() {
        }

        @Override
        public long getSentMessageCount() {
            return this.m_sentMessageCount;
        }

        public void incReveivedMessageCount(long delta) {
            this.m_receivedMessageCount += delta;
        }

        public void incSentMessageCount() {
            ++this.m_sentMessageCount;
        }

        @Deprecated
        void incSentMessageCount(long delta) {
            this.m_sentMessageCount += delta;
        }

        @Override
        public long getReceivedMessageCount() {
            return this.m_receivedMessageCount;
        }

        @Deprecated
        void incReceivedMessageCount(long delta) {
            this.m_receivedMessageCount += delta;
        }

        public void incReceivedMessageCount() {
            ++this.m_receivedMessageCount;
        }

        @Override
        public Date getLastChangedDate() {
            return this.m_lastChangedDate;
        }

        public void setLastChangedDate(Date lastChangedDate) {
            this.m_lastChangedDate = lastChangedDate;
        }

        @Override
        public String getLastChangedUserId() {
            return this.m_lastChangedUserId;
        }

        public void setLastChangedUserId(String lastChangedUserId) {
            this.m_lastChangedUserId = lastChangedUserId;
        }

        @Override
        public String getLastChangedOriginNodeId() {
            return this.m_lastChangedOriginNodeId;
        }

        public void setLastChangedOriginNodeId(String lastChangedOriginNodeId) {
            this.m_lastChangedOriginNodeId = lastChangedOriginNodeId;
        }

        protected ClusterNodeStatusBean clone() {
            try {
                return (ClusterNodeStatusBean)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public String toString() {
            return "ClusterNodeStatusBean [sentMessageCount=" + this.m_sentMessageCount + ", receivedMessageCount=" + this.m_receivedMessageCount + ", lastChangedDate=" + this.m_lastChangedDate + ", lastChangedUserId=" + this.m_lastChangedUserId + ", lastChangedOriginNodeId=" + this.m_lastChangedOriginNodeId + "]";
        }
    }
}

