/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ITransactionRunnable;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.services.common.clustersync.ClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListenerService;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessageProperties;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.server.services.common.clustersync.IPublishSubscribeMessageListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IPublishSubscribeMessageService;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ClusterNotificationMessageProperties;
import org.eclipse.scout.rt.server.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.ServiceRegistration;

public class ClusterSynchronizationService
extends AbstractService
implements IClusterSynchronizationService,
IPublishSubscribeMessageListener {
    private static final String TRANSACTION_MEMBER_ID = ClusterSynchronizationService.class.getName();
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClusterSynchronizationService.class);
    private static final String CLUSTER_NODE_ID_PARAM = "org.eclipse.scout.rt.server.clusterNodeId";
    private final EventListenerList m_listenerList = new EventListenerList();
    private final ClusterNodeStatusInfo m_statusInfo = new ClusterNodeStatusInfo();
    private String m_nodeId;
    private IServerSession m_session;
    private IServerJobFactory m_jobFactory;
    private volatile boolean m_enabled;
    private volatile IPublishSubscribeMessageService m_messageService;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.m_nodeId = this.createNodeId();
        this.m_session = this.createBackendSession();
        this.m_jobFactory = this.createJobFactory();
    }

    protected IServerJobFactory getJobFactory() {
        return this.m_jobFactory;
    }

    private IServerJobFactory createJobFactory() {
        IServerJobService service = (IServerJobService)SERVICES.getService(IServerJobService.class);
        return service.createJobFactory(this.getBackendSession(), this.getBackendSession().getSubject());
    }

    protected String createNodeId() {
        String nodeId = Activator.getDefault().getBundle().getBundleContext().getProperty(CLUSTER_NODE_ID_PARAM);
        if (!StringUtility.hasText((CharSequence)nodeId)) {
            nodeId = System.getProperty("weblogic.Name");
        }
        if (!StringUtility.hasText((CharSequence)nodeId)) {
            nodeId = System.getProperty("jboss.node.name");
        }
        if (!StringUtility.hasText((CharSequence)nodeId)) {
            String hostname;
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = null;
            }
            if (StringUtility.isNullOrEmpty((CharSequence)hostname) || "localhost".equals(hostname)) {
                nodeId = UUID.randomUUID().toString();
            }
            String port = System.getProperty("org.eclipse.equinox.http.jetty.http.port");
            nodeId = StringUtility.join((String)":", (Object[])new Object[]{hostname, port});
        }
        return nodeId;
    }

    protected IServerSession createBackendSession() {
        IServerSession serverSession = null;
        try {
            serverSession = ((IServerJobService)SERVICES.getService(IServerJobService.class)).createServerSession();
        }
        catch (ProcessingException e) {
            LOG.error("Error creating backend session for cluster synchronization.", (Throwable)e);
        }
        return serverSession;
    }

    @Deprecated
    protected Subject createBackendSubject() {
        return ((IServerJobService)SERVICES.getService(IServerJobService.class)).getServerSubject();
    }

    protected EventListenerList getListenerList() {
        return this.m_listenerList;
    }

    @Override
    public void addListener(IClusterNotificationListener listener) {
        this.m_listenerList.add(IClusterNotificationListener.class, (EventListener)listener);
    }

    @Override
    public void removeListener(IClusterNotificationListener listener) {
        this.m_listenerList.remove(IClusterNotificationListener.class, (EventListener)listener);
    }

    protected IClusterNotificationListener[] getListeners() {
        return (IClusterNotificationListener[])this.getListenerList().getListeners(IClusterNotificationListener.class);
    }

    @Override
    @Deprecated
    public ClusterNodeStatusInfo getClusterNodeStatusInfo() {
        return this.m_statusInfo;
    }

    @Override
    public IClusterNodeStatusInfo getStatusInfo() {
        return this.m_statusInfo.getStatus();
    }

    protected ClusterNodeStatusInfo getStatusInfoInternal() {
        return this.m_statusInfo;
    }

    @Override
    public String getNodeId() {
        return this.m_nodeId;
    }

    protected IServerSession getBackendSession() {
        return this.m_session;
    }

    protected IPublishSubscribeMessageService getMessageService() {
        return this.m_messageService;
    }

    protected void setMessageService(IPublishSubscribeMessageService messageService) {
        this.m_messageService = messageService;
    }

    protected void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    protected void contributeListeners() throws ProcessingException {
        HashSet<IClusterNotificationListener> currentListeners = new HashSet<IClusterNotificationListener>(Arrays.asList(this.getListeners()));
        IClusterNotificationListenerService[] iClusterNotificationListenerServiceArray = (IClusterNotificationListenerService[])SERVICES.getServices(IClusterNotificationListenerService.class);
        int n = iClusterNotificationListenerServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClusterNotificationListenerService contributingService = iClusterNotificationListenerServiceArray[n2];
            IService definingService = (IService)SERVICES.getService(contributingService.getDefiningServiceInterface());
            if (contributingService == definingService) {
                if (!currentListeners.contains(contributingService)) {
                    this.addListener(contributingService.getClusterNotificationListener());
                }
            } else if (currentListeners.contains(contributingService)) {
                this.removeListener(contributingService.getClusterNotificationListener());
            }
            ++n2;
        }
    }

    @Override
    public boolean enable() {
        if (this.isEnabled()) {
            return true;
        }
        if (this.getNodeId() == null) {
            LOG.error("Clustersync could not be enabled. No cluster nodeId could be determined.");
            return false;
        }
        if (this.getBackendSession() == null) {
            LOG.error("Clustersync could not be enabled. Backend session could not be initialized.");
            return false;
        }
        IPublishSubscribeMessageService messageService = (IPublishSubscribeMessageService)SERVICES.getService(IPublishSubscribeMessageService.class);
        if (messageService == null) {
            LOG.error("Clustersync could not be enabled. No MessageService found.");
            return false;
        }
        try {
            messageService.setListener(this);
            messageService.subscribe();
            this.setMessageService(messageService);
            this.contributeListeners();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        this.setEnabled(true);
        return true;
    }

    @Override
    public boolean disable() {
        if (!this.isEnabled()) {
            return true;
        }
        this.setEnabled(false);
        IPublishSubscribeMessageService messageService = this.getMessageService();
        if (messageService != null) {
            try {
                messageService.unsubsribe();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public void publishNotification(IClusterNotification notification) throws ProcessingException {
        if (this.isEnabled()) {
            ClusterNotificationMessage message = new ClusterNotificationMessage(notification, this.getNotificationProperties());
            this.getTransaction().addMessage(message);
        }
    }

    protected IClusterNotificationMessageProperties getNotificationProperties() {
        return new ClusterNotificationMessageProperties(this.getNodeId(), ServerJob.getCurrentSession().getUserId());
    }

    protected void notifyListeners(IClusterNotificationMessage message) {
        IClusterNotificationListener[] iClusterNotificationListenerArray = this.getListeners();
        int n = iClusterNotificationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClusterNotificationListener listener = iClusterNotificationListenerArray[n2];
            try {
                listener.onNotification(message);
            }
            catch (Exception e) {
                LOG.error("Failed notification of message " + message + " to listener " + listener.getClass().getName(), (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public void onMessage(final IClusterNotificationMessage message) {
        String originNode = message.getProperties().getOriginNode();
        if (!this.getNodeId().equals(originNode)) {
            this.getClusterNodeStatusInfo().updateReceiveStatus(message);
            try {
                this.m_jobFactory.runNow("NotificationProcessingJob", new ITransactionRunnable(){

                    @Override
                    public IStatus run(IProgressMonitor monitor) throws ProcessingException {
                        ClusterSynchronizationService.this.notifyListeners(message);
                        return Status.OK_STATUS;
                    }
                });
            }
            catch (ProcessingException e) {
                LOG.error("Error processing message", (Throwable)e);
            }
        }
    }

    public void disposeServices() {
        super.disposeServices();
        this.disable();
    }

    protected ClusterSynchronizationTransaction getTransaction() throws ProcessingException {
        ITransaction t = ThreadContext.getTransaction();
        if (t == null) {
            throw new IllegalStateException("not inside a scout transaction (ServerJob.schedule)");
        }
        ClusterSynchronizationTransaction m = (ClusterSynchronizationTransaction)t.getMember(TRANSACTION_MEMBER_ID);
        if (m == null) {
            m = new ClusterSynchronizationTransaction(TRANSACTION_MEMBER_ID, this.getMessageService(), this.m_statusInfo);
            t.registerMember(m);
        }
        return m;
    }

    protected static class ClusterSynchronizationTransaction
    extends AbstractTransactionMember {
        private final List<IClusterNotificationMessage> m_messageQueue = new LinkedList<IClusterNotificationMessage>();
        private final IPublishSubscribeMessageService m_messageService;
        private final ClusterNodeStatusInfo m_statusInfo;

        public ClusterSynchronizationTransaction(String transactionId, IPublishSubscribeMessageService messageService, ClusterNodeStatusInfo statusInfo) throws ProcessingException {
            super(transactionId);
            this.m_messageService = messageService;
            this.m_statusInfo = statusInfo;
        }

        protected ClusterNodeStatusInfo getStatusInfoInternal() {
            return this.m_statusInfo;
        }

        public synchronized void addMessage(IClusterNotificationMessage m) {
            Iterator<IClusterNotificationMessage> it = this.m_messageQueue.iterator();
            while (it.hasNext()) {
                IClusterNotificationMessage existingElem = it.next();
                if (!existingElem.coalesce(m)) continue;
                it.remove();
            }
            this.m_messageQueue.add(m);
        }

        @Override
        public boolean commitPhase1() {
            return true;
        }

        @Override
        public synchronized void commitPhase2() {
            this.m_messageService.publishNotifications(new ArrayList<IClusterNotificationMessage>(this.m_messageQueue));
            for (IClusterNotificationMessage m : this.m_messageQueue) {
                this.getStatusInfoInternal().updateSentStatus(m);
            }
        }

        @Override
        public synchronized boolean needsCommit() {
            return !this.m_messageQueue.isEmpty();
        }

        @Override
        public void release() {
        }

        @Override
        public synchronized void rollback() {
            this.m_messageQueue.clear();
        }
    }
}

