/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.code;

import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.services.common.clientnotification.AllUserFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListenerService;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.server.services.common.code.UnloadCodeTypeCacheClusterNotification;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeChangedNotification;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.SharedCodeService;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-1.0f)
public class CodeService
extends SharedCodeService
implements IClusterNotificationListenerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeService.class);

    protected Long provideCurrentPartitionId() {
        Map sharedVariableMap = ServerJob.getCurrentSession().getSharedVariableMap();
        if (sharedVariableMap.containsKey("partitionId")) {
            return (Long)sharedVariableMap.get("partitionId");
        }
        return super.provideCurrentPartitionId();
    }

    protected void notifyReloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> codetypeList) throws ProcessingException {
        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new CodeTypeChangedNotification(codetypeList), new AllUserFilter(120000L));
        IClusterSynchronizationService s = (IClusterSynchronizationService)SERVICES.getService(IClusterSynchronizationService.class);
        if (s != null) {
            s.publishNotification(new UnloadCodeTypeCacheClusterNotification(codetypeList));
        }
    }

    @Override
    public IClusterNotificationListener getClusterNotificationListener() {
        return new IClusterNotificationListener(){

            @Override
            public void onNotification(IClusterNotificationMessage message) throws ProcessingException {
                IClusterNotification clusterNotification = message.getNotification();
                if (clusterNotification instanceof UnloadCodeTypeCacheClusterNotification) {
                    UnloadCodeTypeCacheClusterNotification n = (UnloadCodeTypeCacheClusterNotification)clusterNotification;
                    CodeService.this.reloadCodeTypesNoFire(n.getTypes());
                }
            }
        };
    }

    @Override
    public Class<? extends IService> getDefiningServiceInterface() {
        return ICodeService.class;
    }
}

