/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.imap;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.imap.IIMAPService;
import org.eclipse.scout.service.AbstractService;

public abstract class AbstractIMAPService
extends AbstractService
implements IIMAPService {
    private String m_host;
    private int m_port;
    private String m_sslProtocols;
    private String m_mailbox;
    private String m_username;
    private String m_password;
    private boolean m_opened = false;
    private Folder m_folder;
    private Store m_store;

    public AbstractIMAPService() {
        this.init();
    }

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    protected String getConfiguredHost() {
        return null;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String s) {
        this.m_host = s;
    }

    @ConfigProperty(value="STRING")
    @Order(value=20.0)
    protected int getConfiguredPort() {
        return -1;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int i) {
        this.m_port = i;
    }

    @ConfigProperty(value="STRING")
    @Order(value=25.0)
    protected String getConfiguredSslProtocols() {
        return null;
    }

    public String getSslProtocols() {
        return this.m_sslProtocols;
    }

    public void setSslProtocols(String s) {
        this.m_sslProtocols = s;
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    protected String getConfiguredMailbox() {
        return null;
    }

    public String getMailbox() {
        return this.m_mailbox;
    }

    public void setMailbox(String s) {
        this.m_mailbox = s;
    }

    @ConfigProperty(value="STRING")
    @Order(value=40.0)
    protected String getConfiguredUserName() {
        return null;
    }

    public String getUserName() {
        return this.m_username;
    }

    public void setUserName(String s) {
        this.m_username = s;
    }

    @ConfigProperty(value="STRING")
    @Order(value=50.0)
    protected String getConfiguredPassword() {
        return null;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String s) {
        this.m_password = s;
    }

    public void openConnection() throws ProcessingException {
        this.openConnection(false);
    }

    public void openConnection(boolean useSSL) throws ProcessingException {
        try {
            Properties props = new Properties();
            props.put("mail.transport.protocol", "imap");
            if (this.m_host != null) {
                props.put("mail.imap.host", this.m_host);
            }
            if (this.m_port > 0) {
                props.put("mail.imap.port", "" + this.m_port);
            }
            if (!StringUtility.isNullOrEmpty((CharSequence)this.getSslProtocols())) {
                props.put("mail.imap.ssl.protocols", this.getSslProtocols());
            }
            if (this.m_username != null) {
                props.put("mail.imap.user", this.m_username);
            }
            if (useSSL) {
                props.put("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.imap.socketFactory.fallback", "false");
                if (this.m_port > 0) {
                    props.put("mail.imap.socketFactory.port", "" + this.m_port);
                }
            }
            Session session = Session.getInstance((Properties)props, null);
            this.m_store = session.getStore("imap");
            if (this.m_username != null && this.m_host != null) {
                this.m_store.connect(System.getProperty("mail.imap.host"), this.m_username, this.m_password);
            } else {
                this.m_store.connect();
            }
            this.m_folder = this.m_mailbox != null ? this.m_store.getFolder(this.m_mailbox) : this.m_store.getDefaultFolder();
            this.m_folder.open(2);
            this.m_opened = true;
        }
        catch (Exception e) {
            throw new ProcessingException("opening", (Throwable)e);
        }
    }

    public void closeConnection() throws ProcessingException {
        try {
            try {
                this.m_folder.close(true);
                this.m_folder = null;
                this.m_store.close();
                this.m_store = null;
                this.m_opened = false;
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (this.m_folder != null) {
                try {
                    this.m_folder.close(false);
                }
                catch (Throwable throwable) {}
            }
            if (this.m_store != null) {
                try {
                    this.m_store.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public Message[] getUnreadMessages() throws ProcessingException {
        ReadMailTask task = new ReadMailTask();
        this.doTask(task);
        return task.getUnreadMessages();
    }

    @Override
    public void deleteAllMessages() throws ProcessingException {
        DeleteMailTask task = new DeleteMailTask(true);
        this.doTask(task);
    }

    @Override
    public void deleteMessages(Message ... toDelete) throws ProcessingException {
        DeleteMailTask task = new DeleteMailTask(false);
        task.setMessagesToDelete(toDelete);
        this.doTask(task);
    }

    private void doTask(AbstractMailTask task) throws ProcessingException {
        if (!this.m_opened) {
            throw new ProcessingException("No connection opened");
        }
        task.doTask(this.m_folder);
    }

    private void init() {
        this.setHost(this.getConfiguredHost());
        this.setPort(this.getConfiguredPort());
        this.setMailbox(this.getConfiguredMailbox());
        this.setUserName(this.getConfiguredUserName());
        this.setPassword(this.getConfiguredPassword());
    }

    private abstract class AbstractMailTask {
        private AbstractMailTask() {
        }

        public void doTask(Folder folder) throws ProcessingException {
        }
    }

    private class DeleteMailTask
    extends AbstractMailTask {
        private Message[] toDelete;
        private boolean deleteAll;

        DeleteMailTask(boolean all) {
            this.deleteAll = all;
        }

        @Override
        public void doTask(Folder folder) throws ProcessingException {
            try {
                Message[] m = folder.getMessages();
                if (this.deleteAll) {
                    this.toDelete = folder.getMessages();
                }
                int i = 0;
                while (i < Array.getLength(this.toDelete)) {
                    Message item = this.toDelete[i];
                    int j = 0;
                    while (j < Array.getLength(m)) {
                        Message msg = m[j];
                        if (item.equals(msg)) {
                            msg.setFlag(Flags.Flag.DELETED, true);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), (Throwable)e);
            }
        }

        public void setMessagesToDelete(Message[] msgs) {
            this.toDelete = msgs;
        }
    }

    private class ReadMailTask
    extends AbstractMailTask {
        private ArrayList<Message> messages = new ArrayList();

        private ReadMailTask() {
        }

        @Override
        public void doTask(Folder folder) throws ProcessingException {
            try {
                Message[] m = folder.getMessages();
                int i = 0;
                while (i < Array.getLength(m)) {
                    Message item = m[i];
                    if (!item.isSet(Flags.Flag.SEEN)) {
                        this.messages.add(item);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), (Throwable)e);
            }
        }

        public Message[] getUnreadMessages() {
            Message[] messageArray = new Message[this.messages.size()];
            this.messages.toArray(messageArray);
            return messageArray;
        }
    }
}

