/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.lang.reflect.Array;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class ArrayInput
implements IBindInput {
    private Object m_array;
    private ValueInputToken m_target;
    private int m_arrayLen = 0;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;

    public ArrayInput(ISqlStyle sqlStyle, Object array, ValueInputToken target) throws ProcessingException {
        if (array != null && !array.getClass().isArray()) {
            throw new ProcessingException("array parameter must be an array type: " + array.getClass());
        }
        this.m_array = array;
        this.m_arrayLen = this.m_array != null ? Array.getLength(this.m_array) : 0;
        this.m_target = target;
        if (!this.isBatch()) {
            if (!sqlStyle.isCreatingInListGeneratingBind(this.m_array)) {
                this.m_target.setPlainValue(true);
            }
            if ((this.m_target.isPlainValue() || this.m_target.isPlainSql()) && this.m_target.getParsedOp() != null) {
                if ("=".equals(this.m_target.getParsedOp())) {
                    this.m_target.setParsedOp("IN");
                } else if (this.m_target.getParsedOp().equals("!=") || this.m_target.getParsedOp().equals("<>")) {
                    this.m_target.setParsedOp("NOT IN");
                }
            }
        }
    }

    @Override
    public IToken getToken() {
        return this.m_target;
    }

    @Override
    public boolean isBatch() {
        return this.m_target.isBatch();
    }

    @Override
    public boolean hasBatch(int i) {
        if (this.isBatch()) {
            return i < this.m_arrayLen;
        }
        return i <= 0;
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public boolean isJdbcBind(ISqlStyle sqlStyle) {
        if (this.isBatch()) {
            if (this.m_target.isPlainValue()) {
                return false;
            }
            return !this.m_target.isPlainSql();
        }
        return this.m_target.getParsedAttribute() != null && !this.m_target.isPlainSql() && !this.m_target.isPlainValue() && sqlStyle.isCreatingInListGeneratingBind(this.m_array);
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        if (this.isBatch()) {
            Object value = null;
            if (this.m_batchIndex < this.m_arrayLen) {
                value = Array.get(this.m_array, this.m_batchIndex);
            }
            if (this.m_target.isPlainValue()) {
                this.m_target.setReplaceToken(sqlStyle.toPlainText(value));
                return null;
            }
            if (this.m_target.isPlainSql()) {
                this.m_target.setReplaceToken("" + value);
                return null;
            }
            this.m_target.setReplaceToken("?");
            return sqlStyle.buildBindFor(value, this.m_array.getClass().getComponentType());
        }
        return this.applyMultiValued(sqlStyle);
    }

    private SqlBind applyMultiValued(ISqlStyle sqlStyle) throws ProcessingException {
        if (this.m_target.getParsedAttribute() != null) {
            boolean plain = this.m_target.isPlainSql() || this.m_target.isPlainValue();
            String att = this.m_target.getParsedAttribute();
            String op = this.m_target.getParsedOp();
            this.m_target.setParsedAttribute(null);
            this.m_target.setParsedOp(null);
            if (op.equalsIgnoreCase("IN") || op.equalsIgnoreCase("=")) {
                this.m_target.setReplaceToken(sqlStyle.createInList(att, plain, this.m_array));
            } else {
                this.m_target.setReplaceToken(sqlStyle.createNotInList(att, plain, this.m_array));
            }
            if (!plain && sqlStyle.isCreatingInListGeneratingBind(this.m_array)) {
                return sqlStyle.buildBindFor(this.m_array, null);
            }
        } else {
            this.m_target.setReplaceToken(sqlStyle.toPlainText(this.m_array));
        }
        return null;
    }
}

