/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.lang.reflect.Method;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.ITableHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class TableHolderInput
implements IBindInput {
    private ITableHolder m_table;
    private int[] m_filteredRowIndices;
    private Method m_getterMethod;
    private ValueInputToken m_target;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;

    public TableHolderInput(ITableHolder table, int[] filteredRowIndices, String columnName, ValueInputToken target) throws ProcessingException {
        this.m_table = table;
        if (filteredRowIndices == null) {
            filteredRowIndices = new int[table.getRowCount()];
            int i = 0;
            while (i < filteredRowIndices.length) {
                filteredRowIndices[i] = i;
                ++i;
            }
        }
        this.m_filteredRowIndices = filteredRowIndices;
        try {
            this.m_getterMethod = table.getClass().getMethod("get" + Character.toUpperCase(columnName.charAt(0)) + columnName.substring(1), Integer.TYPE);
        }
        catch (Throwable e) {
            throw new ProcessingException("unexpected exception", e);
        }
        this.m_target = target;
    }

    @Override
    public IToken getToken() {
        return this.m_target;
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public boolean hasBatch(int i) {
        return i < this.m_filteredRowIndices.length;
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public boolean isJdbcBind(ISqlStyle sqlStyle) {
        if (this.m_target.isPlainValue()) {
            return false;
        }
        return !this.m_target.isPlainSql();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        Object value = null;
        if (this.m_batchIndex < this.m_filteredRowIndices.length) {
            try {
                value = this.m_getterMethod.invoke((Object)this.m_table, new Integer(this.m_filteredRowIndices[this.m_batchIndex]));
            }
            catch (Throwable e) {
                throw new ProcessingException("unexpected exception", e);
            }
        }
        if (this.m_target.isPlainValue()) {
            this.m_target.setReplaceToken(sqlStyle.toPlainText(value));
            return null;
        }
        if (this.m_target.isPlainSql()) {
            this.m_target.setReplaceToken("" + value);
            return null;
        }
        this.m_target.setReplaceToken("?");
        return sqlStyle.buildBindFor(value, this.m_getterMethod.getReturnType());
    }
}

