/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService;

public class SqlConnectionBuilder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SqlConnectionBuilder.class);

    public Connection createJdbcConnection(AbstractSqlService sqlService) throws ClassNotFoundException, SQLException, InstantiationException, IllegalAccessException {
        Connection conn;
        String user = sqlService.getUsername();
        String pass = sqlService.getPassword();
        Class.forName(sqlService.getJdbcDriverName());
        if (user != null && pass != null) {
            conn = DriverManager.getConnection(sqlService.getJdbcMappingName(), user, pass);
        } else {
            Properties p = null;
            String s = sqlService.getJdbcProperties();
            if (!StringUtility.hasText((CharSequence)s)) {
                s = null;
            }
            if (s != null) {
                p = new Properties();
                StringTokenizer tok = new StringTokenizer(s, ";");
                while (tok.hasMoreTokens()) {
                    String t = tok.nextToken();
                    StringTokenizer tok2 = new StringTokenizer(t, "=");
                    String n = tok2.nextToken();
                    String v = tok2.nextToken();
                    p.setProperty(n, v);
                }
            }
            conn = p != null ? DriverManager.getConnection(sqlService.getJdbcMappingName(), p) : DriverManager.getConnection(sqlService.getJdbcMappingName());
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public Connection createJndiConnection(AbstractSqlService sqlService) throws NamingException, SQLException {
        InitialContext initialContext = null;
        try {
            String user = sqlService.getUsername();
            String pass = sqlService.getPassword();
            String jndiName = sqlService.getJndiName();
            String jndiInitialContextFactory = sqlService.getJndiInitialContextFactory();
            String jndiProviderUrl = sqlService.getJndiProviderUrl();
            String jndiUrlPkgPrefixes = sqlService.getJndiUrlPkgPrefixes();
            if (LOG.isInfoEnabled()) {
                LOG.info("Opening rmi connection to: " + jndiName + "," + user);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("  using initial context factory: " + jndiInitialContextFactory);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("  using provider url: " + jndiProviderUrl);
            }
            Hashtable<String, String> ht = new Hashtable<String, String>();
            if (jndiInitialContextFactory != null) {
                ht.put("java.naming.factory.initial", jndiInitialContextFactory);
            }
            if (jndiProviderUrl != null) {
                ht.put("java.naming.provider.url", jndiProviderUrl);
            }
            if (jndiUrlPkgPrefixes != null) {
                ht.put("java.naming.factory.url.pkgs", jndiUrlPkgPrefixes);
            }
            DataSource dataSource = null;
            initialContext = ht.size() > 0 ? new InitialContext(ht) : new InitialContext();
            dataSource = (DataSource)initialContext.lookup(jndiName);
            Connection conn = user != null && pass != null ? dataSource.getConnection(user, pass) : dataSource.getConnection();
            conn.setAutoCommit(false);
            Connection connection = conn;
            return connection;
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

