/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security;

import java.security.Permissions;
import java.util.Collection;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.clientnotification.SingleUserFilter;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListenerService;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.server.services.common.security.AccessControlCacheChangedClusterNotification;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.security.AbstractSharedAccessControlService;
import org.eclipse.scout.rt.shared.services.common.security.AccessControlChangedNotification;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.services.common.security.ResetAccessControlChangedNotification;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-1.0f)
public abstract class AbstractAccessControlService
extends AbstractSharedAccessControlService
implements IClusterNotificationListenerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractAccessControlService.class);

    protected void notifySetPermisions(Permissions p) {
        String userId = ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getUserIdOfCurrentSubject();
        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new AccessControlChangedNotification(p), new SingleUserFilter(userId, 120000L));
    }

    public void clearCache() {
        this.clearCacheNoFire();
        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new ResetAccessControlChangedNotification(), new SingleUserFilter(null, 0L));
        try {
            IClusterSynchronizationService s = (IClusterSynchronizationService)SERVICES.getService(IClusterSynchronizationService.class);
            if (s != null) {
                s.publishNotification(new AccessControlCacheChangedClusterNotification());
            }
        }
        catch (ProcessingException e) {
            LOG.error("failed notifying cluster for permission changes", (Throwable)e);
        }
    }

    public void clearCacheOfUserIds(Collection<String> userIds) {
        this.clearCacheOfUserIdsNoFire(userIds);
        try {
            IClusterSynchronizationService s = (IClusterSynchronizationService)SERVICES.getService(IClusterSynchronizationService.class);
            if (s != null) {
                s.publishNotification(new AccessControlCacheChangedClusterNotification(userIds));
            }
        }
        catch (ProcessingException e) {
            LOG.error("failed notifying cluster for permission changes", (Throwable)e);
        }
        for (String userId : userIds) {
            if (userId == null) continue;
            ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new AccessControlChangedNotification(null), new SingleUserFilter(userId, 120000L));
        }
    }

    @Override
    public Class<? extends IService> getDefiningServiceInterface() {
        return IAccessControlService.class;
    }

    @Override
    public IClusterNotificationListener getClusterNotificationListener() {
        return new IClusterNotificationListener(){

            @Override
            public void onNotification(IClusterNotificationMessage message) throws ProcessingException {
                IClusterNotification clusterNotification = message.getNotification();
                if (clusterNotification instanceof AccessControlCacheChangedClusterNotification) {
                    AccessControlCacheChangedClusterNotification n = (AccessControlCacheChangedClusterNotification)clusterNotification;
                    if (n.getUserIds().isEmpty()) {
                        AbstractAccessControlService.this.clearCacheNoFire();
                    } else {
                        AbstractAccessControlService.this.clearCacheOfUserIdsNoFire(n.getUserIds());
                    }
                }
            }
        };
    }
}

