/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.extension.AbstractSerializableExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.extension.data.model.DataModelEntityChains;
import org.eclipse.scout.rt.shared.extension.data.model.IDataModelEntityExtension;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDataModelEntity
extends AbstractPropertyObserver
implements IDataModelEntity,
Serializable,
IContributionOwner,
IExtensibleObject {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDataModelEntity.class);
    private String m_id;
    private double m_order;
    private Permission m_visiblePermission;
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private boolean m_oneToMany;
    private String m_text;
    private String m_iconId;
    private List<IDataModelAttribute> m_attributes = new ArrayList<IDataModelAttribute>();
    private List<IDataModelEntity> m_entities = new ArrayList<IDataModelEntity>();
    private IDataModelEntity m_parentEntity;
    private boolean m_initializedChildEntities;
    private boolean m_initialized;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractDataModelEntity, IDataModelEntityExtension<? extends AbstractDataModelEntity>> m_objectExtensions = new ObjectExtensions(this);

    public AbstractDataModelEntity() {
        this(true);
    }

    public AbstractDataModelEntity(boolean callInitConfig) {
        if (callInitConfig) {
            this.callInitializer();
        }
    }

    @Override
    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    @Override
    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    @Override
    public final <T> T getContribution(Class<T> contribution) {
        return this.m_contributionHolder.getContribution(contribution);
    }

    protected final void callInitializer() {
        this.interceptInitConfig();
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IDataModelEntity.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredOneToMany() {
        return true;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=60.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitEntity() throws ProcessingException {
    }

    private List<Class<IDataModelAttribute>> getConfiguredAttributes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IDataModelAttribute.class);
    }

    private List<Class<IDataModelEntity>> getConfiguredEntities() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IDataModelEntity.class);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractDataModelEntity.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.m_visibleGranted = true;
        this.m_contributionHolder = new ContributionComposite(this);
        this.setText(this.getConfiguredText());
        this.setIconId(this.getConfiguredIconId());
        this.setVisible(this.getConfiguredVisible());
        this.setOneToMany(this.getConfiguredOneToMany());
        this.setOrder(this.calculateViewOrder());
        List<Class<IDataModelAttribute>> configuredAttributes = this.getConfiguredAttributes();
        List<IDataModelAttribute> contributedAttributes = this.m_contributionHolder.getContributionsByClass(IDataModelAttribute.class);
        OrderedCollection attributes = new OrderedCollection();
        for (Class<IDataModelAttribute> c : configuredAttributes) {
            try {
                attributes.addOrdered((IOrdered)((IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)this, c)));
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + c.getName() + "'.", (Throwable)e));
            }
        }
        attributes.addAllOrdered(contributedAttributes);
        this.injectAttributesInternal((OrderedCollection<IDataModelAttribute>)attributes);
        ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)attributes);
        this.m_attributes = attributes.getOrderedList();
        for (IDataModelAttribute a : this.m_attributes) {
            if (!(a instanceof AbstractDataModelAttribute)) continue;
            ((AbstractDataModelAttribute)a).setParentEntity(this);
        }
        this.m_entities = new ArrayList<IDataModelEntity>();
    }

    public final List<? extends IDataModelEntityExtension<? extends AbstractDataModelEntity>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IDataModelEntityExtension<? extends AbstractDataModelEntity> createLocalExtension() {
        return new LocalDataModelEntityExtension<AbstractDataModelEntity>(this);
    }

    @Override
    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return this.m_objectExtensions.getExtension(c);
    }

    @Override
    public Map<String, String> getMetaDataOfEntity() {
        return null;
    }

    @Override
    public final void initEntity() throws ProcessingException {
        if (this.m_initialized) {
            return;
        }
        try {
            this.interceptInitEntity();
        }
        catch (Throwable t) {
            LOG.error("entity " + this, t);
        }
        for (IDataModelAttribute a : this.getAttributes()) {
            try {
                a.initAttribute();
            }
            catch (Throwable t) {
                LOG.error("attribute " + this + "/" + a, t);
            }
        }
        this.m_initialized = true;
        for (IDataModelEntity e : this.getEntities()) {
            try {
                e.initEntity();
            }
            catch (Throwable t) {
                LOG.error("entity " + this + "/" + e, t);
            }
        }
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.setVisiblePermissionInternal(p);
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    protected void setVisiblePermissionInternal(Permission p) {
        this.m_visiblePermission = p;
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.setVisibleProperty(b);
        this.calculateVisible();
    }

    protected void setVisibleProperty(boolean b) {
        this.m_visibleProperty = b;
    }

    protected boolean isVisibleProperty() {
        return this.m_visibleProperty;
    }

    @Override
    public boolean isOneToMany() {
        return this.m_oneToMany;
    }

    @Override
    public void setOneToMany(boolean b) {
        this.m_oneToMany = b;
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.m_visibleProperty);
    }

    public double getOrder() {
        return this.m_order;
    }

    public void setOrder(double order) {
        this.m_order = order;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void setIconId(String s) {
        this.m_iconId = s;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String s) {
        this.m_text = s;
    }

    @Override
    public List<IDataModelAttribute> getAttributes() {
        return CollectionUtility.arrayList(this.m_attributes);
    }

    @Override
    public List<IDataModelEntity> getEntities() {
        return CollectionUtility.arrayList(this.m_entities);
    }

    @Override
    public IDataModelAttribute getAttribute(Class<? extends IDataModelAttribute> attributeClazz) {
        for (IDataModelAttribute attribute : this.m_attributes) {
            if (attribute.getClass() != attributeClazz) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public IDataModelEntity getEntity(Class<? extends IDataModelEntity> entityClazz) {
        for (IDataModelEntity entity : this.m_entities) {
            if (entity.getClass() != entityClazz) continue;
            return entity;
        }
        return null;
    }

    @Override
    public IDataModelEntity getParentEntity() {
        return this.m_parentEntity;
    }

    public void setParentEntity(IDataModelEntity parent) {
        this.m_parentEntity = parent;
    }

    @Override
    public void initializeChildEntities(Map<Class<? extends IDataModelEntity>, IDataModelEntity> instanceMap) {
        if (!this.m_initializedChildEntities) {
            this.m_initializedChildEntities = true;
            List<Class<IDataModelEntity>> configuredEntities = this.getConfiguredEntities();
            List<IDataModelEntity> contributedEntities = this.m_contributionHolder.getContributionsByClass(IDataModelEntity.class);
            int numEntities = configuredEntities.size() + contributedEntities.size();
            HashSet<IDataModelEntity> newConfiguredInstances = new HashSet<IDataModelEntity>(numEntities);
            OrderedCollection entities = new OrderedCollection();
            for (Class<IDataModelEntity> c : configuredEntities) {
                try {
                    IDataModelEntity e = instanceMap.get(c);
                    if (e == null) {
                        e = (IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)this, c);
                        newConfiguredInstances.add(e);
                        instanceMap.put(c, e);
                    }
                    entities.addOrdered((IOrdered)e);
                }
                catch (Exception ex) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + c.getName() + "'.", (Throwable)ex));
                }
            }
            newConfiguredInstances.addAll(contributedEntities);
            entities.addAllOrdered(contributedEntities);
            this.injectEntitiesInternal((OrderedCollection<IDataModelEntity>)entities);
            ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)entities);
            this.m_entities.clear();
            this.m_entities.addAll(entities.getOrderedList());
            for (IDataModelEntity e : this.m_entities) {
                AbstractDataModelEntity adme;
                if (!(e instanceof AbstractDataModelEntity) || (adme = (AbstractDataModelEntity)e).getParentEntity() == this) continue;
                adme.setParentEntity(this);
            }
            for (IDataModelEntity e : this.m_entities) {
                if (!newConfiguredInstances.contains(e) && instanceMap.containsKey(e.getClass())) continue;
                e.initializeChildEntities(instanceMap);
            }
        }
    }

    protected void injectAttributesInternal(OrderedCollection<IDataModelAttribute> attributes) {
    }

    protected void injectEntitiesInternal(OrderedCollection<IDataModelEntity> entities) {
    }

    protected final void interceptInitEntity() throws ProcessingException {
        List<? extends IDataModelEntityExtension<? extends AbstractDataModelEntity>> extensions = this.getAllExtensions();
        DataModelEntityChains.DataModelEntityInitEntityChain chain = new DataModelEntityChains.DataModelEntityInitEntityChain(extensions);
        chain.execInitEntity();
    }

    protected static class LocalDataModelEntityExtension<OWNER extends AbstractDataModelEntity>
    extends AbstractSerializableExtension<OWNER>
    implements IDataModelEntityExtension<OWNER> {
        private static final long serialVersionUID = 1L;

        public LocalDataModelEntityExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execInitEntity(DataModelEntityChains.DataModelEntityInitEntityChain chain) throws ProcessingException {
            ((AbstractDataModelEntity)this.getOwner()).execInitEntity();
        }
    }
}

