/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.eclipse.scout.rt.shared.extension.IMoveModelObjectToRootMarker;
import org.eclipse.scout.rt.shared.extension.IllegalExtensionException;
import org.eclipse.scout.rt.shared.extension.MoveDescriptor;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractMoveModelObjectHandler<ORDERED extends IOrdered> {
    private final OrderedCollection<ORDERED> m_rootModelObjects;
    private final String m_modelObjectTypeName;
    private final IInternalExtensionRegistry m_extensionRegistry;

    public AbstractMoveModelObjectHandler(String modelObjectTypeName, OrderedCollection<ORDERED> rootModelObjects) {
        this.m_rootModelObjects = rootModelObjects;
        this.m_modelObjectTypeName = modelObjectTypeName;
        this.m_extensionRegistry = (IInternalExtensionRegistry)SERVICES.getService(IInternalExtensionRegistry.class);
    }

    protected abstract ORDERED getParent(ORDERED var1);

    protected abstract void removeChild(ORDERED var1, ORDERED var2);

    protected abstract void addChild(ORDERED var1, ORDERED var2);

    protected abstract void sortChildren(ORDERED var1);

    protected abstract List<ORDERED> collectAllModelObjects();

    protected OrderedCollection<? extends ORDERED> getRootModelObjects() {
        return this.m_rootModelObjects;
    }

    public void moveModelObjects() {
        List<ORDERED> allModelObject = this.collectAllModelObjects();
        Set<MoveDescriptor<ORDERED>> moveDescriptors = this.collectMoveDescriptors(allModelObject);
        if (CollectionUtility.isEmpty(moveDescriptors)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (MoveDescriptor<ORDERED> moveDescriptor : moveDescriptors) {
            IOrdered modelObject = (IOrdered)moveDescriptor.getModel();
            IOrdered oldParent = this.getParent(modelObject);
            Class newContainer = null;
            ClassIdentifier newContainerIdentifer = moveDescriptor.getNewContainerIdentifer();
            if (newContainerIdentifer != null) {
                if (newContainerIdentifer.size() > 1) {
                    throw new IllegalExtensionException("multi-segment move target class identifier are not supported by this handler. " + moveDescriptor);
                }
                newContainer = newContainerIdentifer.getLastSegment();
            }
            if (oldParent == null && (newContainer == null || newContainer == IMoveModelObjectToRootMarker.class)) {
                this.applyOrder(moveDescriptor, modelObject);
                continue;
            }
            if (oldParent != null && newContainer == IMoveModelObjectToRootMarker.class) {
                this.removeChild(oldParent, modelObject);
                this.applyOrder(moveDescriptor, modelObject);
                this.m_rootModelObjects.addOrdered(modelObject);
                continue;
            }
            if (newContainer == null) {
                this.applyOrder(moveDescriptor, modelObject);
                this.sortChildren(oldParent);
                continue;
            }
            IOrdered newParent = null;
            for (IOrdered a : allModelObject) {
                if (!newContainer.isInstance(a) || a == modelObject) continue;
                newParent = a;
                break;
            }
            if (newParent == null) {
                if (sb.length() == 0) {
                    sb.append("Invalid ").append(this.m_modelObjectTypeName).append(" move commands:");
                }
                sb.append("  \n").append(this.m_modelObjectTypeName).append(" '").append(modelObject).append("' cannot be moved into container '").append(newParent).append("'");
                continue;
            }
            if (oldParent == null) {
                this.m_rootModelObjects.remove((Object)modelObject);
            } else {
                this.removeChild(oldParent, modelObject);
            }
            this.applyOrder(moveDescriptor, modelObject);
            this.addChild(newParent, modelObject);
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    protected void applyOrder(MoveDescriptor<ORDERED> moveItem, ORDERED ordered) {
        Double newOrder = moveItem.getNewOrder();
        if (newOrder != null) {
            ordered.setOrder(newOrder.doubleValue());
        }
    }

    protected Set<MoveDescriptor<ORDERED>> collectMoveDescriptors(List<ORDERED> orderedObjects) {
        if (CollectionUtility.isEmpty(orderedObjects)) {
            return null;
        }
        HashSet<MoveDescriptor<ORDERED>> moveDescriptors = new HashSet<MoveDescriptor<ORDERED>>();
        for (IOrdered o : orderedObjects) {
            MoveDescriptor<IOrdered> moveDesc = this.m_extensionRegistry.createModelMoveDescriptorFor(o, null);
            if (moveDesc == null) continue;
            moveDescriptors.add(moveDesc);
        }
        return moveDescriptors;
    }
}

