/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.security;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.BasicPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.security.FineGrainedAccessCheckRequiredException;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class BasicHierarchyPermission
extends BasicPermission {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BasicHierarchyPermission.class);
    public static final int LEVEL_UNDEFINED = -1;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_ALL = 100;
    private static long cacheTimeout = 60000L;
    private boolean m_readOnly;
    private int m_level;
    private List<Integer> m_validLevels;

    public static long getCacheTimeoutMillis() {
        return cacheTimeout;
    }

    public static void setCacheTimeoutMillis(long t) {
        cacheTimeout = t;
    }

    public BasicHierarchyPermission(String name) {
        this(name, -1);
    }

    public BasicHierarchyPermission(String name, int level) {
        super(name);
        this.buildLevelCache();
        this.setLevel(level);
    }

    private void buildLevelCache() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        Field[] f = this.getClass().getFields();
        int i = 0;
        while (i < f.length) {
            int flags = f[i].getModifiers();
            if (Modifier.isStatic(flags) && Modifier.isFinal(flags) && f[i].getName().startsWith("LEVEL_")) {
                try {
                    int value = f[i].getInt(null);
                    if (set.contains(value)) {
                        throw new IllegalArgumentException("level " + f[i].getName() + " has the same value (" + value + ") as another level");
                    }
                    set.add(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("could not build internal level cache", e);
                }
            }
            ++i;
        }
        this.m_validLevels = new ArrayList<Integer>(set);
    }

    public final List<Integer> getValidLevels() {
        return CollectionUtility.arrayList(this.m_validLevels);
    }

    public final int getLevel() {
        return this.m_level;
    }

    public final void setLevel(int level) {
        if (this.m_readOnly) {
            throw new SecurityException("Permission is read-only");
        }
        if (!this.m_validLevels.contains(level)) {
            throw new IllegalArgumentException("invalid level: " + level);
        }
        this.m_level = level;
    }

    public final void setReadOnly() {
        this.m_readOnly = true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BasicHierarchyPermission) {
            BasicHierarchyPermission other = (BasicHierarchyPermission)obj;
            if (this.m_level == other.m_level && super.equals(obj)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.m_level;
    }

    protected String getConfiguredId() {
        return null;
    }

    @Override
    public boolean implies(Permission p) {
        if (this.getClass().isAssignableFrom(p.getClass())) {
            BasicHierarchyPermission other = (BasicHierarchyPermission)p;
            if (super.implies(p)) {
                switch (this.m_level) {
                    case 100: {
                        return true;
                    }
                    case -1: {
                        LOG.warn("The level of a " + this.getClass().getSimpleName() + " in the permission collection should not have the level LEVEL_UNDEFINED");
                        return false;
                    }
                    case 0: {
                        return false;
                    }
                }
                if (other.m_level == -1) {
                    if (this.checkLevel(other, this.m_level)) {
                        return true;
                    }
                } else {
                    return this.m_level >= other.m_level;
                }
            }
        }
        return false;
    }

    private boolean checkLevel(BasicHierarchyPermission other, int level) {
        if (((IAccessControlService)SERVICES.getService(IAccessControlService.class)).isProxyService()) {
            throw new FineGrainedAccessCheckRequiredException();
        }
        try {
            boolean b = other.execCheckLevel(level);
            return b;
        }
        catch (ProcessingException e) {
            throw new SecurityException(e);
        }
    }

    protected boolean execCheckLevel(int requiredLevel) throws ProcessingException {
        Object[][] data = this.execCheckLevelData(requiredLevel);
        return data != null && data.length > 0 && (Boolean)TypeCastUtility.castValue((Object)data[0][0], Boolean.class) != false;
    }

    protected Object[][] execCheckLevelData(int requiredLevel) throws ProcessingException {
        return null;
    }
}

