/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.clientnotification.AbstractClientNotification;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;

public class CodeTypeChangedNotification
extends AbstractClientNotification {
    private static final long serialVersionUID = 1L;
    private List<Class<? extends ICodeType<?, ?>>> m_codeTypes;

    public CodeTypeChangedNotification(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        for (Class<ICodeType<Serializable, Serializable>> clazz : types) {
            if (clazz == null || !clazz.isAssignableFrom(Serializable.class)) continue;
            throw new ProcessingException("Code type '" + clazz.getName() + "' is not serializable!");
        }
        this.m_codeTypes = CollectionUtility.arrayList(types);
    }

    @Override
    public boolean coalesce(IClientNotification existingNotification) {
        CodeTypeChangedNotification n = (CodeTypeChangedNotification)existingNotification;
        HashSet set = new HashSet();
        set.addAll(this.m_codeTypes);
        set.addAll(n.m_codeTypes);
        this.m_codeTypes = new ArrayList(set);
        if (!this.getOriginalServerNode().equals(existingNotification.getOriginalServerNode())) {
            this.setOriginalServerNode("");
        }
        return true;
    }

    public List<Class<? extends ICodeType<?, ?>>> getCodeTypes() {
        return CollectionUtility.arrayList(this.m_codeTypes);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append("[");
        if (CollectionUtility.hasElements(this.m_codeTypes)) {
            Iterator<Class<ICodeType<?, ?>>> codeTypeIt = this.m_codeTypes.iterator();
            b.append(codeTypeIt.next().getSimpleName());
            while (codeTypeIt.hasNext()) {
                b.append(", ").append(codeTypeIt.next().getSimpleName());
            }
        }
        b.append("]");
        return b.toString();
    }
}

