/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCache;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;

public class CodeTypeStore {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeTypeStore.class);
    private Object m_storeLock = new Object();
    private HashMap<PartitionLanguageComposite, CodeTypeCache> m_store = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeTypeCache getCodeTypeCache(Long partitionId, Locale locale) {
        Object object = this.m_storeLock;
        synchronized (object) {
            String key = locale.toString();
            PartitionLanguageComposite comp = new PartitionLanguageComposite(partitionId, key);
            CodeTypeCache cache = this.m_store.get(comp);
            if (cache == null) {
                cache = new CodeTypeCache();
                this.m_store.put(comp, cache);
            }
            return cache;
        }
    }

    public void unloadCodeTypeCache(Class<? extends ICodeType<?, ?>> type) throws ProcessingException {
        ArrayList codeTypeList = new ArrayList();
        codeTypeList.add(type);
        this.unloadCodeTypeCache(codeTypeList);
    }

    public void unloadCodeTypeCacheNoFire(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        for (CodeTypeCache cache : this.m_store.values()) {
            cache.unloadCodeTypes(types);
        }
    }

    public void unloadCodeTypeCache(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        for (CodeTypeCache cache : this.m_store.values()) {
            cache.unloadCodeTypes(types);
        }
    }

    private class PartitionLanguageComposite {
        private Long partitionId;
        private String language;

        public PartitionLanguageComposite(Long partitionId, String language) {
            this.partitionId = partitionId;
            this.language = language;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.partitionId == null ? 0 : this.partitionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionLanguageComposite other = (PartitionLanguageComposite)obj;
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            return !(this.partitionId == null ? other.partitionId != null : !this.partitionId.equals(other.partitionId));
        }
    }
}

