/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelRequest;

public class ServiceTunnelRequest
implements IServiceTunnelRequest {
    private static final long serialVersionUID = 0L;
    private static final AtomicLong requestSequenceGenerator = new AtomicLong();
    private String m_serviceInterfaceClassName;
    private String m_operation;
    private Class[] m_parameterTypes;
    private Object[] m_args;
    private Locale m_locale;
    private String m_userAgent;
    private String m_version;
    private Set<String> m_consumedNotificationIds;
    private final long m_requestSequence = requestSequenceGenerator.incrementAndGet();
    private String m_virtualSessionId;
    private transient Subject m_clientSubject;

    private ServiceTunnelRequest() {
    }

    public ServiceTunnelRequest(String version, Class serviceInterfaceClass, Method operation, Object[] args) {
        this(version, serviceInterfaceClass.getName(), operation.getName(), operation.getParameterTypes(), args);
    }

    public ServiceTunnelRequest(String version, String serviceInterfaceName, String op, Class[] parameterTypes, Object[] args) {
        this.m_version = version;
        this.m_serviceInterfaceClassName = serviceInterfaceName;
        this.m_operation = op;
        this.m_parameterTypes = parameterTypes;
        this.m_args = args;
        if (this.m_args == null) {
            this.m_args = new Object[0];
        }
        this.m_locale = LocaleThreadLocal.get();
    }

    @Override
    public long getRequestSequence() {
        return this.m_requestSequence;
    }

    @Override
    public String getServiceInterfaceClassName() {
        return this.m_serviceInterfaceClassName;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    @Override
    public String getOperation() {
        return this.m_operation;
    }

    @Override
    public Class[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    @Override
    public Object[] getArgs() {
        return this.m_args;
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public Subject getClientSubject() {
        return this.m_clientSubject;
    }

    public void setClientSubject(Subject requestSubject) {
        this.m_clientSubject = requestSubject;
    }

    @Override
    public String getVirtualSessionId() {
        return this.m_virtualSessionId;
    }

    public void setVirtualSessionId(String virtualSessionId) {
        this.m_virtualSessionId = virtualSessionId;
    }

    @Override
    public String getUserAgent() {
        return this.m_userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
    }

    public void setConsumedNotifications(Set<String> notificationsIds) {
        this.m_consumedNotificationIds = notificationsIds;
    }

    @Override
    public Set<String> getConsumedNotifications() {
        return this.m_consumedNotificationIds;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Service call " + this.m_serviceInterfaceClassName + "." + this.m_operation);
        if (this.m_args != null && this.m_args.length > 0) {
            int i = 0;
            while (i < this.m_args.length) {
                buf.append("\n");
                buf.append("arg[" + i + "]=" + VerboseUtility.dumpObject((Object)this.m_args[i]));
                ++i;
            }
        }
        return buf.toString();
    }

    public static String toSoapOperation(String className, String methodName) {
        if (className == null || methodName == null) {
            return null;
        }
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return String.valueOf(className) + "__" + methodName;
        }
        String simpleName = className.substring(i + 1);
        String packageName = className.substring(0, i);
        if ((i = packageName.lastIndexOf(46)) < 0) {
            return String.valueOf(packageName) + "_" + simpleName + "__" + methodName;
        }
        StringBuilder buf = new StringBuilder();
        String[] stringArray = packageName.substring(0, i).split("[.]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            buf.append(s.charAt(0));
            ++n2;
        }
        buf.append("_");
        buf.append(packageName.substring(i + 1));
        buf.append("_");
        buf.append(simpleName);
        buf.append("__");
        buf.append(methodName);
        return buf.toString();
    }
}

