/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.spec.client.AbstractSpecGenTest;
import org.eclipse.scout.rt.spec.client.config.ConfigRegistry;
import org.eclipse.scout.rt.spec.client.gen.FormSpecGenerator;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.screenshot.FormScreenshotPrinter;
import org.eclipse.scout.rt.spec.client.screenshot.PrintScreenshotsFormListener;
import org.eclipse.scout.rt.spec.client.utility.SpecIOUtility;
import org.eclipse.scout.rt.spec.client.utility.SpecUtility;

public abstract class AbstractFormSpecTest
extends AbstractSpecGenTest {
    @Override
    public void generateSpec() throws ProcessingException {
        List<File> screenshots = this.printScreenshots();
        IForm form = this.createAndStartForm(Collections.emptyList());
        form.activate();
        IDocSection doc = this.generateDocSection(form);
        this.writeMediawikiFile(doc, SpecUtility.getSpecFileBaseName((ITypeWithClassId)form), this.getImagePaths(screenshots));
        form.doClose();
    }

    protected List<File> printScreenshots() throws ProcessingException {
        ArrayList<FormListener> formListeners = new ArrayList<FormListener>();
        PrintScreenshotsFormListener listener = new PrintScreenshotsFormListener(new FormScreenshotPrinter(ConfigRegistry.getSpecFileConfigInstance().getImageDir()));
        formListeners.add(listener);
        IForm form = this.createAndStartForm(formListeners);
        form.activate();
        form.waitFor();
        return listener.getPrintedFiles();
    }

    protected abstract IForm createAndStartForm(List<FormListener> var1) throws ProcessingException;

    protected IDocSection generateDocSection(IForm form) {
        FormSpecGenerator g = new FormSpecGenerator(this.getConfiguration());
        return g.getDocSection(form);
    }

    protected String[] getImagePaths(List<File> screenshots) throws ProcessingException {
        File[] files = (File[])CollectionUtility.toArray(screenshots, File.class);
        return SpecIOUtility.addPrefix(SpecIOUtility.getRelativePaths(files, ConfigRegistry.getSpecFileConfigInstance().getSpecDir()), "../");
    }

    @Override
    protected int getTopHeadingLevel() {
        return this.getConfiguration().getFormConfig().getTopHeadingLevel();
    }
}

