/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.ISpecProcessor;
import org.eclipse.scout.rt.spec.client.config.ConfigRegistry;
import org.eclipse.scout.rt.spec.client.utility.SpecIOUtility;
import org.eclipse.scout.rt.spec.client.utility.SpecUtility;
import org.osgi.framework.Bundle;

public class LinearOutputPostProcessor
implements ISpecProcessor {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(LinearOutputPostProcessor.class);
    public static final String ANCHOR_PREFIX = "lo_";
    private File m_configFile;
    private String m_outputFileName;

    public LinearOutputPostProcessor(String configFile) throws ProcessingException {
        List<Bundle> sourceBundles = ConfigRegistry.getSpecFileConfigInstance().getSourceBundles();
        Collections.reverse(sourceBundles);
        for (Bundle bundle : sourceBundles) {
            List<String> fileList = SpecIOUtility.listFiles(bundle, ConfigRegistry.getSpecFileConfigInstance().getRelativeSourceDirPath(), this.getConfigFileFilter(configFile));
            if (fileList.size() <= 0) continue;
            this.m_configFile = new File(ConfigRegistry.getSpecFileConfigInstance().getSpecDir(), configFile);
            SpecIOUtility.copyFile(bundle, String.valueOf(ConfigRegistry.getSpecFileConfigInstance().getRelativeSourceDirPath()) + File.separator + configFile, this.m_configFile);
            break;
        }
        if (this.m_configFile == null || !this.m_configFile.exists()) {
            LOG.error("Configfile " + configFile + " could not be copied!");
        } else {
            this.m_outputFileName = this.m_configFile.getName().replace(".config", ".mediawiki");
        }
    }

    protected FilenameFilter getConfigFileFilter(final String configFile) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(configFile);
            }
        };
    }

    @Override
    public void process() throws ProcessingException {
        if (this.m_configFile == null || !this.m_configFile.exists()) {
            return;
        }
        File outputFile = this.concatenateFiles();
        this.prefixAnchorsAndLinks(outputFile);
    }

    protected void prefixAnchorsAndLinks(File outputFile) throws ProcessingException {
        SpecIOUtility.process(outputFile, new P_AnchorProcessor("(\\{\\{a:)([^}]+}})"));
        SpecIOUtility.process(outputFile, new P_AnchorProcessor("(\\[\\[)([A-Za-z][A-Za-z0-9_\\.-]+\\|)"));
    }

    protected File concatenateFiles() throws ProcessingException {
        File outputFile = null;
        List configEntries = IOUtility.readLines((File)this.m_configFile, (String)"UTF-8");
        ArrayList<String> referencedFileNames = new ArrayList<String>();
        PrintWriter writer = null;
        outputFile = new File(ConfigRegistry.getSpecFileConfigInstance().getMediawikiDir(), this.m_outputFileName);
        outputFile.delete();
        try {
            try {
                outputFile.createNewFile();
                writer = new PrintWriter(outputFile);
                for (String configEntry : configEntries) {
                    if (this.isComment(configEntry)) continue;
                    File file = this.findFileForConfigEntry(configEntry);
                    if (file != null) {
                        referencedFileNames.add(file.getName());
                        IOUtility.appendFile((PrintWriter)writer, (File)file);
                        writer.flush();
                        continue;
                    }
                    LOG.warn("No file found for config entry: " + configEntry + ". Skipping...");
                }
            }
            catch (IOException e) {
                throw new ProcessingException("Error creating output file.", (Throwable)e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        this.logMissingEntries(referencedFileNames);
        return outputFile;
    }

    protected void logMissingEntries(List<String> referencedFilenames) throws ProcessingException {
        String suffix = ".mediawiki";
        String[] fileList = ConfigRegistry.getSpecFileConfigInstance().getMediawikiDir().list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".mediawiki");
            }
        });
        if (fileList != null) {
            String[] stringArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (!referencedFilenames.contains(file) && !this.m_outputFileName.equals(file)) {
                    LOG.warn("There is no entry for the existing file " + file + " in " + this.m_configFile.getName() + ".");
                }
                ++n2;
            }
        }
    }

    protected boolean isComment(String configEntry) {
        return configEntry.startsWith("#");
    }

    protected File findFileForConfigEntry(String configEntry) throws ProcessingException {
        File file = new File(ConfigRegistry.getSpecFileConfigInstance().getMediawikiDir(), String.valueOf(configEntry) + ".mediawiki");
        if (file.exists()) {
            return file;
        }
        Set<Class<?>> allClasses = SpecUtility.getAllDocEntityClasses();
        for (Class<?> c : allClasses) {
            if (!configEntry.equals(c.getSimpleName()) && !configEntry.equals(c.getName())) continue;
            File fileForClass = this.findFileForClass(c);
            if (fileForClass == null) {
                Set<Class> subclasses = this.getSubClassesOrderdByDistance(c, allClasses);
                for (Class subclass : subclasses) {
                    fileForClass = this.findFileForClass(subclass);
                    if (fileForClass != null) break;
                }
            }
            return fileForClass;
        }
        return null;
    }

    protected Set<Class> getSubClassesOrderdByDistance(final Class<?> c, Set<Class<?>> allClasses) {
        TreeSet<Class> subclasses = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                Integer distanceO1 = LinearOutputPostProcessor.getDistance(o1, c);
                Integer distanceO2 = LinearOutputPostProcessor.getDistance(o2, c);
                return distanceO1.compareTo(distanceO2);
            }
        });
        for (Class<?> candidate : allClasses) {
            if (!c.isAssignableFrom(candidate) || c == candidate) continue;
            subclasses.add(candidate);
        }
        return subclasses;
    }

    protected static int getDistance(Class subClass, Class<?> superClass) {
        if (!superClass.isAssignableFrom(subClass) || subClass == superClass || subClass.isInterface() || superClass.isInterface()) {
            throw new IllegalArgumentException();
        }
        int distance = 0;
        Class c = subClass;
        while (c != superClass) {
            c = c.getSuperclass();
            ++distance;
        }
        return distance;
    }

    protected File findFileForClass(Class c) throws ProcessingException {
        File[] mediawikiFiles;
        File[] fileArray = mediawikiFiles = ConfigRegistry.getSpecFileConfigInstance().getMediawikiDir().listFiles();
        int n = mediawikiFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(String.valueOf(c.getSimpleName()) + "_")) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    protected static class P_AnchorProcessor
    implements SpecIOUtility.IStringProcessor {
        private String m_twoGroupRegex;

        public P_AnchorProcessor(String twoGroupRegex) {
            this.m_twoGroupRegex = twoGroupRegex;
        }

        @Override
        public String processLine(String input) {
            Pattern pattern = Pattern.compile(this.m_twoGroupRegex);
            Matcher matcher = pattern.matcher(input);
            StringBuilder sb = new StringBuilder();
            int index = 0;
            while (matcher.find()) {
                sb.append(input.substring(index, matcher.start(0)));
                sb.append(matcher.group(1)).append(LinearOutputPostProcessor.ANCHOR_PREFIX).append(matcher.group(2));
                index = matcher.end();
            }
            sb.append(input.substring(index));
            return sb.toString();
        }
    }
}

