/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.spec.client.AbstractSpecGenTest;
import org.eclipse.scout.rt.spec.client.config.ConfigRegistry;
import org.eclipse.scout.rt.spec.client.utility.SpecIOUtility;

public class ManualSpecTest
extends AbstractSpecGenTest {
    @Override
    public void generateSpec() throws ProcessingException {
        this.copyMediawikiFiles();
        this.copyImages();
    }

    protected void copyImages() throws ProcessingException {
        File dest = ConfigRegistry.getSpecFileConfigInstance().getImageDir();
        dest.mkdirs();
        String bundleRelativeSourceDirPath = ConfigRegistry.getSpecFileConfigInstance().getRelativeImagesSourceDirPath();
        FilenameFilter filenameFilter = this.getFilter();
        SpecIOUtility.copyFilesFromAllSourceBundles(dest, bundleRelativeSourceDirPath, filenameFilter);
    }

    protected void copyMediawikiFiles() throws ProcessingException {
        File dest = ConfigRegistry.getSpecFileConfigInstance().getMediawikiDir();
        dest.mkdirs();
        String bundleRelativeSourceDirPath = ConfigRegistry.getSpecFileConfigInstance().getRelativeMediawikiSourceDirPath();
        FilenameFilter filenameFilter = this.getFilter();
        SpecIOUtility.copyFilesFromAllSourceBundles(dest, bundleRelativeSourceDirPath, filenameFilter);
    }

    protected FilenameFilter getFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        };
    }
}

