/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.spec.client.config.ConfigRegistry;
import org.eclipse.scout.rt.spec.client.gen.extract.AbstractNamedTextExtractor;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiUtility;
import org.eclipse.scout.rt.spec.client.utility.SpecIOUtility;

public class TablePageIconExtractor
extends AbstractNamedTextExtractor<IPageWithTable<? extends ITable>> {
    private static final String ICONS_SUBDIR = "icons";
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TablePageIconExtractor.class);

    public TablePageIconExtractor() {
        super(TEXTS.get((String)"org.eclipse.scout.rt.spec.icon"));
    }

    @Override
    public String getText(IPageWithTable<? extends ITable> page) {
        String iconId = page.getCell().getIconId();
        File file = this.copyIcon(iconId);
        if (file != null) {
            File baseDir;
            try {
                baseDir = ConfigRegistry.getSpecFileConfigInstance().getSpecDir();
            }
            catch (ProcessingException e) {
                LOG.error("Could not get configuration for mediawiki-dir.");
                return "";
            }
            return MediawikiUtility.createImageLink("../" + SpecIOUtility.getReleativePath(baseDir, file));
        }
        return "";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File copyIcon(String iconId) {
        FileOutputStream outputStream = null;
        IClientSession clientSession = ClientJob.getCurrentSession();
        IconSpec iconSpec = clientSession.getIconLocator().getIconSpec(iconId);
        File icon = null;
        if (iconSpec == null) return icon;
        String fileName = iconSpec.getName();
        try {
            try {
                File dir = new File(ConfigRegistry.getSpecFileConfigInstance().getImageDir(), ICONS_SUBDIR);
                dir.mkdirs();
                icon = new File(dir, fileName);
                if (icon.exists()) return icon;
                outputStream = new FileOutputStream(icon);
                outputStream.write(iconSpec.getContent());
                return icon;
            }
            catch (ProcessingException e) {
                this.logException(iconId, (Exception)((Object)e));
                if (outputStream == null) return icon;
                try {
                    outputStream.close();
                    return icon;
                }
                catch (IOException e2) {
                    LOG.error("Could not close outputstream.", (Throwable)e2);
                }
                return icon;
            }
            catch (FileNotFoundException e) {
                this.logException(iconId, e);
                if (outputStream == null) return icon;
                try {
                    outputStream.close();
                    return icon;
                }
                catch (IOException e3) {
                    LOG.error("Could not close outputstream.", (Throwable)e3);
                }
                return icon;
            }
            catch (IOException e) {
                this.logException(iconId, e);
                if (outputStream == null) return icon;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    outputStream.close();
                    return icon;
                }
                catch (IOException e4) {
                    LOG.error("Could not close outputstream.", (Throwable)e4);
                }
                return icon;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOG.error("Could not close outputstream.", (Throwable)e);
                }
            }
        }
    }

    protected void logException(String iconId, Exception e) {
        LOG.error("Could not create icon image for " + iconId, (Throwable)e);
    }
}

