/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.out.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.IDocTable;

public class Section
implements IDocSection {
    protected final IDocTable m_table;
    protected final ArrayList<IDocSection> m_subSections;
    protected String m_title;
    protected String m_introduction;

    public Section(String title, IDocSection ... subSections) {
        this(title, (String)null, (IDocTable)null, subSections);
    }

    public Section(String title, IDocTable table, IDocSection ... subSections) {
        this(title, null, table, subSections);
    }

    public Section(String title, String introduction, IDocTable table, IDocSection ... subSections) {
        this.m_title = title;
        this.m_introduction = introduction;
        this.m_table = table;
        this.m_subSections = new ArrayList();
        IDocSection[] iDocSectionArray = subSections;
        int n = subSections.length;
        int n2 = 0;
        while (n2 < n) {
            IDocSection subSection = iDocSectionArray[n2];
            if (subSection != null) {
                this.m_subSections.add(subSection);
            }
            ++n2;
        }
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public String getIntroduction() {
        return this.m_introduction;
    }

    @Override
    public List<IDocSection> getSubSections() {
        return CollectionUtility.arrayList(this.m_subSections);
    }

    @Override
    public IDocTable getTable() {
        return this.m_table;
    }

    @Override
    public boolean hasSubSections() {
        return this.m_subSections.size() > 0;
    }

    @Override
    public boolean hasTableCellTexts() {
        return this.getTable() != null && this.getTable().getCellTexts() != null && this.getTable().getCellTexts().length > 0;
    }

    @Override
    public boolean isDisplayed() {
        return this.hasSubSections() || this.hasTableCellTexts();
    }
}

