/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server.runner;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.testing.server.DefaultTestServerSessionProvider;
import org.eclipse.scout.rt.testing.server.ITestServerSessionProvider;
import org.eclipse.scout.rt.testing.server.runner.IServerTestEnvironment;
import org.eclipse.scout.rt.testing.server.runner.RunAftersInSeparateScoutServerSession;
import org.eclipse.scout.rt.testing.server.runner.RunBeforesInSeparateScoutServerSession;
import org.eclipse.scout.rt.testing.server.runner.ScoutServerJobWrapperStatement;
import org.eclipse.scout.rt.testing.shared.services.common.exceptionhandler.ProcessingRuntimeExceptionUnwrappingStatement;
import org.eclipse.scout.service.SERVICES;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class ScoutServerTestRunner
extends BlockJUnit4ClassRunner {
    private static Class<? extends IServerSession> s_defaultServerSessionClass;
    private static String s_defaultPrincipalName;
    private static ITestServerSessionProvider s_defaultServerSessionProvider;
    private static final IServerJobService BACKEND_JOB_SERVICE;
    private static final IScoutLogger LOG;
    private static final IServerTestEnvironment FACTORY;
    private IServerJobFactory m_serverJobFactory;

    static {
        s_defaultServerSessionProvider = new DefaultTestServerSessionProvider();
        LOG = ScoutLogManager.getLogger(ScoutServerTestRunner.class);
        FACTORY = ScoutServerTestRunner.createServerTestEnvironmentFactory();
        BACKEND_JOB_SERVICE = (IServerJobService)SERVICES.getService(IServerJobService.class);
        if (FACTORY != null) {
            FACTORY.setupGlobalEnvironment();
        }
    }

    public ScoutServerTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        if (FACTORY != null) {
            FACTORY.setupInstanceEnvironment();
        }
        try {
            LoginInfo loginInfo = this.getOrCreateServerSession(klass.getAnnotation(ServerTest.class), null);
            this.m_serverJobFactory = this.createServerJobFactory(loginInfo);
        }
        catch (InitializationError e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error creating session", (Throwable)e);
            ArrayList<Exception> errors = new ArrayList<Exception>();
            errors.add(e);
            throw new InitializationError(errors);
        }
    }

    public static Class<? extends IServerSession> getDefaultServerSessionClass() {
        return s_defaultServerSessionClass;
    }

    public static void setDefaultServerSessionClass(Class<? extends IServerSession> defaultServerSessionClass) {
        s_defaultServerSessionClass = defaultServerSessionClass;
    }

    public static ITestServerSessionProvider getDefaultServerSessionProvider() {
        return s_defaultServerSessionProvider;
    }

    public static void setDefaultServerSessionProvider(ITestServerSessionProvider defaultServerSessionProvider) {
        s_defaultServerSessionProvider = defaultServerSessionProvider;
    }

    public static String getDefaultPrincipalName() {
        return s_defaultPrincipalName;
    }

    public static void setDefaultPrincipalName(String defaultPrincipalName) {
        s_defaultPrincipalName = defaultPrincipalName;
    }

    protected Class<? extends IServerSession> defaultServerSessionClass() {
        return ScoutServerTestRunner.getDefaultServerSessionClass();
    }

    protected ITestServerSessionProvider defaultServerSessionProvider() {
        return ScoutServerTestRunner.getDefaultServerSessionProvider();
    }

    protected String defaultPrincipalName() {
        return ScoutServerTestRunner.getDefaultPrincipalName();
    }

    protected IServerJobFactory createServerJobFactory(LoginInfo loginInfo) throws ProcessingException {
        return BACKEND_JOB_SERVICE.createJobFactory(loginInfo.getServerSession(), loginInfo.getSubject());
    }

    protected Statement withBeforeClasses(Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
        return befores.isEmpty() ? statement : new RunBeforesInSeparateScoutServerSession(this.m_serverJobFactory, statement, befores, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return afters.isEmpty() ? statement : new RunAftersInSeparateScoutServerSession(this.m_serverJobFactory, statement, afters, null);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        IServerJobFactory serverJobFactory = this.m_serverJobFactory;
        ServerTest methodLevelAnnotation = (ServerTest)method.getAnnotation(ServerTest.class);
        if (methodLevelAnnotation != null) {
            try {
                ServerTest classLevelAnnotation = this.getTestClass().getJavaClass().getAnnotation(ServerTest.class);
                LoginInfo loginInfo = this.getOrCreateServerSession(classLevelAnnotation, methodLevelAnnotation);
                serverJobFactory = this.createServerJobFactory(loginInfo);
            }
            catch (Throwable e) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        throw e;
                    }
                };
            }
        }
        return new ScoutServerJobWrapperStatement(serverJobFactory, super.methodBlock(method));
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        return super.possiblyExpectingExceptions(method, test, (Statement)new ProcessingRuntimeExceptionUnwrappingStatement(next));
    }

    protected LoginInfo getOrCreateServerSession(ServerTest classLevelServerTest, ServerTest methodLevelServerTest) throws Exception {
        Class<? extends IServerSession> serverSessionClass = this.defaultServerSessionClass();
        ITestServerSessionProvider sessionProvider = this.defaultServerSessionProvider();
        String runAs = this.defaultPrincipalName();
        if (classLevelServerTest != null) {
            serverSessionClass = this.extractSessionClass(classLevelServerTest, serverSessionClass);
            sessionProvider = this.extractSessionProvider(classLevelServerTest, sessionProvider);
            runAs = this.extractRunAs(classLevelServerTest, runAs);
        }
        if (methodLevelServerTest != null) {
            serverSessionClass = this.extractSessionClass(methodLevelServerTest, serverSessionClass);
            sessionProvider = this.extractSessionProvider(methodLevelServerTest, sessionProvider);
            runAs = this.extractRunAs(methodLevelServerTest, runAs);
        }
        if (serverSessionClass == null) {
            throw new InitializationError("Server session class is not set. Either set the default server session using '" + ScoutServerTestRunner.class.getSimpleName() + ".setDefaultServerSessionClass' or annotate your test class and/or method with '" + ServerTest.class.getSimpleName() + "'");
        }
        Subject subject = sessionProvider.login(runAs);
        IServerSession serverSession = sessionProvider.createServerSession(serverSessionClass, subject);
        return new LoginInfo(subject, serverSession);
    }

    protected Class<? extends IServerSession> extractSessionClass(ServerTest serverTest, Class<? extends IServerSession> defaultValue) {
        if (serverTest == null || serverTest.serverSessionClass() == null || serverTest.serverSessionClass() == IServerSession.class) {
            return defaultValue;
        }
        return serverTest.serverSessionClass();
    }

    protected ITestServerSessionProvider extractSessionProvider(ServerTest serverTest, ITestServerSessionProvider defaultValue) throws Exception {
        if (serverTest == null || serverTest.sessionProvider() == null || serverTest.sessionProvider() == NullTestServerSessionProvider.class) {
            return defaultValue;
        }
        return serverTest.sessionProvider().newInstance();
    }

    protected String extractRunAs(ServerTest serverTest, String defaultValue) {
        String s;
        String runAs = defaultValue;
        if (serverTest != null && serverTest.runAs() != null && (s = serverTest.runAs().trim()).length() > 0) {
            runAs = s;
        }
        return runAs;
    }

    private static IServerTestEnvironment createServerTestEnvironmentFactory() {
        IServerTestEnvironment environment = null;
        if (SerializationUtility.getClassLoader() != null) {
            try {
                Class<?> customTestEnvironment = SerializationUtility.getClassLoader().loadClass("org.eclipse.scout.testing.server.runner.CustomServerTestEnvironment");
                LOG.info("loaded custom test environment: [" + customTestEnvironment + "]");
                if (!IServerTestEnvironment.class.isAssignableFrom(customTestEnvironment)) {
                    LOG.warn("custom test environment is not implementing [" + IServerTestEnvironment.class + "]");
                } else if (Modifier.isAbstract(customTestEnvironment.getModifiers())) {
                    LOG.warn("custom test environment is an abstract class [" + customTestEnvironment + "]");
                } else {
                    environment = (IServerTestEnvironment)customTestEnvironment.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                LOG.debug("no custom custom test environment installed", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Unexpected problem while creating a new instance of custom test environment", (Throwable)e);
            }
        }
        return environment;
    }

    public static class LoginInfo {
        private final Subject m_subject;
        private final IServerSession m_serverSession;

        public LoginInfo(Subject subject, IServerSession serverSession) {
            this.m_serverSession = serverSession;
            this.m_subject = subject;
        }

        public Subject getSubject() {
            return this.m_subject;
        }

        public IServerSession getServerSession() {
            return this.m_serverSession;
        }
    }

    public static interface NullTestServerSessionProvider
    extends ITestServerSessionProvider {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface ServerTest {
        public Class<? extends IServerSession> serverSessionClass() default IServerSession.class;

        public Class<? extends ITestServerSessionProvider> sessionProvider() default NullTestServerSessionProvider.class;

        public String runAs() default "";
    }
}

