/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.mobile.action.RwtScoutActionButton;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ActionButtonBar
extends Composite {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ActionButtonBar.class);
    public static final int ORIENTATION_LEFT_TO_RIGHT = 0x2000000;
    public static final int ORIENTATION_RIGHT_TO_LEFT = 0x4000000;
    private static final long serialVersionUID = 1L;
    private static final String VARIANT_ACTION_BAR = "actionBar";
    private static final int BUTTON_SPACING = 6;
    private IMenu[] m_menus;
    private List<IMenu> m_displayedMenus;
    private IRwtEnvironment m_uiEnvironment;
    private Job m_handleButtonPilingJob;
    private Composite m_buttonBar;
    private int m_style;
    private boolean m_pilingEnabled;
    private int m_minNumberOfAlwaysVisibleButtons;
    private int m_maxNumberOfAlwaysVisibleButtons;
    private P_ScoutPropertyChangeListener m_scoutPropertyChangeListener;

    public ActionButtonBar(Composite parent, IRwtEnvironment uiEnvironment, IMenu[] menus) {
        this(parent, uiEnvironment, menus, -1);
    }

    public ActionButtonBar(Composite parent, IRwtEnvironment uiEnvironment, IMenu[] menus, int style) {
        super(parent, 0);
        this.m_menus = menus;
        this.m_uiEnvironment = uiEnvironment;
        if (style == -1) {
            style = 16384;
        }
        this.m_style = style;
        this.m_pilingEnabled = true;
        this.m_minNumberOfAlwaysVisibleButtons = 0;
        this.m_maxNumberOfAlwaysVisibleButtons = Integer.MAX_VALUE;
        this.m_displayedMenus = new LinkedList<IMenu>();
        this.m_displayedMenus.addAll(Arrays.asList(this.m_menus));
        if (menus != null && menus.length > 0) {
            this.attachScoutPropertyChangeListener();
        }
        this.createButtonBar();
        if (menus != null && menus.length > 0) {
            this.addListener(11, new P_ResizeListener());
            this.scheduleHandleButtonPilingInUiThread();
        }
        this.initLayout(this);
    }

    private void attachScoutPropertyChangeListener() {
        if (this.m_menus == null || this.m_menus.length == 0) {
            return;
        }
        if (this.m_scoutPropertyChangeListener != null) {
            return;
        }
        this.m_scoutPropertyChangeListener = new P_ScoutPropertyChangeListener();
        IMenu[] iMenuArray = this.m_menus;
        int n = this.m_menus.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu menu = iMenuArray[n2];
            menu.addPropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyChangeListener);
            ++n2;
        }
        this.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                ActionButtonBar.this.detachScoutPropertyChangeListener();
            }
        });
    }

    private void detachScoutPropertyChangeListener() {
        if (this.m_menus == null || this.m_menus.length == 0) {
            return;
        }
        if (this.m_scoutPropertyChangeListener == null) {
            return;
        }
        IMenu[] iMenuArray = this.m_menus;
        int n = this.m_menus.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu menu = iMenuArray[n2];
            menu.removePropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyChangeListener);
            ++n2;
        }
        this.m_scoutPropertyChangeListener = null;
    }

    private void initLayout(Composite composite) {
        GridLayout gridLayout = RwtLayoutUtility.createGridLayoutNoSpacing((int)1, (boolean)true);
        composite.setLayout((Layout)gridLayout);
    }

    private void rebuildButtonBar() {
        if (this.m_buttonBar != null) {
            this.m_buttonBar.dispose();
        }
        this.createButtonBar();
        this.getParent().layout(true, true);
    }

    private void createButtonBar() {
        this.m_buttonBar = this.createButtonBar(this, this.m_displayedMenus);
    }

    private Composite createButtonBar(Composite parent, List<IMenu> actions) {
        Composite buttonBar = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        buttonBar.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_ACTION_BAR);
        this.initButtonBarLayout(buttonBar);
        this.createButtons(buttonBar, actions);
        return buttonBar;
    }

    public int getActionsOrientation() {
        if ((this.m_style & 0x4000000) != 0) {
            return 0x4000000;
        }
        return 0x2000000;
    }

    private void initButtonBarLayout(Composite buttonBar) {
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.spacing = 6;
        layout.wrap = false;
        buttonBar.setLayout((Layout)layout);
        int horizontalAlignment = this.getHorizontalAlignment();
        buttonBar.setLayoutData((Object)new GridData(horizontalAlignment, 0x1000000, true, true));
    }

    private int getHorizontalAlignment() {
        if ((this.m_style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.m_style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.m_style & 0x20000) != 0) {
            return 131072;
        }
        return -1;
    }

    private void createButtons(Composite buttonBar, List<IMenu> actions) {
        if (actions.size() == 0 || !this.isAnyActionVisible(actions)) {
            return;
        }
        if (this.getActionsOrientation() == 0x4000000) {
            actions = this.reverseActions(actions);
        }
        for (IMenu menu : actions) {
            if (!menu.isVisible()) continue;
            this.createButton(buttonBar, (IAction)menu);
        }
    }

    private List<IMenu> reverseActions(List<IMenu> actions) {
        LinkedList<IMenu> reversedMenuList = new LinkedList<IMenu>(actions);
        Collections.reverse(reversedMenuList);
        return reversedMenuList;
    }

    protected void createButton(Composite parent, IAction action) {
        if (action == null) {
            return;
        }
        if (action.isSeparator()) {
            return;
        }
        if (!action.isVisible()) {
            return;
        }
        if (RwtMenuUtility.hasChildActions((IAction)action) && !RwtMenuUtility.hasVisibleChildActions((IAction)action)) {
            return;
        }
        RwtScoutActionButton button = new RwtScoutActionButton();
        button.setMenuOpeningDirection(this.getMenuOpeningDirection());
        button.createUiField(parent, (IPropertyObserver)action, this.getUiEnvironment());
    }

    protected int getMenuOpeningDirection() {
        if ((this.m_style & 0x80) != 0) {
            return 128;
        }
        return 1024;
    }

    public void handleButtonPiling() {
        if (this.isButtonBarTooSmall(this.m_buttonBar) || this.getNumberOfDisplayedButtons() > this.m_maxNumberOfAlwaysVisibleButtons) {
            this.pileButtons();
        } else {
            this.breakPileButtonsApart();
        }
    }

    private void scheduleHandleButtonPilingInUiThread() {
        if (this.m_buttonBar == null || this.m_buttonBar.isDisposed()) {
            return;
        }
        this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ActionButtonBar.this.m_buttonBar == null || ActionButtonBar.this.m_buttonBar.isDisposed()) {
                    return;
                }
                ActionButtonBar.this.handleButtonPiling();
            }
        });
    }

    private void breakPileButtonsApart() {
        boolean brokeApart = false;
        while (brokeApart = this.breakPileButtonApart()) {
        }
    }

    private void pileButtons() {
        boolean stackingSuccessful = false;
        while ((stackingSuccessful = this.createPileButton()) && (this.isButtonBarTooSmall(this.m_buttonBar) || this.getNumberOfDisplayedButtons() > this.m_maxNumberOfAlwaysVisibleButtons)) {
        }
    }

    private boolean isButtonBarTooSmall(Composite buttonBar) {
        Rectangle actualSize = buttonBar.getBounds();
        Point preferredSize = buttonBar.computeSize(-1, actualSize.height, false);
        return actualSize.width < preferredSize.x;
    }

    protected boolean breakPileButtonApart() {
        if (this.m_displayedMenus == null || this.m_displayedMenus.size() == 0) {
            return false;
        }
        if (this.getNumberOfDisplayedButtons() >= this.m_maxNumberOfAlwaysVisibleButtons) {
            return false;
        }
        LinkedList<IMenu> displayedMenusCopy = new LinkedList<IMenu>();
        displayedMenusCopy.addAll(this.m_displayedMenus);
        IMenu lastDisplayedMenu = (IMenu)displayedMenusCopy.remove(displayedMenusCopy.size() - 1);
        if (!(lastDisplayedMenu instanceof PileMenu)) {
            return false;
        }
        PileMenu pileMenu = (PileMenu)lastDisplayedMenu;
        List currentPileMenus = pileMenu.getChildActions();
        IMenu firstMenu = (IMenu)currentPileMenus.remove(0);
        displayedMenusCopy.add(firstMenu);
        if (currentPileMenus.size() > 0) {
            PileMenu newPileMenu = this.createPileMenu(currentPileMenus);
            displayedMenusCopy.add((IMenu)newPileMenu);
        }
        if (this.isEnoughSpaceToBreakApart(displayedMenusCopy)) {
            this.m_displayedMenus = displayedMenusCopy;
            this.rebuildButtonBar();
            return true;
        }
        return false;
    }

    private boolean isEnoughSpaceToBreakApart(List<IMenu> menusToDisplay) {
        Shell shell = new Shell();
        try {
            shell.setSize(this.getBounds().width, this.getBounds().height);
            this.initLayout((Composite)shell);
            Composite buttonBar = this.createButtonBar((Composite)shell, menusToDisplay);
            shell.layout();
            boolean bl = !this.isButtonBarTooSmall(buttonBar);
            return bl;
        }
        finally {
            shell.dispose();
        }
    }

    private PileMenu createPileMenu(final List<IMenu> childActions) {
        final Holder result = new Holder();
        ClientSyncJob job = new ClientSyncJob("PileMenu", this.getUiEnvironment().getClientSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                PileMenu pileMenu = new PileMenu();
                pileMenu.setChildActions(childActions);
                if (ActionButtonBar.this.getMenuOpeningDirection() == 128) {
                    pileMenu.setIconId("mobile_more_actions_up");
                } else {
                    pileMenu.setIconId("mobile_more_actions_down");
                }
                result.setValue((Object)pileMenu);
            }
        };
        job.schedule();
        try {
            job.join(2345L);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the PileMenu model to be created.", (Throwable)e);
        }
        return (PileMenu)((Object)result.getValue());
    }

    protected boolean createPileButton() {
        if (!this.isPilingAllowed()) {
            return false;
        }
        LinkedList<IMenu> newPiledActions = new LinkedList<IMenu>();
        IMenu lastMenu = this.m_displayedMenus.remove(this.m_displayedMenus.size() - 1);
        if (lastMenu instanceof PileMenu) {
            if (this.m_displayedMenus.size() > this.getMinNumberOfAlwaysVisibleButtons()) {
                IMenu secondLastMenu = this.m_displayedMenus.remove(this.m_displayedMenus.size() - 1);
                newPiledActions.add(secondLastMenu);
            }
            newPiledActions.addAll(lastMenu.getChildActions());
        } else {
            newPiledActions.add(lastMenu);
        }
        PileMenu pileMenu = this.createPileMenu(newPiledActions);
        this.m_displayedMenus.add((IMenu)pileMenu);
        this.rebuildButtonBar();
        return true;
    }

    private boolean isPilingAllowed() {
        if (!this.isPilingEnabled()) {
            return false;
        }
        if (this.m_displayedMenus.size() == 0) {
            return false;
        }
        return this.getNumberOfDisplayedButtons() > this.getMinNumberOfAlwaysVisibleButtons();
    }

    private int getNumberOfDisplayedButtons() {
        int size = 0;
        for (IAction iAction : this.m_displayedMenus) {
            if (iAction.isSeparator() || iAction instanceof PileMenu) continue;
            ++size;
        }
        return size;
    }

    public int getMinNumberOfAlwaysVisibleButtons() {
        return this.m_minNumberOfAlwaysVisibleButtons;
    }

    public void setMinNumberOfAlwaysVisibleButtons(int minNumberOfAlwaysVisibleButtons) {
        this.m_minNumberOfAlwaysVisibleButtons = minNumberOfAlwaysVisibleButtons;
    }

    public void setMaxNumberOfAlwaysVisibleButtons(int maxNumberOfAlwaysVisibleButtons) {
        this.m_maxNumberOfAlwaysVisibleButtons = maxNumberOfAlwaysVisibleButtons;
    }

    public int getMaxNumberOfAlwaysVisibleButtons() {
        return this.m_maxNumberOfAlwaysVisibleButtons;
    }

    public void setPilingEnabled(boolean pilingEnabled) {
        this.m_pilingEnabled = pilingEnabled;
    }

    public boolean isPilingEnabled() {
        return this.m_pilingEnabled;
    }

    public IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    public IMenu[] getMenus() {
        return this.m_menus;
    }

    public boolean hasButtons() {
        return this.getMenus() != null && this.getMenus().length > 0;
    }

    public boolean isEqualMenuList(List<IMenu> menuList) {
        if (this.getMenus() == null || menuList == null) {
            return false;
        }
        return menuList.equals(Arrays.asList(this.getMenus()));
    }

    public boolean isAnyActionVisible(List<IMenu> menuList) {
        if (menuList == null) {
            return false;
        }
        for (IMenu menu : menuList) {
            if (!menu.isVisible()) continue;
            return true;
        }
        return false;
    }

    private void setActionVisibleFromScout(IAction action, boolean visible) {
        this.rebuildButtonBar();
    }

    private void handleScoutPropertyChange(PropertyChangeEvent evt) {
        if ("visible".equals(evt.getPropertyName())) {
            IAction action = (IAction)evt.getSource();
            this.setActionVisibleFromScout(action, (Boolean)evt.getNewValue());
        }
    }

    private class P_ResizeListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_ResizeListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 11) {
                this.buttonBarResized();
            }
        }

        private void buttonBarResized() {
            if (ActionButtonBar.this.m_buttonBar == null || ActionButtonBar.this.m_buttonBar.isDisposed()) {
                return;
            }
            if (ActionButtonBar.this.m_handleButtonPilingJob != null) {
                ActionButtonBar.this.m_handleButtonPilingJob.cancel();
            }
            ActionButtonBar.this.m_handleButtonPilingJob = new Job("Handling button piling"){

                protected IStatus run(IProgressMonitor monitor) {
                    ActionButtonBar.this.scheduleHandleButtonPilingInUiThread();
                    return Status.OK_STATUS;
                }
            };
            ActionButtonBar.this.m_handleButtonPilingJob.setSystem(true);
            ActionButtonBar.this.m_handleButtonPilingJob.schedule(200L);
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (ActionButtonBar.this.isDisposed()) {
                        return;
                    }
                    ActionButtonBar.this.handleScoutPropertyChange(evt);
                }
            };
            ActionButtonBar.this.getUiEnvironment().invokeUiLater(t);
        }
    }

    private class PileMenu
    extends AbstractMenu {
        private PileMenu() {
        }
    }
}

