/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.AbstractPagingSupport;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.IMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.PagingTableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtScoutList;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class RwtPagingSupport
extends AbstractPagingSupport {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtPagingSupport.class);
    private RwtScoutList m_uiList;
    private P_TableRowSelectionFilter m_tableRowSelectionFilter;
    private P_SelectionListener m_selectionListener;
    private P_PropertyChangeListener m_propertyChangeListener;
    private boolean m_propertyLoadLock;

    public RwtPagingSupport(RwtScoutList uiList, IMobileTable table) {
        super(table);
        this.m_uiList = uiList;
        this.m_selectionListener = new P_SelectionListener();
        this.m_uiList.getUiField().addListener(4, this.m_selectionListener);
        this.m_tableRowSelectionFilter = new P_TableRowSelectionFilter();
        this.m_uiList.addTableRowSelectionFilter(this.m_tableRowSelectionFilter);
        this.m_propertyChangeListener = new P_PropertyChangeListener();
        table.addPropertyChangeListener((PropertyChangeListener)this.m_propertyChangeListener);
    }

    public void dispose() {
        this.m_uiList.removeTableRowSelectionFilter(this.m_tableRowSelectionFilter);
        this.m_uiList.getUiField().removeListener(4, this.m_selectionListener);
        this.getTable().removePropertyChangeListener((PropertyChangeListener)this.m_propertyChangeListener);
    }

    public boolean handleSelection(List<? extends ITableRow> rows) {
        for (ITableRow iTableRow : rows) {
            if (iTableRow == this.getPreviousElementsTableRow()) {
                this.setPageIndex(this.getPageIndex() - 1);
                this.setPageIndexFromUi(this.getPageIndex());
                this.refreshAfterPageChange();
                this.m_uiList.getUiField().setTopIndex(this.m_uiList.getUiField().getItemCount() - 1);
                return true;
            }
            if (iTableRow != this.getNextElementsTableRow()) continue;
            this.setPageIndex(this.getPageIndex() + 1);
            this.setPageIndexFromUi(this.getPageIndex());
            this.refreshAfterPageChange();
            this.m_uiList.getUiField().setTopIndex(0);
            return true;
        }
        return false;
    }

    protected void initProperties() {
        if (this.m_propertyLoadLock) {
            return;
        }
        super.initProperties();
    }

    protected ITableRow createNextElementsTableRow() {
        final Holder resultHolder = new Holder(ITableRow.class);
        JobEx job = this.m_uiList.getUiEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                resultHolder.setValue((Object)RwtPagingSupport.super.createNextElementsTableRow());
            }
        }, 0L);
        try {
            job.join(3000L);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to create NextPagingTableRow", (Throwable)e);
        }
        return (ITableRow)resultHolder.getValue();
    }

    protected ITableRow createPreviousElementsTableRow() {
        final Holder resultHolder = new Holder(ITableRow.class);
        JobEx job = this.m_uiList.getUiEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                resultHolder.setValue((Object)RwtPagingSupport.super.createPreviousElementsTableRow());
            }
        }, 0L);
        try {
            job.join(3000L);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to create PreviousPagingTableRow", (Throwable)e);
        }
        return (ITableRow)resultHolder.getValue();
    }

    private void refreshAfterPageChange() {
        this.m_propertyLoadLock = true;
        this.m_uiList.setPreventSelectionHandling(true);
        try {
            this.refresh();
            this.m_uiList.clearSelection();
            this.m_uiList.restoreSelection();
        }
        finally {
            this.m_propertyLoadLock = false;
            this.m_uiList.setPreventSelectionHandling(false);
        }
    }

    private void refresh() {
        this.m_uiList.getUiTableViewer().refresh();
    }

    private void setPageIndexFromUi(final int pageIndex) {
        this.m_uiList.getUiEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                RwtPagingSupport.this.getTable().getUIFacade().setPageIndexFromUi(pageIndex);
            }
        }, 0L);
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("pageIndex".equals(name)) {
            if (this.getPageIndex() != ((Integer)newValue).intValue()) {
                this.refresh();
            }
        } else if ("pageSize".equals(name) && this.getPageSize() != ((Integer)newValue).intValue()) {
            this.refresh();
        }
    }

    private class P_PropertyChangeListener
    implements PropertyChangeListener {
        private P_PropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            RwtPagingSupport.this.m_uiList.getUiEnvironment().invokeUiLater(new Runnable(){

                @Override
                public void run() {
                    RwtPagingSupport.this.handleScoutPropertyChange(evt.getPropertyName(), evt.getNewValue());
                }
            });
        }
    }

    private class P_SelectionListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_SelectionListener() {
        }

        public void handleEvent(Event event) {
            StructuredSelection selection;
            List selectedRows;
            if (event.type == 4 && RwtPagingSupport.this.handleSelection(selectedRows = RwtUtility.getItemsOfSelection(ITableRow.class, (StructuredSelection)(selection = (StructuredSelection)RwtPagingSupport.this.m_uiList.getUiTableViewer().getSelection())))) {
                event.doit = false;
            }
        }
    }

    private class P_TableRowSelectionFilter
    implements ITableRowFilter {
        private P_TableRowSelectionFilter() {
        }

        public boolean accept(ITableRow row) {
            return !(row instanceof PagingTableRow);
        }
    }
}

