/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.servicetunnel.http.IClientServiceTunnel;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.AbstractRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.Activator;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.IRwtStandaloneEnvironment;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.desktop.RwtScoutDesktop;
import org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar.RwtScoutFormButtonBar;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public abstract class AbstractStandaloneRwtEnvironment
extends AbstractRwtEnvironment
implements IRwtStandaloneEnvironment {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractStandaloneRwtEnvironment.class);
    private Display m_display;
    private RwtScoutDesktop m_uiDesktop;
    private RwtScoutFormButtonBar m_uiButtonArea;
    private ServerPushSession m_clientNotificationPushSession;

    public AbstractStandaloneRwtEnvironment(Bundle applicationBundle, Class<? extends IClientSession> clientSessionClazz) {
        super(applicationBundle, clientSessionClazz);
    }

    public int createUI() {
        if (this.getSubject() == null) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                throw new SecurityException("/rap request is not authenticated with a Subject");
            }
            this.setSubject(subject);
        }
        return super.createUI();
    }

    protected void createContents(Composite parent) {
        this.m_display = Display.getCurrent();
        this.m_display.setData(IRwtEnvironment.class.getName(), (Object)this);
        this.m_uiDesktop = this.createApplicationContent(parent);
        this.m_uiButtonArea = this.createNonmodalFormButtonArea(parent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)this.m_uiDesktop.getUiContainer());
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).exclude(true).applyTo((Control)this.m_uiButtonArea.getUiContainer());
        if (this.needsClientNotificationServerPushSession()) {
            this.m_clientNotificationPushSession = new ServerPushSession();
            this.m_clientNotificationPushSession.start();
        }
    }

    protected RwtScoutDesktop createApplicationContent(final Composite parent) {
        final RwtScoutDesktop uiDesktop = this.createUiDesktop();
        this.ensureInitialized(new Runnable(){

            @Override
            public void run() {
                uiDesktop.createUiField(parent, AbstractStandaloneRwtEnvironment.this.getScoutDesktop(), AbstractStandaloneRwtEnvironment.this);
            }
        });
        if (!this.isInitialized()) {
            throw new SecurityException("Cannot initialize application");
        }
        this.getKeyStrokeManager().setGlobalKeyStrokesActivated(true);
        return uiDesktop;
    }

    protected RwtScoutFormButtonBar createNonmodalFormButtonArea(Composite parent) {
        RwtScoutFormButtonBar buttonBar = new RwtScoutFormButtonBar();
        buttonBar.createUiField(parent, (IDesktop)this.m_uiDesktop.getScoutObject(), this);
        return buttonBar;
    }

    protected RwtScoutDesktop createUiDesktop() {
        return new RwtScoutDesktop();
    }

    protected boolean needsClientNotificationServerPushSession() {
        IClientServiceTunnel serviceTunnel = this.getClientSession().getServiceTunnel();
        if (serviceTunnel != null) {
            return serviceTunnel.getClientNotificationPollInterval() > -1L;
        }
        return false;
    }

    @Override
    public RwtScoutDesktop getUiDesktop() {
        return this.m_uiDesktop;
    }

    @Override
    public Display getDisplay() {
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null && this.m_display != currentDisplay) {
            LOG.error("WRONG DISPLAY: the calling user-interface thread does not belong to this environment [display_environment={0}, display_callingThread={1}, callingThread={2}]", new Object[]{this.m_display, currentDisplay, Thread.currentThread()});
        }
        return this.m_display;
    }

    @Override
    public void showFormPart(IForm form) {
        if (form == null) {
            return;
        }
        if (form.getDisplayHint() == 20) {
            IRwtScoutPart part = this.m_uiDesktop.addForm(form);
            if (part != null) {
                this.putPart(form, part);
                part.showPart();
            } else {
                LOG.error("Form '" + form.getFormId() + "' cannot be displayed because no corresponding UI part could be found.");
            }
        }
        super.showFormPart(form);
        if (form.getDisplayHint() == 0 && !form.isModal()) {
            int buttonCount = this.m_uiButtonArea.getFormButtonBarCount();
            this.m_uiButtonArea.addFormButton(form);
            if (buttonCount != this.m_uiButtonArea.getFormButtonBarCount()) {
                this.m_uiButtonArea.getUiContainer().setVisible(true);
                ((GridData)this.m_uiButtonArea.getUiContainer().getLayoutData()).exclude = false;
                this.m_uiButtonArea.getUiContainer().getParent().layout(true, true);
            }
        }
    }

    @Override
    public void hideFormPart(IForm form) {
        super.hideFormPart(form);
        if (form.getDisplayHint() == 0 && !form.isModal()) {
            this.m_uiButtonArea.removeFormButton(form);
            if (this.m_uiButtonArea.getFormButtonBarCount() == 0) {
                this.m_uiButtonArea.getUiContainer().setVisible(false);
                ((GridData)this.m_uiButtonArea.getUiContainer().getLayoutData()).exclude = true;
                this.m_uiButtonArea.getUiContainer().getParent().layout(true, true);
            }
        }
    }

    @Override
    public Shell getParentShellIgnoringPopups(int modalities) {
        Display display = this.getDisplay();
        Shell shell = display.getActiveShell();
        if (shell != null) {
            while (RwtUtility.isPopupShell(shell) && shell.getParent() instanceof Shell) {
                shell = (Shell)shell.getParent();
            }
        }
        if (shell == null) {
            TreeMap<CompositeLong, Shell> map = new TreeMap<CompositeLong, Shell>();
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell s = shellArray[n2];
                RwtUtility.visitShellTreeRec(s, modalities, 0, map);
                ++n2;
            }
            if (map.size() > 0) {
                shell = (Shell)map.get(map.firstKey());
            }
        }
        if (shell != null && shell.getData() instanceof ProgressMonitorDialog) {
            shell = (Shell)shell.getParent();
        }
        if (shell == null) {
            shell = this.getShell();
        }
        return shell;
    }

    @Override
    protected void contributePatches(List<URL> patches) {
        super.contributePatches(patches);
        this.contributeEditableCellMarkerPatch(patches);
    }

    protected void contributeEditableCellMarkerPatch(List<URL> patches) {
        this.registerEditableCellMarkerIcon();
        Bundle rwtBundle = Platform.getBundle((String)"org.eclipse.rap.rwt");
        if (rwtBundle != null && rwtBundle.getVersion().getMajor() >= 3) {
            patches.add(Activator.class.getResource("/resources/patches/EditableCellMarkerPatch_v3.x.x.js"));
        } else {
            patches.add(Activator.class.getResource("/resources/patches/EditableCellMarkerPatch_v2.x.x.js"));
        }
    }

    protected void registerEditableCellMarkerIcon() {
        String icon = "editable_tablecell_marker.png";
        if (!RWT.getResourceManager().isRegistered(icon)) {
            InputStream is = Activator.class.getResourceAsStream(String.format("/resources/icons/internal/%s", icon));
            try {
                RWT.getResourceManager().register(icon, is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close InputStream for editable cell marker.", (Throwable)e);
                }
            }
        }
    }
}

