/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.action.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.action.menu.IRwtContextMenuMarker;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RwtContextMenuMarkerComposite
extends Composite
implements IRwtContextMenuMarker {
    private static final long serialVersionUID = 1L;
    private Label m_dropdownControl;
    private List<SelectionListener> m_selectionListeners;
    private IRwtEnvironment m_environment;
    private int m_markerLabelTopMargin = 0;
    private int m_markerLabelLeftMargin = 0;
    private int m_markerLabelRightMargin = 0;
    private int m_markerLabelBottomMargin = 0;

    public RwtContextMenuMarkerComposite(Composite parent, IRwtEnvironment environment) {
        this(parent, environment, 526336);
    }

    public RwtContextMenuMarkerComposite(Composite parent, IRwtEnvironment environment, int style) {
        super(parent, style | 0x80000);
        this.m_environment = environment;
        this.m_selectionListeners = new ArrayList<SelectionListener>();
        this.setLayout(new MarkerCompositeLayout());
        this.m_dropdownControl = environment.getFormToolkit().createLabel(this, "", style);
        this.m_dropdownControl.setData("org.eclipse.rap.rwt.customVariant", (Object)"menuDropDown");
        this.m_dropdownControl.setSize(new Point(7, 20));
        this.m_dropdownControl.setVisible(false);
        this.m_dropdownControl.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 1L;

            public void mouseUp(MouseEvent e) {
                Rectangle markerLabelBounds = RwtContextMenuMarkerComposite.this.m_dropdownControl.getBounds();
                if (RwtContextMenuMarkerComposite.this.isMarkerVisible() && e.x >= 0 && e.x <= markerLabelBounds.width && e.y >= 0 && e.y <= markerLabelBounds.height) {
                    RwtContextMenuMarkerComposite.this.handleDropDownSelection(e);
                }
            }
        });
        this.setData("org.eclipse.rap.rwt.customVariant", "contextMenuMarker");
    }

    public IRwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public Label getMarkerLabel() {
        return this.m_dropdownControl;
    }

    @Override
    public void setMarkerVisible(boolean visible) {
        this.m_dropdownControl.setVisible(visible);
        this.layout(true);
    }

    @Override
    public boolean isMarkerVisible() {
        return this.m_dropdownControl.getVisible();
    }

    public int getMarkerLabelTopMargin() {
        return this.m_markerLabelTopMargin;
    }

    public void setMarkerLabelTopMargin(int markerLabelTopMargin) {
        this.m_markerLabelTopMargin = markerLabelTopMargin;
    }

    public int getMarkerLabelLeftMargin() {
        return this.m_markerLabelLeftMargin;
    }

    public void setMarkerLabelLeftMargin(int markerLabelLeftMargin) {
        this.m_markerLabelLeftMargin = markerLabelLeftMargin;
    }

    public int getMarkerLabelRightMargin() {
        return this.m_markerLabelRightMargin;
    }

    public void setMarkerLabelRightMargin(int markerLabelRightMargin) {
        this.m_markerLabelRightMargin = markerLabelRightMargin;
    }

    public int getMarkerLabelBottomMargin() {
        return this.m_markerLabelBottomMargin;
    }

    public void setMarkerLabelBottomMargin(int markerLabelBottomMargin) {
        this.m_markerLabelBottomMargin = markerLabelBottomMargin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectionListener(SelectionListener listener) {
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            this.m_selectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSelectionListener(SelectionListener listener) {
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            return this.m_selectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDropDownSelection(MouseEvent e) {
        ArrayList listeners = null;
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            listeners = CollectionUtility.arrayList(this.m_selectionListeners);
        }
        Event event = new Event();
        event.button = e.button;
        event.count = e.count;
        event.data = e.data;
        event.doit = true;
        event.display = e.display;
        event.stateMask = e.stateMask;
        event.time = e.time;
        event.widget = e.widget;
        event.x = e.x;
        event.y = e.y;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener l : listeners) {
            l.widgetSelected(selectionEvent);
            if (!selectionEvent.doit) break;
        }
    }

    private class MarkerCompositeLayout
    extends Layout {
        private static final long serialVersionUID = 1L;

        private MarkerCompositeLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (children.length != 2) {
                throw new IllegalArgumentException("Marker composite only allows exacly one child control!");
            }
            int width = 0;
            int height = 0;
            if (RwtContextMenuMarkerComposite.this.isMarkerVisible()) {
                Point markerSize = RwtContextMenuMarkerComposite.this.m_dropdownControl.getSize();
                height = RwtContextMenuMarkerComposite.this.getMarkerLabelTopMargin() + RwtContextMenuMarkerComposite.this.getMarkerLabelBottomMargin() + markerSize.y;
                width = RwtContextMenuMarkerComposite.this.getMarkerLabelLeftMargin() + RwtContextMenuMarkerComposite.this.getMarkerLabelRightMargin() + markerSize.x;
            }
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c != RwtContextMenuMarkerComposite.this.m_dropdownControl) {
                    if (wHint == -1) {
                        Point computedSize = c.computeSize(wHint, hHint);
                        width += computedSize.x;
                        height = Math.max(height, computedSize.y);
                        break;
                    }
                    if (hHint != -1) break;
                    Point computedSize = c.computeSize(Math.max(-1, wHint - width), hHint);
                    width += computedSize.x;
                    height = Math.max(height, computedSize.y);
                    break;
                }
                ++n2;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (children.length != 2) {
                throw new IllegalArgumentException("Marker composite only allows exacly one child control!");
            }
            Rectangle clientArea = composite.getClientArea();
            Rectangle controlBounds = new Rectangle(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            if (RwtContextMenuMarkerComposite.this.isMarkerVisible()) {
                Point markerSize = RwtContextMenuMarkerComposite.this.m_dropdownControl.getSize();
                controlBounds.width = controlBounds.width - markerSize.x - RwtContextMenuMarkerComposite.this.getMarkerLabelLeftMargin() - RwtContextMenuMarkerComposite.this.getMarkerLabelRightMargin();
                Rectangle markerIconBounds = new Rectangle(clientArea.width - markerSize.x - RwtContextMenuMarkerComposite.this.getMarkerLabelRightMargin(), RwtContextMenuMarkerComposite.this.getMarkerLabelTopMargin(), markerSize.x, markerSize.y);
                RwtContextMenuMarkerComposite.this.m_dropdownControl.setBounds(markerIconBounds);
            }
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c != RwtContextMenuMarkerComposite.this.m_dropdownControl) {
                    c.setBounds(controlBounds);
                    break;
                }
                ++n2;
            }
        }
    }
}

