/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext.browser;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.ext.browser.IHyperlinkCallback;
import org.eclipse.scout.rt.ui.rap.ext.table.TableViewerEx;
import org.eclipse.scout.rt.ui.rap.html.HtmlAdapter;
import org.eclipse.scout.rt.ui.rap.html.IHyperlinkProcessor;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class BrowserExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BrowserExtension.class);
    public static final String HYPERLINK_FUNCTION_NAME = "scoutActivateUrl";
    public static final String HYPERLINK_FUNCTION_RETURN_TYPE = "void";
    private final Browser m_browser;
    private final HashMap<String, String> m_hyperlinkMap;
    private BrowserFunction m_hyperlinkBrowserFunction;
    private IHyperlinkCallback m_hyperlinkCallback;
    private String m_resourceFolderId;
    private IRwtEnvironment m_uiEnvironment;
    private HyperlinkProcessor m_hyperlinkProcessor;
    private HashSet<String> m_tempFileNames;

    public BrowserExtension(Browser b, IRwtEnvironment uiEnvironment, IHyperlinkCallback hyperlinkCallback) {
        this.m_browser = b;
        this.m_hyperlinkCallback = hyperlinkCallback;
        this.m_hyperlinkMap = new HashMap();
        this.m_resourceFolderId = UUID.randomUUID().toString();
        this.m_uiEnvironment = uiEnvironment;
        this.m_tempFileNames = new HashSet();
        this.m_hyperlinkProcessor = this.createHyperlinkProcessor();
        this.m_hyperlinkProcessor.setGeneratedMappings(this.m_hyperlinkMap);
        this.m_hyperlinkProcessor.setHyperlinkFunctionName(this.getHyperlinkFunctionName());
        this.m_hyperlinkProcessor.setHyperlinkFunctionReturnType(this.getHyperlinkFunctionReturnType());
    }

    public void attach() {
        if (this.m_hyperlinkBrowserFunction == null) {
            this.m_hyperlinkBrowserFunction = this.createLocalHyperlinkFunction();
        }
    }

    private BrowserFunction createLocalHyperlinkFunction() {
        return new BrowserFunction(this.m_browser, this.getHyperlinkFunctionName()){

            public Object function(Object[] arguments) {
                this.storeValueOfCurrentlyFocusedFieldIntoScoutModel();
                String localUrl = (String)BrowserExtension.this.m_hyperlinkMap.get(arguments[0]);
                if (localUrl == null) {
                    LOG.error("Hyperlink could not be activated. No url specified.");
                    return null;
                }
                if (BrowserExtension.this.m_hyperlinkCallback == null) {
                    LOG.error("Hyperlink could not be activated. Please specify the runnable to be executed.");
                    return null;
                }
                BrowserExtension.this.m_hyperlinkCallback.execute(localUrl);
                return null;
            }

            private void storeValueOfCurrentlyFocusedFieldIntoScoutModel() {
                RwtScoutTable table;
                TableViewerEx ex;
                Control currentlyFocusedControl = Display.getCurrent().getFocusControl();
                RwtUtility.runUiInputVerifier(currentlyFocusedControl);
                if (this.isCellEditor(currentlyFocusedControl) && (ex = (TableViewerEx)(table = this.findTableForControl(currentlyFocusedControl)).getUiTableViewer()).isCellEditorActive()) {
                    ex.applyEditorValue();
                }
            }

            private boolean isCellEditor(Control c) {
                return this.findTableForControl(c) != null;
            }

            private RwtScoutTable findTableForControl(Control originalControl) {
                Control currentControl = originalControl;
                while (currentControl != null) {
                    IRwtScoutComposite rwtComposite = RwtScoutComposite.getCompositeOnWidget((Widget)currentControl);
                    if (rwtComposite != null && rwtComposite instanceof RwtScoutTable) {
                        return (RwtScoutTable)rwtComposite;
                    }
                    currentControl = currentControl.getParent();
                }
                return null;
            }
        };
    }

    public void detach() {
        if (this.m_hyperlinkBrowserFunction != null) {
            this.m_hyperlinkBrowserFunction.dispose();
            this.m_hyperlinkBrowserFunction = null;
        }
        this.clearLocalHyperlinkCache();
        this.clearResourceCache();
    }

    public String addResource(String name, InputStream content) {
        if ((name = name.replaceAll("\\\\", "/")) == null || name.length() == 0) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        String uniqueName = String.valueOf(this.m_resourceFolderId) + name;
        this.m_tempFileNames.add(uniqueName);
        ResourceManager resourceManager = RWT.getResourceManager();
        resourceManager.register(uniqueName, content);
        return resourceManager.getLocation(uniqueName);
    }

    public void clearResourceCache() {
        ResourceManager resourceManager = RWT.getResourceManager();
        try {
            for (String name : this.m_tempFileNames) {
                resourceManager.unregister(name);
            }
        }
        finally {
            this.m_tempFileNames.clear();
        }
    }

    public String adaptHyperlinks(String html) {
        HtmlAdapter htmlAdapter = this.getUiEnvironment().getHtmlAdapter();
        if (htmlAdapter == null) {
            return html;
        }
        return htmlAdapter.processHyperlinks(html, this.m_hyperlinkProcessor);
    }

    protected HyperlinkProcessor createHyperlinkProcessor() {
        return new HyperlinkProcessor();
    }

    public void clearLocalHyperlinkCache() {
        this.m_hyperlinkMap.clear();
    }

    protected String getHyperlinkFunctionName() {
        return HYPERLINK_FUNCTION_NAME;
    }

    protected String getHyperlinkFunctionReturnType() {
        return HYPERLINK_FUNCTION_RETURN_TYPE;
    }

    public IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    public String getDefaultHyperlinkTarget() {
        return this.m_hyperlinkProcessor.getDefaultTarget();
    }

    public void setDefaultHyperlinkTarget(String defaultTarget) {
        this.m_hyperlinkProcessor.setDefaultTarget(defaultTarget);
    }

    public boolean isConvertExternalUrlsEnabled() {
        return this.m_hyperlinkProcessor.isConvertExternalUrlsEnabled();
    }

    public void setConvertExternalUrlsEnabled(boolean convertExternalUrls) {
        this.m_hyperlinkProcessor.setConvertExternalUrlsEnabled(convertExternalUrls);
    }

    public static class HyperlinkProcessor
    implements IHyperlinkProcessor {
        private Map<String, String> m_generatedMappings;
        private String m_hyperlinkFunctionName;
        private String m_hyperlinkFunctionReturnType;
        private String m_defaultTarget;
        private boolean m_convertExternalUrlsEnabled;

        public Map<String, String> getGeneratedMappings() {
            return this.m_generatedMappings;
        }

        public void setGeneratedMappings(Map<String, String> generatedMappings) {
            this.m_generatedMappings = generatedMappings;
        }

        public String getHyperlinkFunctionName() {
            return this.m_hyperlinkFunctionName;
        }

        public void setHyperlinkFunctionName(String hyperlinkFunctionName) {
            this.m_hyperlinkFunctionName = hyperlinkFunctionName;
        }

        public String getHyperlinkFunctionReturnType() {
            return this.m_hyperlinkFunctionReturnType;
        }

        public void setHyperlinkFunctionReturnType(String hyperlinkFunctionReturnType) {
            this.m_hyperlinkFunctionReturnType = hyperlinkFunctionReturnType;
        }

        public String getDefaultTarget() {
            return this.m_defaultTarget;
        }

        public void setDefaultTarget(String defaultTarget) {
            this.m_defaultTarget = defaultTarget;
        }

        public boolean isConvertExternalUrlsEnabled() {
            return this.m_convertExternalUrlsEnabled;
        }

        public void setConvertExternalUrlsEnabled(boolean convertExternalUrls) {
            this.m_convertExternalUrlsEnabled = convertExternalUrls;
        }

        @Override
        public String processUrl(String url, boolean local) {
            if (url == null) {
                return null;
            }
            if (!local && !this.isConvertExternalUrlsEnabled()) {
                return url;
            }
            String externalKey = "" + this.m_generatedMappings.size();
            String callableURL = "javascript:" + (StringUtility.hasText((CharSequence)this.m_hyperlinkFunctionReturnType) ? String.valueOf(this.m_hyperlinkFunctionReturnType) + " " : "") + this.m_hyperlinkFunctionName + "('" + externalKey + "');";
            this.m_generatedMappings.put(externalKey, url);
            return callableURL;
        }

        @Override
        public String processTarget(String target, boolean local) {
            if (local || !StringUtility.isNullOrEmpty((CharSequence)target)) {
                return target;
            }
            return this.getDefaultTarget();
        }
    }
}

