/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext.table;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableEx
extends Table {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableEx.class);

    public TableEx(Composite parent, int style) {
        super(parent, style);
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point size = super.computeSize(hint, hint2, changed);
        TableColumn[] columns = this.getColumns();
        if (columns != null) {
            int x = 0;
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                x += col.getWidth();
                ++n2;
            }
            size.x = x += columns.length * this.getGridLineWidth();
        }
        return size;
    }

    public Point getPreferredContentSize(int maxRowCount) {
        Point max = new Point(0, 0);
        int r = 0;
        int nr = this.getItemCount();
        while (r < nr && r < maxRowCount) {
            int w = 0;
            int h = 0;
            TableItem item = this.getItem(r);
            int c = 0;
            int nc = this.getColumnCount();
            while (c < nc) {
                Rectangle d = item.getBounds(c);
                String text = item.getText();
                if (!StringUtility.hasText((CharSequence)text) && item.getData() instanceof ITableRow) {
                    text = ((ITableRow)item.getData()).getCell(c).getText();
                }
                if (StringUtility.hasText((CharSequence)text)) {
                    int textWidth;
                    d.width = textWidth = TextSizeUtil.stringExtent((Font)item.getFont(), (String)text).x;
                }
                w += d.width;
                h = Math.max(h, d.height);
                ++c;
            }
            h = Math.max(h, item.getBounds().height);
            max.y = nr > 3 ? (max.y += h + 1) : (nr > 1 ? (max.y += h + 2) : (max.y += h + 4));
            max.x = Math.max(max.x, w);
            ++r;
        }
        return max;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setForeground(null);
        } else {
            this.setForeground(this.getDisplay().getSystemColor(15));
        }
    }
}

