/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.ui.rap.extension.ILookAndFeelDecorations;
import org.eclipse.scout.rt.ui.rap.extension.ILookAndFeelProperties;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.internal.LookAndFeelDecorations;
import org.eclipse.scout.rt.ui.rap.extension.internal.LookAndFeelProperties;
import org.eclipse.scout.rt.ui.rap.extension.internal.UiDecoration;
import org.eclipse.scout.rt.ui.rap.util.DeviceUtility;

public final class UiDecorationExtensionPoint {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UiDecorationExtensionPoint.class);
    private static Map<IUiDeviceType, IUiDecoration> LOOK_AND_FEEL_MAP = new HashMap<IUiDeviceType, IUiDecoration>();
    public static final int SCOPE_DEFAULT = 1;
    public static final int SCOPE_GLOBAL = 100;
    private static final String ATTR_SCOPE = "scope";
    private static final String ATTR_DEVICE_TYPE = "deviceType";
    private static final String ATTR_DEVICE_TYPE_KEYWORD_TOUCH = "touch";

    private UiDecorationExtensionPoint() {
    }

    public static synchronized IUiDecoration getLookAndFeel() {
        IUiDeviceType currentDeviceType = DeviceUtility.getCurrentDeviceType();
        if (!LOOK_AND_FEEL_MAP.containsKey(currentDeviceType)) {
            IUiDecoration uiDecoration = UiDecorationExtensionPoint.loadUiDecoration(currentDeviceType);
            LOOK_AND_FEEL_MAP.put(currentDeviceType, uiDecoration);
        }
        return LOOK_AND_FEEL_MAP.get(currentDeviceType);
    }

    private static ILookAndFeelDecorations parseDecorations(IConfigurationElement decorationsElement) {
        LookAndFeelDecorations decorations = new LookAndFeelDecorations();
        decorations.setScope(UiDecorationExtensionPoint.getScopePriority(decorationsElement.getAttribute(ATTR_SCOPE)));
        decorations.setDeviceTypeIdentifier(decorationsElement.getAttribute(ATTR_DEVICE_TYPE));
        IConfigurationElement[] mandatoryElement = decorationsElement.getChildren("mandatory");
        if (mandatoryElement.length > 0) {
            IConfigurationElement[] starMarker;
            IConfigurationElement[] labelFont;
            IConfigurationElement[] labelTextColor;
            IConfigurationElement[] fieldBackground = mandatoryElement[0].getChildren("fieldBackground");
            if (fieldBackground.length > 0) {
                decorations.setMandatoryFieldBackgroundColor(fieldBackground[0].getAttribute("color"));
            }
            if ((labelTextColor = mandatoryElement[0].getChildren("labelTextColor")).length > 0) {
                decorations.setMandatoryLabelTextColor(labelTextColor[0].getAttribute("color"));
            }
            if ((labelFont = mandatoryElement[0].getChildren("labelFont")).length > 0) {
                FontSpec spec = FontSpec.parse((String)labelFont[0].getAttribute("font"));
                decorations.setMandatoryLabelFont(spec);
            }
            if ((starMarker = mandatoryElement[0].getChildren("starMarker")).length > 0) {
                decorations.setStarMarkerPosition(UiDecorationExtensionPoint.parseStarMarkerPosition(starMarker[0].getAttribute("placement")));
            }
        }
        return decorations;
    }

    private static ILookAndFeelProperties parseProperties(IConfigurationElement propertiesElement) {
        IConfigurationElement[] properties;
        LookAndFeelProperties props = new LookAndFeelProperties();
        props.setScope(UiDecorationExtensionPoint.getScopePriority(propertiesElement.getAttribute(ATTR_SCOPE)));
        props.setDeviceTypeIdentifier(propertiesElement.getAttribute(ATTR_DEVICE_TYPE));
        IConfigurationElement[] iConfigurationElementArray = properties = propertiesElement.getChildren("property");
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prop = iConfigurationElementArray[n2];
            String propName = null;
            String propValue = null;
            propName = prop.getAttribute("name");
            propValue = prop.getAttribute("value");
            props.setProperty(propName, propValue);
            props.setContributor(propertiesElement.getContributor().getName());
            ++n2;
        }
        return props;
    }

    private static int getScopePriority(String scope) {
        int prio = 1;
        if (StringUtility.isNullOrEmpty((CharSequence)scope) || "default".equalsIgnoreCase(scope)) {
            prio = 1;
        } else if ("global".equalsIgnoreCase(scope)) {
            prio = 100;
        }
        return prio;
    }

    private static int parseStarMarkerPosition(String value) {
        int pos = 0;
        if (StringUtility.isNullOrEmpty((CharSequence)value) || "afterLabel".equalsIgnoreCase(value)) {
            pos = 2;
        } else if ("beforeLabel".equalsIgnoreCase(value)) {
            pos = 1;
        }
        return pos;
    }

    private static IUiDecoration loadUiDecoration(IUiDeviceType deviceType) {
        IExtension[] extensions;
        ArrayList<ILookAndFeelProperties> propertyExtensions = new ArrayList<ILookAndFeelProperties>();
        ArrayList<ILookAndFeelDecorations> decorationExtensions = new ArrayList<ILookAndFeelDecorations>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.rt.ui.rap", "lookAndFeel");
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("properties".equals(element.getName())) {
                    propertyExtensions.add(UiDecorationExtensionPoint.parseProperties(element));
                } else if ("decorations".equals(element.getName())) {
                    decorationExtensions.add(UiDecorationExtensionPoint.parseDecorations(element));
                }
                ++n4;
            }
            ++n2;
        }
        UiDecoration uiDecoration = new UiDecoration();
        UiDecorationExtensionPoint.loadDecorations(uiDecoration, decorationExtensions, deviceType);
        UiDecorationExtensionPoint.loadProperties(uiDecoration, propertyExtensions, deviceType);
        return uiDecoration;
    }

    private static void loadProperties(UiDecoration uiDecoration, ArrayList<ILookAndFeelProperties> propertyExtensions, IUiDeviceType deviceType) {
        TreeMap<Integer, ILookAndFeelProperties> properties = new TreeMap<Integer, ILookAndFeelProperties>();
        for (ILookAndFeelProperties props : propertyExtensions) {
            String deviceTypeIdentifier;
            int scope = props.getScope();
            int priority = UiDecorationExtensionPoint.computePriority(scope, deviceTypeIdentifier = props.getDeviceTypeIdentifier());
            if (UiDecorationExtensionPoint.isPropsAlreadLoaded(properties, priority, deviceTypeIdentifier)) {
                LOG.warn("Multiple look and feel properties found with scope '" + scope + "' and deviceType '" + deviceTypeIdentifier + "'");
                continue;
            }
            if (!UiDecorationExtensionPoint.matchesDeviceType(deviceType, deviceTypeIdentifier)) continue;
            properties.put(priority, props);
        }
        for (ILookAndFeelProperties props : properties.values()) {
            if (props.getPropertyInt("dialog.minHeight") != 0) {
                uiDecoration.setDialogMinHeight(props.getPropertyInt("dialog.minHeight"));
            }
            if (props.getPropertyInt("dialog.minWidth") != 0) {
                uiDecoration.setDialogMinWidth(props.getPropertyInt("dialog.minWidth"));
            }
            if (props.existsProperty("formMainBoxBorder.visible")) {
                uiDecoration.setFormMainBoxBorderVisible(props.getPropertyBool("formMainBoxBorder.visible"));
            }
            if (props.getPropertyInt("formFieldLabel.width") != 0) {
                uiDecoration.setFormFieldLabelWidth(props.getPropertyInt("formFieldLabel.width"));
            }
            if (props.getPropertyString("formFieldLabel.alignment") != null) {
                String extFormFieldAlignment = props.getPropertyString("formFieldLabel.alignment");
                if ("center".equalsIgnoreCase(extFormFieldAlignment)) {
                    uiDecoration.setFormFieldLabelAlignment(0x1000000);
                } else if ("left".equalsIgnoreCase(extFormFieldAlignment)) {
                    uiDecoration.setFormFieldLabelAlignment(16384);
                } else if ("right".equalsIgnoreCase(extFormFieldAlignment)) {
                    uiDecoration.setFormFieldLabelAlignment(131072);
                } else {
                    LOG.warn("the value '" + extFormFieldAlignment + "' is not valid for the property '" + "formFieldLabel.alignment" + "'. Expected values are[right,left,center]");
                }
            }
            if (props.getPropertyInt("logicalGridLayout.defaultColumnWidth") != 0) {
                uiDecoration.setLogicalGridLayoutDefaultColumnWidth(props.getPropertyInt("logicalGridLayout.defaultColumnWidth"));
            }
            if (props.getPropertyInt("logicalGridLayout.defaultPopupWidth") != 0) {
                uiDecoration.setLogicalGridLayoutDefaultPopupWidth(props.getPropertyInt("logicalGridLayout.defaultPopupWidth"));
            }
            if (props.getPropertyInt("logicalGridLayout.horizontalGap") != 0) {
                uiDecoration.setLogicalGridLayoutHorizontalGap(props.getPropertyInt("logicalGridLayout.horizontalGap"));
            }
            if (props.getPropertyInt("logicalGridLayout.rowHeight") != 0) {
                uiDecoration.setLogicalGridLayoutRowHeight(props.getPropertyInt("logicalGridLayout.rowHeight"));
            }
            if (props.getPropertyInt("logicalGridLayout.verticalGap") != 0) {
                uiDecoration.setLogicalGridLayoutVerticalGap(props.getPropertyInt("logicalGridLayout.verticalGap"));
            }
            if (props.getPropertyInt("processButton.height") != 0) {
                uiDecoration.setProcessButtonHeight(props.getPropertyInt("processButton.height"));
            }
            if (props.getPropertyInt("processButton.maxWidth") != 0) {
                uiDecoration.setProcessButtonMaxWidth(props.getPropertyInt("processButton.maxWidth"));
            }
            if (props.getPropertyInt("processButton.minWidth") != 0) {
                uiDecoration.setProcessButtonMinWidth(props.getPropertyInt("processButton.minWidth"));
            }
            if (props.getPropertyString("color.foreground.disabled") != null) {
                uiDecoration.setColorForegroundDisabled(props.getPropertyString("color.foreground.disabled"));
            }
            if (props.getPropertyString("messageBox.minWidth") != null) {
                uiDecoration.setMessageBoxMinWidth(props.getPropertyInt("messageBox.minWidth"));
            }
            if (props.getPropertyString("messageBox.minHeight") != null) {
                uiDecoration.setMessageBoxMinHeight(props.getPropertyInt("messageBox.minHeight"));
            }
            if (props.getPropertyString("formfield.selectAllOnFocus.enabled") != null) {
                uiDecoration.setFormFieldSelectAllOnFocusEnabled(props.getPropertyBool("formfield.selectAllOnFocus.enabled"));
            }
            if (props.getPropertyString("dndSupport.enabled") != null) {
                uiDecoration.setDndSupportEnabled(props.getPropertyBool("dndSupport.enabled"));
            }
            if (props.getPropertyString("browserHistory.enabled") != null) {
                uiDecoration.setBrowserHistoryEnabled(props.getPropertyBool("browserHistory.enabled"));
            }
            if (props.getPropertyString("table.row.height") != null) {
                uiDecoration.setTableRowHeight(props.getPropertyInt("table.row.height"));
            }
            if (props.getPropertyString("tree.node.height") == null) continue;
            uiDecoration.setTreeNodeHeight(props.getPropertyInt("tree.node.height"));
        }
    }

    private static void loadDecorations(UiDecoration uiDecoration, ArrayList<ILookAndFeelDecorations> decorationExtensions, IUiDeviceType deviceType) {
        TreeMap<Integer, ILookAndFeelDecorations> decorations = new TreeMap<Integer, ILookAndFeelDecorations>();
        for (ILookAndFeelDecorations dec : decorationExtensions) {
            String deviceTypeIdentifier;
            int scope = dec.getScope();
            int priority = UiDecorationExtensionPoint.computePriority(scope, deviceTypeIdentifier = dec.getDeviceTypeIdentifier());
            if (UiDecorationExtensionPoint.isDecosAlreadLoaded(decorations, priority, deviceTypeIdentifier)) {
                LOG.warn("Multiple look and feel decorations found with scope '" + scope + "' and deviceType '" + deviceTypeIdentifier + "'.");
                continue;
            }
            if (!UiDecorationExtensionPoint.matchesDeviceType(deviceType, deviceTypeIdentifier)) continue;
            decorations.put(priority, dec);
        }
        if (decorations.size() > 0) {
            ILookAndFeelDecorations dec;
            dec = (ILookAndFeelDecorations)decorations.get(decorations.lastKey());
            if (dec.getMandatoryFieldBackgroundColor() != null) {
                uiDecoration.setMandatoryFieldBackgroundColor(dec.getMandatoryFieldBackgroundColor());
            }
            if (dec.getMandatoryLabelFont() != null) {
                uiDecoration.setMandatoryLabelFont(dec.getMandatoryLabelFont());
            }
            if (dec.getMandatoryLabelTextColor() != null) {
                uiDecoration.setMandatoryLabelTextColor(dec.getMandatoryLabelTextColor());
            }
            if (dec.getStarMarkerPosition() != 0) {
                uiDecoration.setMandatoryStarMarkerPosition(dec.getStarMarkerPosition());
            }
        }
    }

    private static boolean isPropsAlreadLoaded(TreeMap<Integer, ILookAndFeelProperties> properties, Integer priority, String deviceTypeIdentifier) {
        ILookAndFeelProperties alreadyLoadedProps = properties.get(priority);
        if (alreadyLoadedProps == null) {
            return false;
        }
        if (deviceTypeIdentifier != null && alreadyLoadedProps.getDeviceTypeIdentifier().equalsIgnoreCase(deviceTypeIdentifier)) {
            return true;
        }
        return true;
    }

    private static boolean isDecosAlreadLoaded(TreeMap<Integer, ILookAndFeelDecorations> docorations, Integer priority, String deviceTypeIdentifier) {
        ILookAndFeelDecorations alreadyLoadedDecos = docorations.get(priority);
        if (alreadyLoadedDecos == null) {
            return false;
        }
        if (deviceTypeIdentifier != null && alreadyLoadedDecos.getDeviceTypeIdentifier().equalsIgnoreCase(deviceTypeIdentifier)) {
            return true;
        }
        return true;
    }

    private static boolean matchesDeviceType(IUiDeviceType uiDeviceType, String deviceTypeIdentifier) {
        if (deviceTypeIdentifier == null) {
            return true;
        }
        if (uiDeviceType.getIdentifier().equalsIgnoreCase(deviceTypeIdentifier)) {
            return true;
        }
        return deviceTypeIdentifier.equalsIgnoreCase(ATTR_DEVICE_TYPE_KEYWORD_TOUCH) && uiDeviceType.isTouchDevice();
    }

    private static int computePriority(int scope, String deviceTypeIdentifier) {
        if (!StringUtility.hasText((CharSequence)deviceTypeIdentifier)) {
            return scope;
        }
        if (UiDecorationExtensionPoint.isCombinedDeviceTypeIdentifier(deviceTypeIdentifier)) {
            return scope + 1;
        }
        return scope + 2;
    }

    private static boolean isCombinedDeviceTypeIdentifier(String deviceTypeIdentifier) {
        if (deviceTypeIdentifier == null) {
            return false;
        }
        return deviceTypeIdentifier.equalsIgnoreCase(ATTR_DEVICE_TYPE_KEYWORD_TOUCH);
    }
}

