/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.numberfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.text.DecimalFormat;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetDataUtil;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutContextMenu;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.numberfield.IRwtScoutNumberField;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;

public class RwtScoutNumberField
extends RwtScoutBasicFieldComposite<INumberField<?>>
implements IRwtScoutNumberField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutNumberField.class);
    private TextFieldEditableSupport m_editableSupport;
    private static volatile String clientVerifyScript;
    private static final Object LOCK;
    private RwtContextMenuMarkerComposite m_menuMarkerComposite;
    private RwtScoutContextMenu m_uiContextMenu;
    private P_ContextMenuPropertyListener m_contextMenuPropertyListener;
    public static final String PROP_MAX_INTEGER_DIGITS = "RwtScoutNumberField.maxInt";
    public static final String PROP_MAX_FRACTION_DIGITS = "RwtScoutNumberField.maxFra";
    public static final String PROP_ZERO_DIGIT = "RwtScoutNumberField.zeroDig";
    public static final String PROP_DECIMAL_SEPARATOR = "RwtScoutNumberField.decSep";

    static {
        LOCK = new Object();
    }

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_menuMarkerComposite = new RwtContextMenuMarkerComposite(container, this.getUiEnvironment());
        this.getUiEnvironment().getFormToolkit().adapt(this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.setData("org.eclipse.rap.rwt.customVariant", "numberfield");
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if (RwtScoutNumberField.this.getUiContextMenu() != null) {
                    Menu uiMenu = RwtScoutNumberField.this.getUiContextMenu().getUiMenu();
                    if (e.widget instanceof Control) {
                        Point loc = ((Control)e.widget).toDisplay(e.x, e.y);
                        uiMenu.setLocation(RwtMenuUtility.getMenuLocation(((INumberField)RwtScoutNumberField.this.getScoutObject()).getContextMenu().getChildActions(), uiMenu, loc, RwtScoutNumberField.this.getUiEnvironment()));
                    }
                    uiMenu.setVisible(true);
                }
            }
        });
        int style = 0;
        StyledText textField = this.getUiEnvironment().getFormToolkit().createStyledText(this.m_menuMarkerComposite, style |= RwtUtility.getHorizontalAlignment(((INumberField)this.getScoutObject()).getGridData().horizontalAlignment));
        this.installClientScripting(textField);
        this.attachFocusListener((Control)textField, true);
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)textField);
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
    }

    @Override
    public StyledText getUiField() {
        return (StyledText)super.getUiField();
    }

    public RwtScoutContextMenu getUiContextMenu() {
        return this.m_uiContextMenu;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.handleDecimalFormatChanged(((INumberField)this.getScoutObject()).getFormat());
        this.updateContextMenuVisibilityFromScout();
        if (((INumberField)this.getScoutObject()).getContextMenu() != null && this.m_contextMenuPropertyListener == null) {
            this.m_contextMenuPropertyListener = new P_ContextMenuPropertyListener();
            ((INumberField)this.getScoutObject()).getContextMenu().addPropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_contextMenuPropertyListener != null) {
            ((INumberField)this.getScoutObject()).getContextMenu().removePropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
            this.m_contextMenuPropertyListener = null;
        }
        super.detachScout();
    }

    protected void installClientScripting(StyledText text) {
        String js = RwtScoutNumberField.getVerifyClientScript();
        if (js != null) {
            text.addListener(25, (Listener)new ClientListener(js));
            WidgetDataUtil.registerDataKeys((String[])new String[]{PROP_MAX_INTEGER_DIGITS, PROP_MAX_FRACTION_DIGITS, PROP_ZERO_DIGIT, PROP_DECIMAL_SEPARATOR});
            text.addVerifyListener(new P_VerifyListener());
        }
    }

    protected void updateContextMenuVisibilityFromScout() {
        this.m_menuMarkerComposite.setMarkerVisible(((INumberField)this.getScoutObject()).getContextMenu().isVisible());
        if (((INumberField)this.getScoutObject()).getContextMenu().isVisible()) {
            if (this.m_uiContextMenu == null) {
                this.m_uiContextMenu = new RwtScoutContextMenu(this.getUiField().getShell(), (IContextMenu)((INumberField)this.getScoutObject()).getContextMenu(), this.getUiEnvironment());
            }
        } else {
            if (this.m_uiContextMenu != null) {
                this.m_uiContextMenu.dispose();
            }
            this.m_uiContextMenu = null;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("decimalFormat".equals(name)) {
            this.handleDecimalFormatChanged((DecimalFormat)newValue);
        }
    }

    protected void handleDecimalFormatChanged(DecimalFormat format) {
        this.getUiField().setData(PROP_MAX_INTEGER_DIGITS, format.getMaximumIntegerDigits());
        this.getUiField().setData(PROP_MAX_FRACTION_DIGITS, format.getMaximumFractionDigits());
        this.getUiField().setData(PROP_ZERO_DIGIT, "" + format.getDecimalFormatSymbols().getZeroDigit());
        this.getUiField().setData(PROP_DECIMAL_SEPARATOR, "" + format.getDecimalFormatSymbols().getDecimalSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVerifyClientScript() {
        if (clientVerifyScript == null) {
            Object object = LOCK;
            synchronized (object) {
                if (clientVerifyScript == null) {
                    try {
                        String content;
                        InputStream is = RwtScoutNumberField.class.getClassLoader().getResourceAsStream("org/eclipse/scout/rt/ui/rap/form/fields/numberfield/RwtScoutNumberField.js");
                        clientVerifyScript = content = IOUtility.getContentUtf8((InputStream)is);
                    }
                    catch (ProcessingException e) {
                        LOG.error("Unable to read NumberField client verify script.", (Throwable)e);
                    }
                }
            }
        }
        return clientVerifyScript;
    }

    @Override
    protected void setFieldEnabled(Control field, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        if (b) {
            this.m_menuMarkerComposite.setData("org.eclipse.rap.rwt.customVariant", "numberfield");
        } else {
            this.m_menuMarkerComposite.setData("org.eclipse.rap.rwt.customVariant", "numberfield-disabled");
        }
    }

    private class P_ContextMenuPropertyListener
    implements PropertyChangeListener {
        private P_ContextMenuPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                RwtScoutNumberField.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutNumberField.this.updateContextMenuVisibilityFromScout();
                    }
                });
            }
        }
    }

    private class P_VerifyListener
    implements VerifyListener {
        private static final long serialVersionUID = 1L;

        private P_VerifyListener() {
        }

        private boolean textWasPasted(VerifyEvent e) {
            return StringUtility.length((CharSequence)e.text) > 1;
        }

        public void verifyText(VerifyEvent e) {
            String curText = ((StyledText)e.widget).getText();
            if (this.textWasPasted(e)) {
                try {
                    AbstractNumberField.createNumberWithinFormatLimits((DecimalFormat)((INumberField)RwtScoutNumberField.this.getScoutObject()).getFormat(), (String)curText, (int)e.start, (int)(e.end - e.start), (String)e.text);
                }
                catch (ProcessingException exception) {
                    e.doit = false;
                    MessageBox box = new MessageBox(e.display.getActiveShell(), 32);
                    box.setText(TEXTS.get((String)"Paste"));
                    box.setMessage(RwtUtility.getNlsText(e.display, "PasteTextNotApplicableForNumberField", String.valueOf(((INumberField)RwtScoutNumberField.this.getScoutObject()).getFormat().getMaximumIntegerDigits())));
                    box.open();
                }
            }
        }
    }
}

