/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.sequencebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.rap.form.fields.sequencebox.IRwtScoutSequenceBox;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutSequenceBox
extends RwtScoutFieldComposite<ISequenceBox>
implements IRwtScoutSequenceBox {
    private PropertyChangeListener m_changeListener;
    private Map<IFormField, IRwtScoutFormField> m_fieldMap = new HashMap<IFormField, IRwtScoutFormField>();

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        Composite fieldContainer = this.getUiEnvironment().getFormToolkit().createComposite(container);
        for (IFormField scoutField : this.getScoutObject().getFields()) {
            IRwtScoutFormField childFormField = this.getUiEnvironment().createFormField(fieldContainer, scoutField);
            this.m_fieldMap.put(scoutField, childFormField);
            ILabelComposite childLabel = childFormField.getUiLabel();
            if (childLabel != null) {
                childLabel.setGrabHorizontalEnabled(false);
                if (childLabel.getLayoutData() instanceof LogicalGridData) {
                    ((LogicalGridData)childLabel.getLayoutData()).widthHint = 0;
                }
            }
            final boolean checkbox = scoutField instanceof IBooleanField;
            RwtScoutFormFieldGridData data = new RwtScoutFormFieldGridData(scoutField){

                @Override
                public void validate() {
                    super.validate();
                    this.useUiWidth = !RwtScoutSequenceBox.this.getScoutObject().isEqualColumnWidths() || checkbox;
                    this.useUiHeight = true;
                    this.weightx = checkbox ? 0.0 : this.weightx;
                }
            };
            childFormField.getUiContainer().setLayoutData((Object)data);
        }
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)fieldContainer);
        fieldContainer.setLayout((Layout)new LogicalGridLayout(this.getGridColumnGapInPixel(), 0));
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.applyInheritedDecoration();
    }

    protected int getGridColumnGapInPixel() {
        return 6;
    }

    private boolean removeLabelCompletely(IRwtScoutFormField rwtScoutFormField) {
        if (rwtScoutFormField == null) {
            return false;
        }
        if (!(rwtScoutFormField.getScoutObject() instanceof IFormField)) {
            return false;
        }
        IFormField formField = (IFormField)rwtScoutFormField.getScoutObject();
        return formField instanceof IBooleanField;
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    @Override
    public ISequenceBox getScoutObject() {
        return (ISequenceBox)super.getScoutObject();
    }

    public void applyInheritedDecoration() {
        for (IFormField field : this.getScoutObject().getFields()) {
            ILabelComposite label = this.m_fieldMap.get(field).getUiLabel();
            if (label == null) continue;
            this.m_fieldMap.get(field).getUiLabel().setStatusVisible(field.isMandatory() || field.getErrorStatus() != null);
        }
        boolean inheritedMandatory = false;
        IProcessingStatus inheritedErrorStatus = null;
        for (IFormField candidate : this.getScoutObject().getFields()) {
            if (!candidate.isVisible() || this.m_fieldMap.get(candidate).getUiLabel() == null) continue;
            this.m_fieldMap.get(candidate).getUiLabel().setStatusVisible(false);
            inheritedMandatory = candidate.isMandatory();
            inheritedErrorStatus = candidate.getErrorStatus();
            break;
        }
        this.setMandatoryFromScout(inheritedMandatory);
        this.setErrorStatusFromScout(inheritedErrorStatus);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        if (this.getUiLabel() != null && this.getUiLabel().getEnabled() != b) {
            this.getUiLabel().setEnabled(b);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.m_changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutSequenceBox.this.applyInheritedDecoration();
                    }
                };
                RwtScoutSequenceBox.this.getUiEnvironment().invokeUiLater(j);
            }
        };
        for (IFormField f : this.getScoutObject().getFields()) {
            f.addPropertyChangeListener("visible", this.m_changeListener);
            f.addPropertyChangeListener("labelVisible", this.m_changeListener);
            f.addPropertyChangeListener("label", this.m_changeListener);
            f.addPropertyChangeListener("mandatory", this.m_changeListener);
            f.addPropertyChangeListener("errorStatus", this.m_changeListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_changeListener != null) {
            for (IFormField f : this.getScoutObject().getFields()) {
                f.addPropertyChangeListener("visible", this.m_changeListener);
                f.addPropertyChangeListener("labelVisible", this.m_changeListener);
                f.addPropertyChangeListener("label", this.m_changeListener);
                f.addPropertyChangeListener("mandatory", this.m_changeListener);
                f.addPropertyChangeListener("errorStatus", this.m_changeListener);
            }
            this.m_changeListener = null;
        }
        super.detachScout();
    }

    @Override
    protected void updateKeyStrokesFromScout() {
    }
}

