/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.internal.servletfilter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.commons.servletfilter.ServletFilterDelegate;

public class DelegateFilter
implements Filter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DelegateFilter.class);
    private ServletContext m_servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        new ServletFilterDelegate().delegateServiceMethod(request, response, new ServletFilterDelegate.IServiceCallback(){

            public void service(ServletRequest reqInner, ServletResponse resInner) throws ServletException, IOException {
                HttpServletRequest httpServletRequest = (HttpServletRequest)reqInner;
                String userAgent = "";
                String remoteAddr = "";
                if (httpServletRequest != null) {
                    userAgent = httpServletRequest.getHeader("User-Agent");
                    remoteAddr = httpServletRequest.getRemoteAddr();
                }
                try {
                    chain.doFilter(reqInner, resInner);
                }
                catch (ServletException e) {
                    LOG.error("ServletException\n UserAgent: {0}\nRemoteIP: {1}", (Object)userAgent, (Object)remoteAddr);
                    throw e;
                }
                catch (IOException e) {
                    LOG.error("IOException\n UserAgent: {0}\nRemoteIP: {1}", (Object)userAgent, (Object)remoteAddr);
                    throw e;
                }
                catch (IllegalStateException e) {
                    LOG.error("IllegalStateException\n UserAgent: {0}\nRemoteIP: {1}", (Object)userAgent, (Object)remoteAddr);
                    throw e;
                }
            }

            public ServletContext getServletContext() {
                return DelegateFilter.this.m_servletContext;
            }
        });
    }

    public void destroy() {
    }
}

