/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import org.eclipse.rap.rwt.RWT;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;

public class DeviceUtility {
    public static final String SESSION_ATTR_DEVICE_TYPE = "device-type";

    private DeviceUtility() {
    }

    public static IUiDeviceType getCurrentDeviceType() {
        return (IUiDeviceType)RWT.getUISession().getAttribute(SESSION_ATTR_DEVICE_TYPE);
    }

    public static void setCurrentDeviceType(IUiDeviceType uiDeviceType) {
        RWT.getUISession().setAttribute(SESSION_ATTR_DEVICE_TYPE, (Object)uiDeviceType);
    }

    public static boolean isMobileOrTabletDevice() {
        IUiDeviceType currentDeviceType = DeviceUtility.getCurrentDeviceType();
        return UiDeviceType.MOBILE.equals((Object)currentDeviceType) || UiDeviceType.TABLET.equals((Object)currentDeviceType);
    }

    public static boolean isMobileDevice() {
        IUiDeviceType currentDeviceType = DeviceUtility.getCurrentDeviceType();
        return UiDeviceType.MOBILE.equals((Object)currentDeviceType);
    }

    public static boolean isTabletDevice() {
        IUiDeviceType currentDeviceType = DeviceUtility.getCurrentDeviceType();
        return UiDeviceType.TABLET.equals((Object)currentDeviceType);
    }
}

