/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.navigation;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.BrowserNavigationEvent;
import org.eclipse.rap.rwt.client.service.BrowserNavigationListener;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryEvent;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryListener;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.service.SERVICES;

public class RwtScoutNavigationSupport {
    private final IRwtEnvironment m_uiEnvironment;
    private BrowserNavigation m_uiNavigation;
    private INavigationHistoryService m_historyService;
    private P_NavigationHistoryListener m_scoutListener;
    private BrowserNavigationListener m_uiNavigationListener = new BrowserNavigationListener(){
        private static final long serialVersionUID = 1L;

        public void navigated(BrowserNavigationEvent event) {
            RwtScoutNavigationSupport.this.handleNavigationFromUi(event.getState());
        }
    };

    public RwtScoutNavigationSupport(IRwtEnvironment uiEnvironment) {
        this.m_uiEnvironment = uiEnvironment;
    }

    public void install() {
        if (this.m_uiNavigation == null) {
            this.m_uiNavigation = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
            if (this.m_uiNavigation != null) {
                this.m_uiNavigation.addBrowserNavigationListener(this.m_uiNavigationListener);
            }
        }
        this.m_uiEnvironment.invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                RwtScoutNavigationSupport.this.m_historyService = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
                if (RwtScoutNavigationSupport.this.m_scoutListener == null) {
                    RwtScoutNavigationSupport.this.m_scoutListener = new P_NavigationHistoryListener();
                    RwtScoutNavigationSupport.this.m_historyService.addNavigationHistoryListener((NavigationHistoryListener)RwtScoutNavigationSupport.this.m_scoutListener);
                }
            }
        }, 0L);
    }

    public void uninstall() {
        new ClientSyncJob("", this.getUiEnvironment().getClientSession()){

            protected void runVoid(IProgressMonitor monitor) {
                if (RwtScoutNavigationSupport.this.m_historyService != null && RwtScoutNavigationSupport.this.m_scoutListener != null) {
                    RwtScoutNavigationSupport.this.m_historyService.removeNavigationHistoryListener((NavigationHistoryListener)RwtScoutNavigationSupport.this.m_scoutListener);
                }
            }
        }.runNow((IProgressMonitor)new NullProgressMonitor());
        if (this.m_uiNavigation != null) {
            this.m_uiNavigation.removeBrowserNavigationListener(this.m_uiNavigationListener);
        }
    }

    protected void handleNavigationFromUi(final String state) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    for (Bookmark b : RwtScoutNavigationSupport.this.m_historyService.getBookmarks()) {
                        if (!RwtScoutNavigationSupport.this.getId(b).equals(state)) continue;
                        RwtScoutNavigationSupport.this.m_historyService.stepTo(b);
                        break;
                    }
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    protected void handleBookmarkAddedFromScout(Bookmark bookmark) {
        String id = this.getId(bookmark);
        this.m_uiNavigation.pushState(id, null);
    }

    private String cleanNl(String s) {
        s = s.replaceAll("(\r\n)|(\n\r)|(\n)|(\r)", " -");
        return s;
    }

    private String cleanBrowserSpecialChars(String s) {
        s = s.replaceAll("\\s*\\-\\s*", "-");
        s = s.replaceAll("\\s+", "-");
        s = s.replaceAll(",", "");
        return s;
    }

    private String getId(Bookmark b) {
        List path;
        StringBuilder key = new StringBuilder();
        if (!StringUtility.isNullOrEmpty((CharSequence)b.getOutlineClassName())) {
            key.append(b.getOutlineClassName());
        }
        if (!(path = b.getPath()).isEmpty()) {
            int i = 0;
            while (i < path.size()) {
                if (!StringUtility.isNullOrEmpty((CharSequence)((AbstractPageState)path.get(i)).getLabel())) {
                    key.append("-" + ((AbstractPageState)path.get(i)).getLabel());
                }
                ++i;
            }
        }
        return this.cleanBrowserSpecialChars(this.cleanNl(key.toString()));
    }

    private class P_NavigationHistoryListener
    implements NavigationHistoryListener {
        private P_NavigationHistoryListener() {
        }

        public void navigationChanged(NavigationHistoryEvent e) {
            if (e.getType() == 20) {
                final Bookmark bookmark = e.getBookmark();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutNavigationSupport.this.handleBookmarkAddedFromScout(bookmark);
                    }
                };
                RwtScoutNavigationSupport.this.getUiEnvironment().invokeUiLater(r);
            }
        }
    }
}

