/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.filedownloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.window.filedownloader.RwtScoutDownloadDialog;
import org.eclipse.swt.widgets.Display;

public class RwtScoutDownloadHandler
implements ServiceHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDownloadHandler.class);
    private File m_file;
    private URI m_bundleURI;
    private final String m_fileName;
    private final String m_contentType;
    private final String m_requestId;
    private RwtScoutDownloadDialog m_sdd;

    private RwtScoutDownloadHandler(String id, String contentType, String fileName) {
        this.m_requestId = id;
        this.m_fileName = fileName;
        this.m_contentType = contentType;
    }

    public RwtScoutDownloadHandler(String id, File file, String contentType, String fileName) {
        this(id, contentType, fileName);
        this.m_file = file;
    }

    public RwtScoutDownloadHandler(String id, URI bundleURI, String contentType, String fileName) {
        this(id, contentType, fileName);
        this.m_bundleURI = bundleURI;
    }

    public void startDownload() {
        RWT.getServiceManager().unregisterServiceHandler(this.m_requestId);
        if (this.m_sdd != null) {
            this.m_sdd.close();
            this.m_sdd = null;
        }
        RWT.getServiceManager().registerServiceHandler(this.m_requestId, (ServiceHandler)this);
        this.m_sdd = new RwtScoutDownloadDialog(null, this.getURL());
        this.m_sdd.open();
    }

    protected String getURL() {
        StringBuilder url = new StringBuilder();
        url.append("?");
        url.append("servicehandler");
        url.append("=");
        try {
            url.append(URLEncoder.encode(this.m_requestId, "UTF-8").replace("+", "%20"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String connectionId = ((UISessionImpl)ContextProvider.getUISession()).getConnectionId();
        if (connectionId != null) {
            url.append('&');
            url.append("cid");
            url.append('=');
            url.append(connectionId);
        }
        String decodedURL = ContextProvider.getResponse().encodeURL(url.toString());
        String encodedURL = RWT.getResponse().encodeURL(decodedURL);
        return encodedURL;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.writeResponse(response);
        }
        catch (Throwable throwable) {
            if (this.m_sdd != null) {
                Display display = this.m_sdd.getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutDownloadHandler.this.m_sdd.close();
                        RwtScoutDownloadHandler.this.m_sdd = null;
                    }
                });
            }
            RWT.getServiceManager().unregisterServiceHandler(this.m_requestId);
            throw throwable;
        }
        if (this.m_sdd != null) {
            Display display = this.m_sdd.getShell().getDisplay();
            display.asyncExec(new /* invalid duplicate definition of identical inner class */);
        }
        RWT.getServiceManager().unregisterServiceHandler(this.m_requestId);
    }

    protected void writeResponse(HttpServletResponse response) throws IOException {
        if (StringUtility.hasText((CharSequence)this.m_contentType)) {
            response.setContentType(this.m_contentType);
        } else {
            response.setContentType("application/octet-stream");
        }
        String contentDisposition = "attachment; filename=\"" + this.m_fileName + "\"";
        response.setHeader("Content-Disposition", contentDisposition);
        ServletOutputStream outStream = response.getOutputStream();
        InputStream srcStream = null;
        if (this.m_file != null) {
            srcStream = new FileInputStream(this.m_file);
            if (this.m_file.length() < Integer.MAX_VALUE) {
                response.setContentLength((int)this.m_file.length());
            }
        } else if (this.m_bundleURI != null) {
            srcStream = this.m_bundleURI.toURL().openStream();
        }
        if (srcStream != null) {
            try {
                try {
                    byte[] content = new byte[1024];
                    int bytesRead = 0;
                    while ((bytesRead = srcStream.read(content)) > 0) {
                        outStream.write(content, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    LOG.error("IOEception while writing file.", (Throwable)e);
                    srcStream.close();
                }
            }
            finally {
                srcStream.close();
            }
        }
    }
}

