/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.popup;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartEvent;
import org.eclipse.scout.rt.ui.rap.window.popup.RwtScoutPopup;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class RwtScoutDropDownPopup
extends RwtScoutPopup {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDropDownPopup.class);
    private Control m_focusComponent;
    private FocusListener m_focusComponentListener;
    private boolean m_nonFocusable;
    private P_ScrollBarListener m_scrollbarListener;

    public void createPart(IForm scoutForm, Control ownerComponent, Control focusComponent, int style, IRwtEnvironment uiEnvironment) {
        super.createPart(scoutForm, ownerComponent, ownerComponent.getBounds(), style, uiEnvironment);
        this.m_focusComponent = focusComponent;
        this.getShell().setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot((Composite)this.getShell()){

            @Override
            public void validate() {
                RwtScoutDropDownPopup.this.autoAdjustBounds();
            }
        });
    }

    public void makeNonFocusable() {
        this.m_nonFocusable = true;
    }

    @Override
    protected void handleUiWindowOpened() {
        if (this.getOwnerComponent() != null && !this.getOwnerComponent().isDisposed()) {
            if (this.m_scrollbarListener == null) {
                this.m_scrollbarListener = new P_ScrollBarListener();
            }
            this.reqAddScrollbarListener(this.m_scrollbarListener, this.getOwnerComponent());
            this.getOwnerComponent().getShell().addListener(10, (Listener)this.m_scrollbarListener);
        }
        this.installFocusListener();
        super.handleUiWindowOpened();
        if (this.m_nonFocusable) {
            Shell shell = this.getShell();
            Shell activeShell = shell.getDisplay().getActiveShell();
            if (activeShell == shell) {
                this.m_focusComponent.setFocus();
            }
            if (!this.m_focusComponent.isFocusControl()) {
                this.closePart();
                this.fireRwtScoutPartEvent(new RwtScoutPartEvent(this, 50));
            }
        }
    }

    protected void installFocusListener() {
        if (this.m_focusComponentListener != null) {
            return;
        }
        if (this.m_focusComponent == null || this.m_focusComponent.isDisposed()) {
            return;
        }
        this.m_focusComponentListener = new FocusAdapter(){
            private static final long serialVersionUID = 1L;

            public void focusLost(FocusEvent e) {
                RwtScoutDropDownPopup.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (RwtScoutDropDownPopup.this.getShell().isDisposed()) {
                            return;
                        }
                        if (RwtScoutDropDownPopup.this.getShell() == RwtScoutDropDownPopup.this.getShell().getDisplay().getActiveShell()) {
                            Control c = RwtScoutDropDownPopup.this.getShell().getDisplay().getFocusControl();
                            if (c != null && c != RwtScoutDropDownPopup.this.getShell() && c.getShell() == RwtScoutDropDownPopup.this.getShell()) {
                                c.addMouseListener((MouseListener)new MouseAdapter(){
                                    private static final long serialVersionUID = 1L;

                                    public void mouseUp(MouseEvent event) {
                                        if (!((Control)event.getSource()).isDisposed()) {
                                            ((Control)event.getSource()).removeMouseListener((MouseListener)this);
                                        }
                                        if (!RwtScoutDropDownPopup.this.m_focusComponent.isDisposed()) {
                                            RwtScoutDropDownPopup.this.m_focusComponent.setFocus();
                                        }
                                    }
                                });
                            } else {
                                RwtScoutDropDownPopup.this.m_focusComponent.setFocus();
                            }
                        } else {
                            RwtScoutDropDownPopup.this.closePart();
                            RwtScoutDropDownPopup.this.fireRwtScoutPartEvent(new RwtScoutPartEvent(RwtScoutDropDownPopup.this, 50));
                        }
                    }
                });
            }
        };
        this.m_focusComponent.addFocusListener(this.m_focusComponentListener);
    }

    protected void uninstallFocusLostListener() {
        if (this.m_focusComponent == null || this.m_focusComponentListener == null) {
            return;
        }
        if (!this.m_focusComponent.isDisposed()) {
            this.m_focusComponent.removeFocusListener(this.m_focusComponentListener);
        }
        this.m_focusComponentListener = null;
    }

    @Override
    protected void handleUiWindowClosed() {
        if (this.getOwnerComponent() != null && !this.getOwnerComponent().isDisposed() && this.m_scrollbarListener != null) {
            this.reqRemoveScrollbarListener(this.m_scrollbarListener, this.getOwnerComponent());
            if (this.getOwnerComponent().getShell() != null && !this.getOwnerComponent().getShell().isDisposed()) {
                this.getOwnerComponent().getShell().removeListener(10, (Listener)this.m_scrollbarListener);
            }
        }
        this.m_scrollbarListener = null;
        this.uninstallFocusLostListener();
        super.handleUiWindowClosed();
    }

    private void reqRemoveScrollbarListener(Listener l, Control control) {
        if (!(control instanceof Composite)) {
            return;
        }
        Composite composite = (Composite)control;
        if (composite instanceof SharedScrolledComposite) {
            ScrollBar vBar;
            composite.removeListener(11, l);
            composite.removeListener(10, l);
            ScrollBar hBar = composite.getHorizontalBar();
            if (hBar != null) {
                hBar.removeListener(13, l);
            }
            if ((vBar = composite.getVerticalBar()) != null) {
                vBar.removeListener(13, l);
            }
        }
        this.reqRemoveScrollbarListener(l, (Control)composite.getParent());
    }

    private void reqAddScrollbarListener(Listener l, Control control) {
        if (!(control instanceof Composite)) {
            return;
        }
        Composite composite = (Composite)control;
        if (composite instanceof SharedScrolledComposite) {
            ScrollBar vBar;
            control.addListener(11, l);
            control.addListener(10, l);
            ScrollBar hBar = composite.getHorizontalBar();
            if (hBar != null) {
                hBar.addListener(13, l);
            }
            if ((vBar = composite.getVerticalBar()) != null) {
                vBar.addListener(13, l);
            }
        }
        this.reqAddScrollbarListener(l, (Control)control.getParent());
    }

    private class P_ScrollBarListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_ScrollBarListener() {
        }

        public void handleEvent(Event event) {
            RwtScoutDropDownPopup.this.closePart();
        }
    }
}

