/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar;

import java.awt.Color;
import java.util.ArrayList;
import org.eclipse.scout.commons.StringUtility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGStylable;

public final class CalendarSvgUtility {
    public static final String COLOR_PREFIX = "#";

    private CalendarSvgUtility() {
    }

    private static String ensureColorPrefix(String color) {
        if (!color.startsWith(COLOR_PREFIX)) {
            color = COLOR_PREFIX + color;
        }
        return color;
    }

    public static void clearChildNodes(Element e) {
        Node n = null;
        while ((n = e.getFirstChild()) != null) {
            e.removeChild(n);
        }
    }

    public static void setCalendarDisplayModeXPos(Element e, float x) {
        CalendarSvgUtility.setTextPos(e, x, 465.908f);
    }

    public static void setTextPos(Element e, float x, float y) {
        e.setAttribute("transform", "matrix(1 0 0 1 " + x + " " + y + ")");
    }

    public static void setBorderMiter(Element e, int miter) {
        SVGStylable css = (SVGStylable)e;
        css.getStyle().setProperty("stroke-miterlimit", "" + miter, "");
    }

    public static void setFont(Element element, String font) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("font-family", font, "");
    }

    public static void removeBorder(Element element) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().removeProperty("stroke");
        css.getStyle().removeProperty("stroke-miterlimit");
    }

    public static void setFontWeightBold(Element element) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("font-weight", "bolder", "");
    }

    public static void setFontWeightNormal(Element element) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("font-weight", "normal", "");
    }

    public static void setFontSize(Element element, float size) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("font-size", "" + size, "");
    }

    public static void setFontColor(Element element, String color, boolean darken) {
        if (darken) {
            color = CalendarSvgUtility.getDarkerCopy(color);
        }
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("fill", CalendarSvgUtility.ensureColorPrefix(color), "");
    }

    public static void setFontColor(Element element, String color) {
        CalendarSvgUtility.setFontColor(element, color, false);
    }

    public static void setTextAlignCenter(Element element) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("text-anchor", "middle", "");
    }

    public static void setTextAlignRight(Element element) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("text-anchor", "end", "");
    }

    public static void setBorderColor(Element element, String color) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("stroke", CalendarSvgUtility.ensureColorPrefix(color), "");
    }

    public static void clearBackgroundColor(Element element) {
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("fill", "none", "");
    }

    public static void setBackgroundColor(Element element, String color) {
        CalendarSvgUtility.setBackgroundColor(element, color, false);
    }

    public static void setBackgroundColor(Element element, String color, boolean darken) {
        if (darken) {
            color = CalendarSvgUtility.getDarkerCopy(color);
        }
        SVGStylable css = (SVGStylable)element;
        css.getStyle().setProperty("fill", CalendarSvgUtility.ensureColorPrefix(color), "");
    }

    public static Element[] getAllChildElements(Element root, String tagName) {
        ArrayList<Element> collector = new ArrayList<Element>();
        CalendarSvgUtility.getAllChildElementsRec(root, tagName, collector);
        return collector.toArray(new Element[collector.size()]);
    }

    private static String getDarkerCopy(String color) {
        Color orig = Color.decode(CalendarSvgUtility.ensureColorPrefix(color)).darker();
        return COLOR_PREFIX + CalendarSvgUtility.colorToHexString(orig);
    }

    private static void getAllChildElementsRec(Element root, String tagName, ArrayList<Element> collector) {
        int i = 0;
        while (i < root.getChildNodes().getLength()) {
            Node childNode = root.getChildNodes().item(i);
            if (childNode instanceof Element) {
                Element child = (Element)childNode;
                if (child.getNodeName().equals(tagName)) {
                    collector.add(child);
                }
                CalendarSvgUtility.getAllChildElementsRec(child, tagName, collector);
            }
            ++i;
        }
    }

    private static String colorToHexString(Color c) {
        if (c == null) {
            return null;
        }
        int rgb = c.getRGB() & 0xFFFFFF;
        return StringUtility.lpad((String)Integer.toHexString(rgb), (String)"0", (int)6);
    }
}

