/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;

public class SwingPopupWorker
implements Runnable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingPopupWorker.class);
    private final EventListenerList m_listeners;
    private final ISwingEnvironment m_environment;
    private final Component m_target;
    private final Point m_location;
    private final IContextMenu m_contextMenu;
    private final List<? extends IMenu> m_scoutMenus;
    private final Set<? extends IMenuType> m_menuTypes;
    private JTextComponent m_systemMenuOwner;
    private boolean m_isLightWeightPopup;

    public SwingPopupWorker(ISwingEnvironment environment, Component target, Point location, IContextMenu contextMenu) {
        this(environment, target, location, contextMenu, null);
    }

    public SwingPopupWorker(ISwingEnvironment environment, Component target, Point location, IContextMenu contextMenu, Set<? extends IMenuType> menuTypes) {
        this(environment, target, location, contextMenu, contextMenu.getChildActions(), menuTypes);
    }

    public SwingPopupWorker(ISwingEnvironment environment, Component target, Point location, List<IMenu> scoutMenus) {
        this(environment, target, location, scoutMenus, null);
    }

    public SwingPopupWorker(ISwingEnvironment environment, Component target, Point location, List<IMenu> scoutMenus, Set<? extends IMenuType> menuTypes) {
        this(environment, target, location, null, scoutMenus, menuTypes);
    }

    private SwingPopupWorker(ISwingEnvironment environment, Component target, Point location, IContextMenu contextMenu, List<IMenu> scoutMenus, Set<? extends IMenuType> menuTypes) {
        this.m_environment = environment;
        this.m_target = target;
        this.m_location = location;
        this.m_contextMenu = contextMenu;
        this.m_scoutMenus = scoutMenus;
        this.m_menuTypes = menuTypes;
        this.m_listeners = new EventListenerList();
    }

    public ISwingEnvironment getEnvironment() {
        return this.m_environment;
    }

    public Component getTarget() {
        return this.m_target;
    }

    public Point getLocation() {
        return this.m_location;
    }

    public IContextMenu getContextMenu() {
        return this.m_contextMenu;
    }

    public List<? extends IMenu> getScoutMenus() {
        return this.m_scoutMenus;
    }

    public Set<? extends IMenuType> getMenuTypes() {
        return this.m_menuTypes;
    }

    public void setSystemMenuOwner(JTextComponent systemMenuOwner) {
        this.m_systemMenuOwner = systemMenuOwner;
    }

    public JTextComponent getSystemMenuOwner() {
        return this.m_systemMenuOwner;
    }

    public boolean isLightWeightPopup() {
        return this.m_isLightWeightPopup;
    }

    public void setLightWeightPopup(boolean isLightWeightPopup) {
        this.m_isLightWeightPopup = isLightWeightPopup;
    }

    public void addListener(PopupMenuListener l) {
        this.m_listeners.add(PopupMenuListener.class, (EventListener)l);
    }

    public void removeListener(PopupMenuListener l) {
        this.m_listeners.add(PopupMenuListener.class, (EventListener)l);
    }

    @Override
    public void run() {
        if (this.getTarget() instanceof JTextFieldEx) {
            JTextFieldEx field = (JTextFieldEx)this.getTarget();
            field.showingPopup(true);
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                final IActionFilter aboutToShowFilter = SwingPopupWorker.this.getMenuTypes() == null ? ActionUtility.TRUE_FILTER : ActionUtility.createMenuFilterMenuTypes(SwingPopupWorker.this.getMenuTypes(), (boolean)false);
                if (SwingPopupWorker.this.getContextMenu() != null) {
                    SwingPopupWorker.this.getContextMenu().callAboutToShow(aboutToShowFilter);
                } else {
                    for (IMenu m : SwingPopupWorker.this.m_scoutMenus) {
                        m.acceptVisitor(new IActionVisitor(){

                            public int visit(IAction action) {
                                if (action instanceof IMenu && aboutToShowFilter.accept(action)) {
                                    ((IMenu)action).aboutToShow();
                                    ((IMenu)action).prepareAction();
                                }
                                return 1;
                            }
                        });
                    }
                }
            }
        };
        JobEx prepareJob = this.m_environment.invokeScoutLater(t, 0L);
        try {
            prepareJob.join(1200L);
        }
        catch (InterruptedException e) {
            LOG.error("error during prepare menus.", (Throwable)e);
        }
        IActionFilter displayFilter = this.getMenuTypes() == null ? ActionUtility.createVisibleFilter() : ActionUtility.createMenuFilterMenuTypes(this.getMenuTypes(), (boolean)true);
        List normalizedMenus = ActionUtility.normalizedActions(this.getScoutMenus(), (IActionFilter)displayFilter);
        if (!CollectionUtility.hasElements((Collection)normalizedMenus) && this.getSystemMenuOwner() == null) {
            return;
        }
        JPopupMenu pop = new JPopupMenu();
        PopupMenuListener[] popupMenuListenerArray = (PopupMenuListener[])this.m_listeners.getListeners(PopupMenuListener.class);
        int n = popupMenuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PopupMenuListener l = popupMenuListenerArray[n2];
            pop.addPopupMenuListener(l);
            ++n2;
        }
        pop.setLightWeightPopupEnabled(this.isLightWeightPopup());
        for (JMenuItem item : this.getSystemMenus()) {
            pop.add(item);
        }
        if (pop.getComponentCount() > 0 && CollectionUtility.hasElements((Collection)normalizedMenus)) {
            pop.addSeparator();
        }
        this.getEnvironment().appendActions(pop, normalizedMenus, displayFilter);
        try {
            if (pop.getComponentCount() > 0) {
                Component target = this.getTarget();
                Point whereOnTarget = this.getLocation();
                if (!target.isVisible()) {
                    Component visibleAncestor = target;
                    while (visibleAncestor != null && !visibleAncestor.isVisible()) {
                        visibleAncestor = visibleAncestor.getParent();
                    }
                    whereOnTarget = SwingUtilities.convertPoint(target, whereOnTarget, visibleAncestor);
                    target = visibleAncestor;
                }
                Point compLocationOnScreen = target.getLocationOnScreen();
                Point p = new Point(whereOnTarget);
                p.translate(compLocationOnScreen.x, compLocationOnScreen.y);
                Rectangle r = new Rectangle(p, pop.getPreferredSize());
                Rectangle ownerBounds = new Rectangle(target.getLocationOnScreen().x, target.getLocationOnScreen().y, target.getWidth(), target.getHeight());
                if (target.getParent() instanceof JViewport && target.getParent().getParent() instanceof JScrollPane) {
                    Container scrollpane = target.getParent().getParent();
                    ownerBounds = new Rectangle(scrollpane.getLocationOnScreen().x, scrollpane.getLocationOnScreen().y, scrollpane.getWidth(), scrollpane.getHeight());
                }
                Rectangle ownerScreen = SwingUtility.getFullScreenBoundsFor(ownerBounds, true);
                r = SwingUtility.validateRectangleOnScreen(r, ownerScreen, true, true);
                if (r.y < ownerBounds.y && r.height > ownerBounds.height) {
                    Rectangle tmp = new Rectangle(r);
                    tmp.y = ownerBounds.y + ownerBounds.height + 2;
                    Rectangle result = SwingUtility.validateRectangleOnScreen(tmp, ownerScreen, true, true);
                    if (result.equals(tmp)) {
                        r = tmp;
                    } else {
                        tmp = new Rectangle(r);
                        tmp.y = ownerBounds.y - pop.getPreferredSize().height - 2;
                        result = SwingUtility.validateRectangleOnScreen(tmp, ownerScreen, true, true);
                        if (result.equals(tmp)) {
                            r = tmp;
                        }
                    }
                }
                p = r.getLocation();
                p.translate(-compLocationOnScreen.x, -compLocationOnScreen.y);
                pop.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        if (SwingPopupWorker.this.getTarget() instanceof JTextFieldEx) {
                            JTextFieldEx field = (JTextFieldEx)SwingPopupWorker.this.getTarget();
                            field.showingPopup(false);
                        }
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
                pop.show(target, p.x, p.y);
            }
        }
        catch (Exception e) {
            LOG.error(null, (Throwable)e);
        }
    }

    private List<JMenuItem> getSystemMenus() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        if (this.getSystemMenuOwner() != null) {
            if (this.getSystemMenuOwner().isEditable()) {
                JMenuItem cutItem = new JMenuItem(SwingUtility.getNlsText("Cut", new String[0]));
                cutItem.setEnabled(StringUtility.hasText((CharSequence)this.getSystemMenuOwner().getSelectedText()));
                cutItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        SwingPopupWorker.this.getSystemMenuOwner().cut();
                    }
                });
                items.add(cutItem);
            }
            JMenuItem copyItem = new JMenuItem(SwingUtility.getNlsText("Copy", new String[0]));
            if (this.getSystemMenuOwner().isEnabled() && this.getSystemMenuOwner().isEditable()) {
                copyItem.setEnabled(StringUtility.hasText((CharSequence)this.getSystemMenuOwner().getSelectedText()));
            }
            copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (SwingPopupWorker.this.getSystemMenuOwner().isEnabled() && SwingPopupWorker.this.getSystemMenuOwner().isEditable()) {
                        SwingPopupWorker.this.getSystemMenuOwner().copy();
                    } else {
                        boolean hasSelection = StringUtility.hasText((CharSequence)SwingPopupWorker.this.getSystemMenuOwner().getSelectedText());
                        if (hasSelection) {
                            SwingPopupWorker.this.getSystemMenuOwner().copy();
                        } else {
                            SwingPopupWorker.this.getSystemMenuOwner().selectAll();
                            SwingPopupWorker.this.getSystemMenuOwner().copy();
                            SwingPopupWorker.this.getSystemMenuOwner().select(0, 0);
                        }
                    }
                }
            });
            items.add(copyItem);
            if (this.getSystemMenuOwner().isEditable()) {
                JMenuItem pasteItem = new JMenuItem(SwingUtility.getNlsText("Paste", new String[0]));
                pasteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        SwingPopupWorker.this.getSystemMenuOwner().paste();
                    }
                });
                items.add(pasteItem);
            }
        }
        return items;
    }

    public void enqueue() {
        this.m_environment.invokeSwingLater(this);
    }
}

