/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action.menu.text;

import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class CopyMenu
extends AbstractMenu {
    private final JTextComponent m_textComponent;

    public CopyMenu(JTextComponent textComponent) {
        this.m_textComponent = textComponent;
    }

    protected String getConfiguredText() {
        return SwingUtility.getNlsText("Copy", new String[0]);
    }

    protected void execAction() throws ProcessingException {
        JTextComponent txt = this.getTextComponent();
        if (txt.isEnabled() && txt.isEditable()) {
            txt.copy();
        } else {
            boolean hasSelection = StringUtility.hasText((CharSequence)txt.getSelectedText());
            if (hasSelection) {
                txt.copy();
            } else {
                txt.selectAll();
                txt.copy();
                txt.select(0, 0);
            }
        }
    }

    public JTextComponent getTextComponent() {
        return this.m_textComponent;
    }
}

